/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "monthdb.h"
#include "cb2bib_par.h"

MonthDB::MonthDB()
{
    QString month =
        "January|February|March|April|May|June|July|August|September|October|November|December";
    FullMonth = QStringList::split( "|", month );
    month = "jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec";
    AvMonth = QStringList::split( "|", month );
}

MonthDB::~MonthDB()
{
    FullMonth.clear();
    AvMonth.clear();
}


QString MonthDB::retrieve( QString MQuery )
{
    QString Day = "";
    QRegExp day( "(\\d+)" );
    int ncap = day.search( MQuery );
    if( ncap > -1 )
    {
        Day = day.cap(1);
    }
    if ( !Day.isEmpty() )
        Day = QString(" # \"%1~\"").arg(Day.toInt());
    //     Day = QString("\"%1~\" # ").arg(Day.toInt());
    QString Month = "";
    QRegExp month( "([A-Za-z]+)" );
    ncap = month.search( MQuery );
    if( ncap > -1 )
    {
        Month = month.cap(1);
    }
    Month = abbreviate( Month );
    return ( Month + Day );
    //     return ( Day + Month );
}


QString MonthDB::abbreviate( QString MQuery )
{
    for ( int i = 0; i < 12; i++ )
    {
        if( FullMonth[i].contains( MQuery, FALSE ) )
            return( AvMonth[i] );
    }
    return( MQuery );
}
