/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef PDFIMPORT_H
#define PDFIMPORT_H

#include "pdfimportbase.h"

class c2bSettings;
class QProcess;

class PDFImport : public PDFImportBase
{

    Q_OBJECT

public:
    PDFImport(c2bSettings* settings, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~PDFImport();


public slots:
    virtual void processNext();


signals:
    void fileProcessed( const QString& fileName );
    void helpRequested( const QString& ln );
    void textProcessed( const QString& text );


protected:
    void dragEnterEvent(QDragEnterEvent*);
    void dropEvent(QDropEvent*);


private slots:
    virtual void addToLog();
    virtual void help();
    virtual void processEnded();
    virtual void processOneFile();
    virtual void selectFiles();


private:
    c2bSettings* s;
    QProcess *pdf2txt;
    QString m_pdf_dir;
    QString m_pdf_file;
    QString m_text_file;
    QString pdf2txt_name;

};

#endif
