/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef REFERENCELIST_H
#define REFERENCELIST_H

#include "referencelistbase.h"


class c2bTextEdit;
class QAction;
class QListViewItem;
class QPoint;
class QPopupMenu;


class ReferenceList : public ReferenceListBase
{
    Q_OBJECT

public:
    ReferenceList(c2bTextEdit* ed,
                  QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
    ~ReferenceList();

    QAction* citeEntry2CbAction;
    QAction* citeEntryAction;
    QAction* openDOIAction;
    QAction* openFileAction;
    QAction* openWebSearchAction;
    QAction* refreshListAction;


signals:
    void openFileRequested(const QString&);
    void statusMessage(const QString&);


public slots:
    virtual void loadList( const QString& txt );
    virtual void refreshList();
    virtual void setLyxPipe();


protected slots:
    virtual void blockComboFindSignals();
    virtual void citeEntry();
    virtual void citeEntry2Cb();
    virtual void goToEntry( QListViewItem* ref );
    virtual void openDOI();
    virtual void openFile();
    virtual void openWebSearch();
    virtual void searchInList();
    virtual void showMenu( QListViewItem* ref, const QPoint& p );


private:
    c2bTextEdit* edPtr;
    QPopupMenu* ref_list_m;
    QString lyxpipe;

};

#endif
