/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "resyntaxhighlighter.h"


reSyntaxHighlighter::reSyntaxHighlighter( QTextEdit *textEdit )
        : QSyntaxHighlighter( textEdit )
{
    text_color = textEdit->color();
}

reSyntaxHighlighter::~reSyntaxHighlighter()
{}


int reSyntaxHighlighter::highlightParagraph( const QString & text, int paraNo )
{
    int len = text.length();
    setFormat( 0, len - 1, text_color );

    QRegExp rx( "\\b(abstract|address|annote|author|booktitle|chapter|"
                "doi|edition|editor|eprint|file|institution|isbn|issn|journal|"
                "keywords|month|note|number|organization|pages|publisher|"
                "school|series|title|url|volume|year)\\b" );
    rx.setMinimal(TRUE);
    int pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.bib_reference_field_color );
            pos  += rx.matchedLength();
        }
    }

    rx = QRegExp( "\\b(article|book|booklet|conference|inbook|incollection|"
                  "inproceedings|manual|mastersthesis|misc|periodical|phdthesis|"
                  "proceedings|techreport|unpublished)\\b" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.bib_reference_type_color );
            pos  += rx.matchedLength();
        }
    }

    rx = QRegExp( "^[a-z_]+=\\S.+$" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.netqinf_command_content_color );
            pos  += rx.matchedLength();
        }
    }

    rx = QRegExp( "^[a-z_]+=" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.netqinf_command_key_color );
            pos  += rx.matchedLength();
        }
    }

    rx = QRegExp( "<<[a-z]+>>" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_tag_color );
            pos  += rx.matchedLength();
        }
    }

    rx = QRegExp( "^#.+$" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.comment_color );
            pos  += rx.matchedLength();
        }
    }

    paraNo = 0;
    return paraNo;
}

void reSyntaxHighlighter::reloadColors()
{
    c.loadColors();
    rehighlight();
}
