/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "saveregexp.h"
#include "cb2bib_par.h"
#include "resyntaxhighlighter.h"

#include <qpushbutton.h>


/*! \page regexpedit The Regular Expression Editor
 
Once a manual processing is done, cb2Bib clipboard area contains the extraction
tags, plus, possibly, some other cb2Bib tags introduced during the preprocessing
(see \ref bibproc). The <b>RegExp Editor</b> will generate a guess regular
expression or matching pattern usable for automated extractions.
 
The cb2Bib matching patterns consist of four lines: a brief description, the
reference type, an ordered list of captured fields, and the regular expression
itself.
\htmlonly
<pre style="background : #d5d5d5; border : #6D8CC3 solid 1px;">
# cb2Bib GET_VERSION Pattern:
American Chemical Society Publications
article
journal volume pages year title authors abstract
^(.+), (\d+) \(.+\), ([\d|\-|\s]+),
(\d\d\d\d)\..+&#060;NewLine3&#062;(.+)&#060;NewLine4&#062;
(.+)&#060;NewLine5&#062;.+Abstract:&#060;NewLine\d+&#062;(.+)$
</pre>
\endhtmlonly
The Regular Expression Editor provides the basic skeleton and a set of
predefined suggestions. The regular expressions follow a Perl-like sintax. There
are, however, some slight differences and minor limitations. Information about
the basics on the editing and working with Regular Expressions as used by cb2Bib
can be found at the Qt document file
\htmlonly
<a href="http://doc.trolltech.com/3.3/qregexp.html#1" 
target="_blank">http://doc.trolltech.com/3.3/qregexp.html#1</a>.
\endhtmlonly
 
Suggested regular expressions may need further editing to be effective. Some
experience though not expertice is desirable. Future cb2Bib development is
expected to facilitate the pattern manipulation and debugging.
 
<b>Remember when editting patterns:</b>
- Patterns are reloaded each time the automatic pattern recognition is started.
This permits editting and testing.
- cb2Bib patterns are general, and not necessarily the most appropriate for a
particular capture. E.g. tag <tt>pages</tt> becomes <tt>([\\d|\\-|\\s]+)</tt>,
which considers digits, hyphens, and spaces. It must be modified accordingly for
reference sources with, e.g., <tt>pages</tt> written as Roman ordinals.
- Avoid whenever possible general patterns <tt>(.+)</tt>. There is a risk that
such a caption could include text intended for a posterior caption. This is why,
sometimes, the cb2Bib proposed pattern is not hit by the input stream that
originated it.
- You can edit <tt>src/src.pro</tt> and compile cb2Bib on debug mode, by
exchanging <tt>release</tt> with <tt>debug</tt>. This prompts at the console
detailed information about what is being captured.
- On debug mode, break your regular expression to your first capturing
parenthesis. This is:
 
\htmlonly
<pre style="background : #d5d5d5; border : #6D8CC3 solid 1px;">
# cb2Bib GET_VERSION Pattern:
American Chemical Society Publications
article
journal
^(.+),
</pre>
\endhtmlonly
 
- Select your text to start cb2Bib engine. Check if anything is captured and if
this corresponds to <tt>journal</tt>.
- Add on successive steps your set of captions and BibTeX fields.
- Use, whenever possible, cb2Bib anchors like <tt>\<NewLine1\></tt> instead of
<tt>\<NewLine\\d+\></tt>. They prevent <tt>(.+)</tt> captions to overextend.
 
 
*/

SaveRegExp::SaveRegExp(QString& rx,
                       QWidget* parent, const char* name, bool modal, WFlags fl)
        : SaveRegExpbase(parent,name, modal,fl)
{
    connect( buttonHelp, SIGNAL( clicked() ), this, SLOT( Help() ));
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, WINDOWS_REGISTRY );
    QFont font;
    font.setFamily( settings.readEntry( APP_KEY + "Font0", WINDOW_FF ) );
    font.setPointSize( settings.readNumEntry( APP_KEY + "FontSize0", WINDOW_FS ) );
    RegExp->setFont( font );
    reS = new reSyntaxHighlighter( RegExp );
    RegExp->setText( rx );
}

SaveRegExp::~SaveRegExp()
{
    delete reS;
}


void SaveRegExp::accept()
{
    emit savePatternInfo( RegExp->text(), Name->text() );
    QDialog::accept();
}

void SaveRegExp::reject()
{
    QDialog::reject();
}

void SaveRegExp::Help()
{
    emit helpRequested( "http://www.molspaces.com/d_cb2bib-regexpedit.php" );
}
