/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSPDFREPORT_H
#define _KDISSPDFREPORT_H

#include <qstringlist.h>
#include <qobject.h>
#include <klibloader.h>
#include "DGenerator.h"

class kdisspdflatexarticleFactory : KLibFactory { Q_OBJECT public: QObject *createObject(QObject *, const char *, const char *, const QStringList & = QStringList()); };

class DDataItem;
/**
 * LaTeX article document generator
 *
 * @short LaTeX article document generator
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class kdisspdflatexarticle : public DGenerator
{
    public:
	kdisspdflatexarticle() : DGenerator() {}
	~kdisspdflatexarticle() {}

	const QString identifikation();
	const QString fullName();
	const QString group();
	const QString description();
	const QString quickstart();

    private:
	bool writeMaindoc(DDataItem*, const QString &);
	void writeItem(DDataItem* item, QTextStream & s, int level);

	void outputPixParagraph(DDataItem* item, QTextStream & s);
	void outputData(DDataItem* item, QTextStream & s);
	void outputLinks(DDataItem* item, QTextStream & s);
	void outputComment(DDataItem* item, QTextStream & s);
};

#endif // _KDISSPDFREPORT_H
