#include "FTPSettingsDialog.h"
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>


FTPSettingsDialog::FTPSettingsDialog( QWidget * parent , const char * name ) :
      QDialog(parent, name, FALSE)
     
  {
     
      init();
     
  }
  

  
  FTPSettingsDialog::~FTPSettingsDialog()
  {
      
  }
  
  
 void FTPSettingsDialog::init()
 {
     
   
  

     QVBoxLayout *contentPane;
      
      QGridLayout *userPane;
      QGridLayout *buttonPane; 
      QGridLayout *serverPane;
      QGridLayout *passwordPane;

     contentPane  = new QVBoxLayout(this);
     
     contentPane->setMargin( 0 );
      serverGrp = new  QGroupBox(0, Qt::Vertical, "Server address", this);
     
     serverPane = new  QGridLayout(serverGrp->layout());
      
     
 
     serverLabel = new  QLabel("Server Name:", serverGrp);
     server = new QLineEdit(serverGrp);
     
     
     serverPane->addWidget(serverLabel, 3, 0);
   
     serverPane->addMultiCellWidget(server, 3, 3, 1, 2);
      
     contentPane->addWidget(serverGrp);
 
    
     
     userGrp = new QGroupBox(0, Qt::Vertical,"User  Name", this);
    
     userPane = new  QGridLayout(userGrp->layout());
      
     
 
     userLabel = new  QLabel("User Name:", userGrp);
     user = new  QLineEdit(userGrp);
     
     
     userPane->addWidget(userLabel, 3, 0);
     
       userPane->addMultiCellWidget(user, 3, 3, 1, 2);
      
        contentPane->addWidget(userGrp);

     passwordGrp = new QGroupBox(0, Qt::Vertical,"Password", this);
    
     passwordPane = new  QGridLayout(passwordGrp->layout());
      
     
 
     passwordLabel = new  QLabel("Password:", passwordGrp);
     password = new  QLineEdit(passwordGrp);
     
     
     passwordPane->addWidget(passwordLabel, 3, 0);
     
       passwordPane->addMultiCellWidget(password, 3, 3, 1, 2);
      
        contentPane->addWidget(passwordGrp);

       buttonGrp = new QGroupBox(0, Qt::Vertical,0,this);
    
     buttonPane = new QGridLayout(buttonGrp->layout());
    
     QPushButton *save, *quit;
     save = new QPushButton( "Save", buttonGrp );
    
     
        quit = new QPushButton( "Quit", buttonGrp );
       
        connect( save, SIGNAL(clicked()),parent(), SLOT(FTP_SETTINGS()) );
        connect( quit, SIGNAL(clicked()), SLOT(slotQuit()) );
        
	buttonPane->addWidget(save,0,2);
        buttonPane->addWidget(quit,0,3);   
        contentPane->addWidget(buttonGrp);      
    
 }

 


QString FTPSettingsDialog::getServerName() 
 {
   QString line = server->text(); 
    return line;
 }
 

QString FTPSettingsDialog::getUserName() 
 {
   QString str = user->text(); 
    return str;
 } 

QString FTPSettingsDialog::getPassword() 
 {
   QString st = password->text(); 
    return st;
 } 


void FTPSettingsDialog::setServerName(QString line) 
 {
    server->setText(line); 
    
 }
 

void FTPSettingsDialog::setUserName(QString str) 
 {
    user->setText(str); 
   
 } 

void FTPSettingsDialog::setPassword(QString st) 
 {
    password->setText(st); 
    
 } 
 
 
 
void FTPSettingsDialog::slotQuit() {
  close();
}

void FTPSettingsDialog::Quit() {
  close();
}

void FTPSettingsDialog::closeEvent( QCloseEvent *event ) {
  event->accept();
}













