

#include <iostream>
#include <qvaluevector.h>
#include <qregexp.h>
#include <qstring.h>
#include <qstringlist.h>
#include "htmlSyntaxHighlighter.h"


QString hkeywords[230] = {"a","abbr","acronym","address","applet","area","b","base","basefont","bdo","big","blockquote","body","br","button","caption","center","cite","code","col","colgroup","dd","del","dfn","dir","div","dl","em","fieldset","font","form","frame","frameset","h1","h2","h3","h4","h5","h6","head","hr","html","i","iframe","img","input","ins","isindex","kbd","label","legend","li","link","map","menu","meta","noframes","noscript","object","ol","optgroup","option","p","param","pre","public","q","s","samp","script","select","small","span","strike","strong","style","sub","sup","table","tbody","td","textarea","tfoot","th","thead","title","tr","tt","u","ul","var","xml","xmlns","abbr","accept-charset","accept","accesskey","action","align","alink","alt","archive","axis","background","bgcolor","border","cellpadding","cellspacing","char","charoff","charset","checked","class","classid","clear","codebase","codetype","color","cols","colspan","compact","content","coords","data","datafld","dataformats","datapagesize","datasrc","datetime","declare","defer","disable","enctype","event","face","for","frameborder","headers","height","href","hreflang","hspace","http-equiv","id","ismap","lang","language","leftmargin","longdesc","marginwidth","marginheigth","maxlength","media","method","multiple","name","nohref","noresize","noshade","nowrap","object","onblur","onchange","onclick","ondblclick","onfocus","onkeydown","onkeypress","onkeyup","onload","onmousedown","onmousemove","onmouseover","onmouseout","onmouseup","onreset","onselect","onsubmit","onunload","profile","prompt","readonly","rel","rev","rows","rowspan","rules","scheme","scope","selected","shape","size","src","standby","start","summary","tabindex","target","text","topmargin","type","usemap","valign","value","valuetype","version","vlink","vspace","width","password","checkbox","radio","submit","reset","file","hidden","image","pulic","!doctype"  };

QChar hsymbols[2] = {'<','>'};

      
     

QValueVector<int> hdquoteStart(1);
QValueVector<int> hdquoteEnd(1);
QValueVector<int> tagStart(1);
QValueVector<int> tagEnd(1);     

htmlSyntaxHighlighter::htmlSyntaxHighlighter(QTextEdit *textEdit) 
  : QSyntaxHighlighter(textEdit) {
  return;
}



htmlSyntaxHighlighter::~htmlSyntaxHighlighter(void) {
  return;
}

int htmlSyntaxHighlighter::highlightParagraph(const QString &text, 
					     int endStateOfLastPara) {
  
  // parse lines first
  dquoteFlag = false;    
  tagFlag = false; 
  QStringList lines = QStringList::split("\n", text, TRUE);
  for(unsigned int i=0; i<lines.count(); i++) {
    
    start=0;
    place = 0;
    
    hdquoteStart.clear();
    hdquoteEnd.clear();
    
    hdquoteStart.push_back(0);
    hdquoteEnd.push_back(0);
    
    dQuoteNum = 0;
    tagNum = 0;
    tagStart.clear();
    tagEnd.clear();
    tagStart.push_back(0);
    tagEnd.push_back(0);
    
    skipTagFlag = false;
   
    skipDQuoteFlag = false;
    
    QString line = lines[i];
    if(line.isNull() || line.isEmpty()) {
      
      continue;
      
    }
    
    
    int lineLength = line.length() + 1;
    
    // now to examine this line in an inner loop
    for(int i=0; i<lineLength-1; i++) {
    
      
      QChar a = line[i];
      // if we have a first tag then we look for the second
        if ((tagFlag == true) && (a == '>')) {
	
	  tagFlag = false;
	  skipTagFlag = true;
	  tagStart.push_back(0);
	  tagEnd.push_back(0);
	  tagEnd[tagNum - 1] = tagStart[tagNum - 1] + (i - tagStart[tagNum - 1]);
	}else if (tagFlag == false) {
	  // have to check for a first tag
	  if (a == '<') {
	    tagFlag = true;
	    tagNum++;
	    // remember where the tag is
	    tagStart[tagNum -1] = i;
	  }
	}	
    
      
   
      
	
	
      
	// look for the second quote mark first if we have one already
	if ((dquoteFlag == true) && (a == '"')) {
          // this simply stops quotes in open text from getting highlighted
          // this could easily be done to ensure no highlighted quotes exist outside 
          // of tags but would envolve making the already slow highlighter even slower 
          // so i'm going to leave it like this  
          if (tagNum != 0)
	  setFormat((hdquoteStart[dQuoteNum - 1]), ((i - hdquoteStart[dQuoteNum - 1]) + 1), QColor(200,0 ,200 ));
	  dquoteFlag = false;
	  skipDQuoteFlag = true;
	  hdquoteStart.push_back(0);
	  hdquoteEnd.push_back(0);
	  hdquoteEnd[dQuoteNum - 1] = hdquoteStart[dQuoteNum - 1] + (i - hdquoteStart[dQuoteNum - 1]);
	}else if (dquoteFlag == false) {
	  // have to check for a first quote mark
	  if (a == '"') {
	    dquoteFlag = true;
	    dQuoteNum++;
	    // remember where the qoute mark is
	    hdquoteStart[dQuoteNum -1] = i;
	  }
	}
	
      
      
      
    } // this ends the inner loop checking the line's chars
             
      
                 
       
    
        
    
   
                 
    QStringList words = QStringList::split(' ', line, TRUE);
    for(unsigned int i=0; i<words.count(); i++) {
   
      key = false;
      typ = false;
   
      QString strings = words[i];
      spaceLength = strings.length() + 1;
    
      if(strings.isNull() || strings.isEmpty()) {
    
	start = start + spaceLength;
	continue;
      
      }
      int advance = 0;
      for(int i=0; i<spaceLength-1; i++) {
        QChar a = strings[i];
        if(a == QChar::null) 
	  break;
	else if(a.isSpace()) {
	  start++;
	  advance++;
	}
	else
	  break;
      }
      spaceLength -= advance;
      strings = strings.stripWhiteSpace();
      
      //****************************
     
      
      //********************************
      
      // so i'll back up word and wordLength wordEnd and start for hsymbols check later
      wordBK = strings;
      wordLengthBK = strings.length() + 1;
      //wordEndBK = start + wordLengthBK - 1;
      startBK = start;
      //wordLengthBK = wordLength;
      
      ///////// here lets hash it up further
      QStringList pieces = QStringList::split('<', strings, TRUE);
        for(unsigned int j=0; j<pieces.count(); j++) {
          QString q = pieces[j];
          //int len  = pieces.length() + 1;
          QStringList pieces_2 = QStringList::split('=', q, TRUE);
            for(unsigned int l=0; l<pieces_2.count(); l++) {
            QString r = pieces_2[l];
              QStringList pieces_3 = QStringList::split('>', r, TRUE);
                for(unsigned int m=0; m<pieces_3.count(); m++) {
                QString u = pieces_3[m];
                  QStringList pieces_4 = QStringList::split('/', u, TRUE);
                    for(unsigned int n=0; n<pieces_4.count(); n++) {
                    QString word = pieces_4[n];
                      

       wordLength = word.length() + 1;
      
      for(unsigned int k=0; k<230; k++) {
        QString str = hkeywords[k].upper();
	if (highlightKeywords(word,hkeywords[k]) == true) {
	  key = true;
	  break;
	} else {
          if (highlightKeywords(word,str) == true) {
	  key = true;
	  break;
	}
	}

      }
      if (key == true) {
	start += wordLength;
	continue;
      }
      

      
    
      
      
      
      start += wordLength;
			
		    
		
	    }
	}
	    }
	}
    
       
      
	start = startBK;
      highlightSymbols(wordBK);
      start += spaceLength;  
    } // now we have ended the words loop
      
    
  } // now we have finished the lines loop
    
             
  
  //return 1;
    return 0;
} // end of highlight          
     
      
    




bool htmlSyntaxHighlighter:: highlightKeywords (QString s, QString w) {
  
  
  if (s  ==  w) {
    if (tagNum == 0)
      return false;
    // if we are not in a tag then no highlighting
    // that is -exit- if the tag starts after  where we are now or ends before 
    if (skipTagFlag == true) {
      if (tagNum == 1) {
        if ((tagStart[tagNum - 1] > start) || (tagEnd[tagNum - 1] < start)) {
          return false;
	}
      }else  if (tagNum > 1) {
        int count = 0;
	for(int i=0; i < tagNum; i++) {
	  //-exit- if the tag  starts after or  ends before where we are now for each tag
	  if ((tagStart[i] >  start) || (tagEnd[i] < start)) {
            
	    count++;
            
	  }
	}
	if (count == tagNum) {
	  return false;
	}
      }
    }
    
     
      /////////////////////////////////
      if (skipDQuoteFlag == true)  {
	if (dQuoteNum == 1) {
	  // if the quote starts and ends before where we are now
	  if ((hdquoteStart[dQuoteNum - 1] <  start) && (hdquoteEnd[dQuoteNum - 1] < start)) { 
	    setFormat(start, (wordLength), QColor(0, 0, 255));
	    return true;
	  }
	  // if the qoute starts after where we are now 
	  else if (hdquoteStart[dQuoteNum - 1] >  start) { 
	    setFormat(start, (wordLength), QColor(0, 0, 255));
	    return true;
	  }
	}
	else if (dQuoteNum > 1) {
	  int count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // if all the quotes start and ends before where we are now
	    if ((hdquoteStart[i] <  start) && (hdquoteEnd[i] < start)) {
               
	      count++;
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength), QColor(0, 0, 255));
	    return true;
	  }
	  //count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // add in any qoutes that  start after where we are now 
	    if (hdquoteStart[i] >  start) { 
	      count++;  
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength), QColor(0, 0, 255));
	    return true;
	  }
	}
      }else {
	setFormat(start, (wordLength), QColor(0, 0, 255));
	return true;
      }

    
    
}
  
  
  
  return false;
  
}




void htmlSyntaxHighlighter::highlightSymbols (QString w) {
  int startChar = start;
  
  // to speed this up -- let's keep it simple
  // this commented out routine works fine if you want to use it 
  //  if (skipDQuoteFlag == true) {
//      if (dQuoteNum == 1) {
//  	for(int i=0; i<wordLengthBK-1; i++) {
//  	  QChar a = w[i];
//  	    if ((startChar < hdquoteStart[dQuoteNum - 1]) || (startChar > hdquoteEnd[dQuoteNum - 1])) {
//  	    for(unsigned int k=0; k<2; k++) {
//  	      QChar s = hsymbols[k];
//  	      if(a == s)
		
//  		  setFormat(startChar, 1, QColor(0, 0, 255));
                
//  	    }// end for unsigned int    
             
             
//  	    }//end if startChar
//  	  startChar++; 
//  	}//end for i = loop 
//      }// end if dquoteNum
//        if (dQuoteNum > 1) {
		

//  	for(int i=0; i<wordLengthBK-1; i++) {
//  	  int count = 0;
//  	  QChar a = w[i];
//  	  for(int j=0; j < dQuoteNum; j++) {
      
//  	    if ((startChar < hdquoteStart[j]) || (startChar > hdquoteEnd[j])) {
//  	      count++;
//  	    }
//  	  }
//  	  if (count == dQuoteNum) {
//  	    for(unsigned int k=0; k<2; k++) {
//  	      QChar s = hsymbols[k];
//  	      if(a == s)
		 
//  		  setFormat(startChar, 1, QColor(0, 0, 255));
	    
//  	  }
//  }
     
//  	  startChar++;
//  	}
//        }
//      }else             
      for(int i=0; i<wordLengthBK-1; i++) {
       
	QChar a = w[i];
	for(unsigned int k=0; k<2; k++) {
	  QChar s = hsymbols[k]; 
	  if(a == s)
	    
	      setFormat(startChar, 1, QColor(0, 0, 255));
                 
	  
	}      
	startChar++; 
      }
}
        





























































