

#include <iostream>
#include <qvaluevector.h>
#include <qregexp.h>
#include <qstring.h>
#include <qstringlist.h>
#include "javaSyntaxHighlighter.h"


QString jkeywords[49] = { "abstract", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "dynamic_cast", "else", "extends", "final", "finally", "for", "future","generic", "goto", "if", "implements","import","inner","instanceof","interface","native",  "new","null", "operator","outer","package", "private", "protected", "public", "rest", "return",  "static", "super",  "switch", "syncronize", "this", "throw","throws", "transient", "try","var","void", "volatile",  "while" };
QString jtypes[10] =  { "boolean" ,"byte", "char", "double","File", "float", "int", "long", "short", "String"};
QChar jsymbols[6] = { '(', ')', '{', '}', '[', ']' };

      
     
QValueVector<int> jsquoteStart(1);
QValueVector<int> jsquoteEnd(1);
QValueVector<int> jdquoteStart(1);
QValueVector<int> jdquoteEnd(1);     
bool jblockFlag = false;
bool jtempFlag = false;
int jtempPlace = 0;
//int endStateOfLastPara;
javaSyntaxHighlighter::javaSyntaxHighlighter(QTextEdit *textEdit) 
  : QSyntaxHighlighter(textEdit) {
  return;
}



javaSyntaxHighlighter::~javaSyntaxHighlighter(void) {
  return;
}

int javaSyntaxHighlighter::highlightParagraph(const QString &text, 
					     int endStateOfLastPara) {
  
  // parse lines first
 
  QStringList lines = QStringList::split('\n', text, TRUE);
  for(unsigned int i=0; i<lines.count(); i++) {
    
    start=0;
    place = 0;
    jsquoteStart.clear();
    jsquoteEnd.clear();
    jdquoteStart.clear();
    jdquoteEnd.clear();
    jsquoteStart.push_back(0);
    jsquoteEnd.push_back(0);
    jdquoteStart.push_back(0);
    jdquoteEnd.push_back(0);
    sQuoteNum = 0;
    dQuoteNum = 0;
    commentStart = 0;
    commentFlag = false;
    skipSQuoteFlag = false;
    skipDQuoteFlag = false;
    
    QString line = lines[i];
    if(line.isNull() || line.isEmpty()) {
      
      continue;
      
    }
    jtempPlace = 0;
    jtempFlag = false;
    squoteFlag = false;
    dquoteFlag = false;    
    
    int lineLength = line.length() + 1;
    if (jblockFlag == false) {
      setFormat((0), lineLength, QColor(0, 0, 0));
    } else
      setFormat((0), lineLength, QColor(0, 200, 155));
      
    // now to examine this line in an inner loop
    for(int i=0; i<lineLength-1; i++) {
      // no need to examine this line more if in a line comment
      
      QChar a = line[i];
      QChar b = line[(i+1)];
      if (jblockFlag == false) {
        if ((a == '/') && (b == '*')) {
	  jblockFlag = true;       
	  setFormat((i), lineLength, QColor(0, 200, 155));
	  // need to keep looking in case end
          continue;        
        }
	
      }
      // only thing we need to do if in a block comment is to look for it's end 
      if (jblockFlag == true) {    
	if ((a == '*') && (b == '/')) {
	 
                    
	  setFormat((0), lineLength, QColor(0, 200, 155));
          setFormat((i+2), lineLength, QColor(0,0,0));
          jblockFlag = false;
          jtempFlag = true;
          jtempPlace = i + 1;
          // look at the rst of this line
	  continue;                
	}
	
	
      }
      // only need to do this stuff if not in a block comment
      if (jblockFlag != true) {
	// first check if we have a line comment
	if ((a == '/') && (b == '/')) {
	  setFormat((i), lineLength, QColor(0, 200, 155));
	  commentFlag = true;
	  commentStart = i;
	  // if we are in a line comment 
	  // no need to look at anymore chars in this line
	  break;
	}
         
      
	// look for the second quote mark first if we have one already
	if ((dquoteFlag == true) && (a == '"')) {
	  setFormat((jdquoteStart[dQuoteNum - 1]), ((i - jdquoteStart[dQuoteNum - 1]) + 1), QColor(200,0 ,200 ));
	  dquoteFlag = false;
	  skipDQuoteFlag = true;
	  jdquoteStart.push_back(0);
	  jdquoteEnd.push_back(0);
	  jdquoteEnd[dQuoteNum - 1] = jdquoteStart[dQuoteNum - 1] + (i - jdquoteStart[dQuoteNum - 1]);
	}else if (dquoteFlag == false) {
	  // have to check for a first quote mark
	  if (a == '"') {
	    dquoteFlag = true;
	    dQuoteNum++;
	    // remember where the qoute mark is
	    jdquoteStart[dQuoteNum -1] = i;
	  }
	}
	// do the same thing for single quote mark
	if ((squoteFlag == true) && (a == "'")) {
	  setFormat((jsquoteStart[sQuoteNum - 1] ), ((i - jsquoteStart[sQuoteNum - 1]) + 1), QColor(200, 0,200 ));
	  squoteFlag = false;
	  skipSQuoteFlag = true;
	  jsquoteStart.push_back(0);
	  jsquoteEnd.push_back(0);
	 
	  jsquoteEnd[sQuoteNum -1] = jsquoteStart[sQuoteNum -1] + (i - jsquoteStart[sQuoteNum -1]);
	}else if (squoteFlag == false) {
   
	  if (a == "'") {
	    squoteFlag = true;
	    sQuoteNum++;
	    jsquoteStart[sQuoteNum -1] = i;
	  }
	}
      }// this ends the if not in a comment block 
      
      
      
    } // this ends the inner loop checking the line's chars
             
      
                 
       
    
    if (jblockFlag == true)
      continue;
    
   
    // this should only happen if not in a block comment
                 
    QStringList words = QStringList::split(' ', line, TRUE);
    for(unsigned int i=0; i<words.count(); i++) {
   
      key = false;
      typ = false;
   
      QString strings = words[i];
      spaceLength = strings.length() + 1;
    
      if(strings.isNull() || strings.isEmpty()) {
    
	start = start + spaceLength;
	continue;
      
      }
      int advance = 0;
      for(int i=0; i<spaceLength-1; i++) {
        QChar a = strings[i];
        if(a == QChar::null) 
	  break;
	else if(a.isSpace()) {
	  start++;
	  advance++;
	}
	else
	  break;
      }
      spaceLength -= advance;
      strings = strings.stripWhiteSpace();
      
      //****************************
     
      
      //********************************
      
      // so i'll back up word and wordLength wordEnd and start for jsymbols check later
      wordBK = strings;
      wordLengthBK = strings.length() + 1;
      //wordEndBK = start + wordLengthBK - 1;
      startBK = start;
      //wordLengthBK = wordLength;
      
      ///////// here lets hash it up further
      QStringList pieces = QStringList::split('(', strings, TRUE);
        for(unsigned int j=0; j<pieces.count(); j++) {
          QString q = pieces[j];
          //int len  = pieces.length() + 1;
          QStringList pieces_2 = QStringList::split(')', q, TRUE);
            for(unsigned int l=0; l<pieces_2.count(); l++) {
            QString r = pieces_2[l];
              QStringList pieces_3 = QStringList::split('{', r, TRUE);
                for(unsigned int m=0; m<pieces_3.count(); m++) {
                QString u = pieces_3[m];
                  QStringList pieces_4 = QStringList::split('}', u, TRUE);
                    for(unsigned int n=0; n<pieces_4.count(); n++) {
                    QString v = pieces_4[n];
                      QStringList pieces_5  = QStringList::split(',', v, TRUE);
                        for(unsigned int o=0; o<pieces_5.count(); o++) {
                        QString word = pieces_5[o];

       wordLength = word.length() + 1;
       //wordEnd = start + wordLength - 1;
      if (word.endsWith(";")) {  
        wordLength = wordLength - 1;
        word.truncate(wordLength - 1);
        //wordEnd = start + wordLength;
      }
     
      
      for(unsigned int k=0; k<49; k++) {
	if (highlightKeywords(word,jkeywords[k]) == true) {
	  key = true;
	  break;
	}
      }
      if (key == true) {
	start += wordLength;
	continue;
      }
      
    
      
      for(unsigned int k=0; k<10; k++) {
	if (highlightTypes(word,jtypes[k]) == true) {
	  typ = true;
	  break;
	}
      }
      if (typ == true) {
	start += wordLength;
	continue;
      }
      
      start += wordLength;
			}
		    }
		}
	    }
	}
    
       
      
	start = startBK;
      highlightSymbols(wordBK);
      start += spaceLength;  
      
    } // now we have ended the words loop
  } // now we have finished the lines loop
    
             
  
   if (jblockFlag == true)
  return 1;
  else 
  return 0;
  
} // end of highlight          
     
      
    




bool javaSyntaxHighlighter:: highlightKeywords (QString s, QString w) {
  
  
  if (s  ==  w) {
    if (jtempFlag == true) {
      if (start <= jtempPlace)
	return false;
    }
    if (commentFlag == true) {
      if (commentStart <= start)
	return false;
    }
    
    if (skipSQuoteFlag == true)  {
      if (sQuoteNum == 1) {
	// if the quote starts and ends before where we are now
	if ((jsquoteStart[sQuoteNum -1] <  start) && (jsquoteEnd[sQuoteNum -1] < start)) { 
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
	// if the qoute starts after where we are now
	else if (jsquoteStart[sQuoteNum -1] >  start) { 
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
      } if (sQuoteNum > 1) {
	int count = 0;
	for(int i=0; i < sQuoteNum; i++) {
	  // if the quote starts and ends before where we are now
	  if ((jsquoteStart[i] <  start) && (jsquoteEnd[i] < start)) {
            
	    count++;
            
	  }
	}
	if (count == sQuoteNum) {
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
	//count = 0;
	for(int i=0; i < sQuoteNum; i++) {
	  // add it in if the qoute starts after where we are now 
	  if (jsquoteStart[i] >  start)  { 
	    count++;
	  }
	}
	if (count == sQuoteNum) {
	  setFormat(start, (wordLength-1), QColor(0, 0, 255));
	  return true;
	}
      }
    }else 
      /////////////////////////////////
      if (skipDQuoteFlag == true)  {
	if (dQuoteNum == 1) {
	  // if the quote starts and ends before where we are now
	  if ((jdquoteStart[dQuoteNum - 1] <  start) && (jdquoteEnd[dQuoteNum - 1] < start)) { 
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	  // if the qoute starts after where we are now 
	  else if (jdquoteStart[dQuoteNum - 1] >  start) { 
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	}
	if (dQuoteNum > 1) {
	  int count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // if all the quotes start and ends before where we are now
	    if ((jdquoteStart[i] <  start) && (jdquoteEnd[i] < start)) {
               
	      count++;
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	  //count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // add in any qoutes that  start after where we are now 
	    if (jdquoteStart[i] >  start) { 
	      count++;  
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength-1), QColor(0, 0, 255));
	    return true;
	  }
	}
      }else {
	setFormat(start, (wordLength-1), QColor(0, 0, 255));
	return true;
      }

    
    
  }
  
  
  
  return false;
  
}


bool javaSyntaxHighlighter:: highlightTypes (QString s, QString w) {
  if (s  ==  w) {
    if (jtempFlag == true) {
      if (start <= jtempPlace)
	return false;
    }
    if (commentFlag == true) {
      if (commentStart <= start)
	return false;
    }
    
    if (skipSQuoteFlag == true)  {
      if (sQuoteNum == 1) {
	// if the quote starts and ends before where we are now
	if ((jsquoteStart[sQuoteNum -1] <  start) && (jsquoteEnd[sQuoteNum -1] < start)) { 
	  setFormat(start, (wordLength-1), QColor(0, 126, 126));
	  return true;
	}
	// if the qoute starts after where we are now 
	else if (jsquoteStart[sQuoteNum -1] >  start) { 
	  setFormat(start, (wordLength-1), QColor(0, 126, 126));
	  return true;
	}
      } if (sQuoteNum > 1) {
	int count = 0;
	for(int i=0; i < sQuoteNum; i++) {
	  // if the quote starts and ends before where we are now
	  if ((jsquoteStart[i] <  start) && (jsquoteEnd[i] < start)) { 
	    count++;
	  }
	}
	if (count == sQuoteNum) {
	  setFormat(start, (wordLength-1), QColor(0, 126, 126));
	  return true;
	}
	//count = 0;
	for(int i=0; i < sQuoteNum; i++) {
	  // if the qoute starts after where we are now add it in
	  if (jsquoteStart[i] >  start) { 
	    count++;
	  }
	}
	if (count == sQuoteNum) {
	  setFormat(start, (wordLength-1), QColor(0, 126, 126));
	  return true;
	}
      }
    }else 
      /////////////////////////////////
      if (skipDQuoteFlag == true)  {
	if (dQuoteNum == 1) {
	  // if the quote starts and ends before where we are now
	  if ((jdquoteStart[dQuoteNum - 1] <  start) && (jdquoteEnd[dQuoteNum - 1] < start)) { 
	    setFormat(start, (wordLength-1), QColor(0, 126, 126));
	    return true;
	  }
	  // if the qoute starts after where we are now 
	  else if (jdquoteStart[dQuoteNum - 1] >  start) { 
	    setFormat(start, (wordLength-1), QColor(0, 126, 126));
	    return true;
	  }
	}
	if (dQuoteNum > 1) {
	  int count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // if the quote starts and ends before where we are now
	    if ((jdquoteStart[i] <  start) && (jdquoteEnd[i] < start)) { 
	      count++;
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength-1), QColor(0, 126, 126));
	    return true;
	  }
	  //count = 0;
          for(int i=0; i < dQuoteNum; i++) {
	    // if the qoute starts after where we are now 
	    if (jdquoteStart[i] >  start) { 
	      count++;  
	    }
	  }
	  if (count == dQuoteNum) {
	    setFormat(start, (wordLength-1), QColor(0, 126, 126));
	    return true;
	  }
	}
      }else {
	setFormat(start, (wordLength-1), QColor(0, 126, 126));
	return true;
      }

    
    
  }

  return false;
  
}


void javaSyntaxHighlighter::highlightSymbols (QString w) {
  int startChar = start;
  if (jtempFlag == true) {
    if (start <= jtempPlace)
      return;
  }
  if (commentFlag == true) {
    if (commentStart <= start)
      return;
  }
  if (skipSQuoteFlag == true) {
    if (sQuoteNum == 1) { 
      for(int i=0; i<wordLengthBK-1; i++) {
	QChar a = w[i];
	if ((startChar < jsquoteStart[sQuoteNum - 1]) || (startChar > jsquoteEnd[sQuoteNum - 1])) {
	  for(unsigned int k=0; k<6; k++) {
	    QChar s = jsymbols[k];
	    if(a == s)
	      if (commentFlag == true) {
		if (startChar < commentStart)
		  setFormat(startChar, 1, QColor(255, 0, 0));
	      }else 
		setFormat(startChar, 1, QColor(255, 0, 0));
	  }
	}
	startChar++;
      }
    }
    if (sQuoteNum > 1) {
                    
      for(int i=0; i<wordLengthBK-1; i++) {
	int count = 0;
	QChar a = w[i];
	for(int j=0; j < sQuoteNum; j++) {
      
	  if ((startChar < jsquoteStart[j]) || (startChar > jsquoteEnd[j])) {
	    count++;
	  }
	}
	if (count == sQuoteNum) {
	  for(unsigned int k=0; k<6; k++) {
	    QChar s = jsymbols[k];
	    if(a == s)
	      if (commentFlag == true) {
		if (startChar < commentStart)
		  setFormat(startChar, 1, QColor(255, 0, 0));
	      }else 
		setFormat(startChar, 1, QColor(255, 0, 0));
	  }
	}
     
	startChar++;
      }
    }
  
  }else
    if (skipDQuoteFlag == true) {
      if (dQuoteNum == 1) {
	for(int i=0; i<wordLengthBK-1; i++) {
	  QChar a = w[i];
	  if ((startChar < jdquoteStart[dQuoteNum - 1]) || (startChar > jdquoteEnd[dQuoteNum - 1])) {
	    for(unsigned int k=0; k<6; k++) {
	      QChar s = jsymbols[k];
	      if(a == s)
		if (commentFlag == true) {
		  if (startChar < commentStart)
		    setFormat(startChar, 1, QColor(255, 0, 0));
		}else
		  setFormat(startChar, 1, QColor(255, 0, 0));
                
	    }
             
             
	  }
	  startChar++; 
	} 
      }
      if (dQuoteNum > 1) {
		

	for(int i=0; i<wordLengthBK-1; i++) {
	  int count = 0;
	  QChar a = w[i];
	  for(int j=0; j < dQuoteNum; j++) {
      
	    if ((startChar < jdquoteStart[j]) || (startChar > jdquoteEnd[j])) {
	      count++;
	    }
	  }
	  if (count == dQuoteNum) {
	    for(unsigned int k=0; k<6; k++) {
	      QChar s = jsymbols[k];
	      if(a == s)
		if (commentFlag == true) {
		  if (startChar < commentStart)
		    setFormat(startChar, 1, QColor(255, 0, 0));
		}else 
		  setFormat(startChar, 1, QColor(255, 0, 0));
	    }
	  }
     
	  startChar++;
	}
      }
    }else             
      for(int i=0; i<wordLengthBK-1; i++) {
       
	QChar a = w[i];
	for(unsigned int k=0; k<6; k++) {
	  QChar s = jsymbols[k]; 
	  if(a == s)
	    if (commentFlag == true) {
	      if (startChar < commentStart)
		setFormat(startChar, 1, QColor(255, 0, 0));
	    }else
	      setFormat(startChar, 1, QColor(255, 0, 0));
                 
	}  
             
	startChar++; 
      }
}
        





























































