#include "myProgressDialog.h"
//#include <qprogressdialog.h>
#include "myFTP.h"
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/errno.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
//#include <setjmp.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qdir.h>
#include <pthread.h>
#include <qobject.h>
#include <qwidget.h>
#include <qtimer.h>
#include <qnamespace.h>
#include <iostream>
using namespace std;


#define INVALID_SOCKET (~0)

#define DEFAULT_PORT_NUM 21


enum {LS = 0,BINARY,ASCII,PWD,CD,OPEN,CLOSE,QUIT,LCD,LLS,LDIR,USER,SHELL,IGNORE_COMMAND,GET,PUT,HELP,RHELP,FTP_COMPLETE=1, FTP_CONTINUE,FTP_ERROR};
char Buffer[1025]={0};  /* buffer used to read/write */

char *user;

char *pass;

char *host;
int  ListenSocket = INVALID_SOCKET,ControlSocket= INVALID_SOCKET,DataSocket=INVALID_SOCKET,Connected = 0;
int bSendPort = 1;
int Mode=ASCII;
int bMode;
FILE *fp=NULL;
int get_threadFlag = 0;
QTimer *threadTimer;

myFTP::myFTP(QObject * parent , const char * name )
   :  QObject(parent,name) {
 
}

myFTP::~myFTP() {
}

int  myFTP::FTPOpen(char *u, char *p, char *h ) {
  user = u;
  pass = p;
  host = h;
  /* 
   * do not do anything if we are already connected.
   */
  if( Connected ) {
    printf("Already connected.  Close connection first.\n");
    fflush(stdout);
    return 1;
  }
      
  printf("Connecting to %s\n",host);
  char _p[] = "21";
  char *port = _p;
  ControlSocket = ConnectToServer(host,port);

  sleep(1);

  if( ControlSocket > 0)  {
    printf("Connected to %s\n",host);

    Connected = 1;         /* we ar now connected */

    GetReply();            /* get reply (welcome message) from server */
    if ((FTPLogin() == 0) && (FTPBinary() == 0)) {     /*username and password and set to binary */
    return 0;            
    }
  }// end if Control Socket
  // have to close if things are going bad
  // otherwise ant new attempts will be met with
  // already connected
  DoClose();
  return 1; 
} //end DoOpen

int  myFTP::GetReply() {

  int done = 0, iRetCode = 0;
  memset(Buffer,0,1024);
  while(done == 0) {
    iRetCode = GetLine();
    (void)strtok(Buffer,"\r\n");
    puts(Buffer);
    if( Buffer[3] != '-' && iRetCode > 0 )
      done = 1;
    memset(Buffer,0,1024);
  }
  //cout << "return code from GetReply " << iRetCode << "\n";
  return iRetCode;

}

QString  myFTP::ReturnReply() {
  QString returnString;
  int done = 0, iRetCode = 0;
  memset(Buffer,0,1024);
  while(done == 0) {
    iRetCode = GetLine();
    (void)strtok(Buffer,"\r\n");
    puts(Buffer);
    returnString = returnString + QString(Buffer);
    if( Buffer[3] != '-' && iRetCode > 0 )
      done = 1;
    memset(Buffer,0,1024);
  }
  //if (iRetCode == 213) { // decided to  not block other codes since this one 
  // isn't officially in the protocol ??
  // checking later if the string has the size should do it
    return returnString;

}

int myFTP::GetLine() {
  int  iLen, iBuffLen=0;
  char *szPtr = Buffer, nCode[3]={0},ch=0;
  while( (iBuffLen < 1024) && 
	 (CheckControlMsg(&ch,1)  > 0) ){

    iLen = ReadControlMsg(&ch,1);
    iBuffLen += iLen;
    *szPtr = ch;
    szPtr += iLen;
    if( ch == '\n' )
      break;    // we have a line: return
  }
  *(szPtr+1) = (char)0;
  strncpy(nCode, Buffer, 3);
  return (atoi(nCode));

}

int myFTP::ConnectToServer(char *name, char *port) {

  int s;
  unsigned int portnum;
  struct sockaddr_in server;
  struct hostent *hp;
  while( name && *name == ' ') name++;
  if( !name || ! (*name) )
    return INVALID_SOCKET;
  portnum = atoi(port);
  bzero((char *) &server, sizeof(server));
  if( isdigit(name[0])) {
    server.sin_family      = AF_INET;
    server.sin_addr.s_addr = inet_addr(name);
    server.sin_port        = htons(portnum);
  }
  else{ 
    if ( (hp = gethostbyname(name)) == NULL) {
      perror("gethostbyname");
      return INVALID_SOCKET;
    }
    bcopy(hp->h_addr,(char *) &server.sin_addr,hp->h_length);
    server.sin_family = hp->h_addrtype;
    server.sin_port = htons(portnum);  
  }/* else */
  /* create socket */
  if( (s = socket(AF_INET, SOCK_STREAM, 0)) < 1) {
    perror("socket");
    return INVALID_SOCKET;
  }
  if (::connect(s,(struct sockaddr *)&server, sizeof(server))< 0) {
    perror("connect");
    return INVALID_SOCKET;
  }
  setsockopt(s,SOL_SOCKET,SO_LINGER,0,0);
  setsockopt(s,SOL_SOCKET,SO_REUSEADDR,0,0);
  setsockopt(s,SOL_SOCKET,SO_KEEPALIVE,0,0);
  DataSocket = s;
  return s;

}


int myFTP::FTPLogin( ) {
 
  int response;
   if( Connected )  {
    /* 
     * ignore leading whitespace
     */
    while(user && (*user == ' ' || *user == '\t') && *user)
      user++;
    /*
     * send user name & password to server  & get reply message
     */
    sprintf(Buffer,"USER %s\r\n",user);
    SendControlMsg(Buffer,strlen(Buffer));
    response = GetReply();
    if (response != 331)
      return -1; 
    sprintf(Buffer,"PASS %s\r\n",pass);
    SendControlMsg(Buffer,strlen(Buffer));
    response = GetReply();
    if ((response == 230) || (response == 202)) {
      
      return 0;
    } else
    return -1;
   }// end if connected
  else {
    printf("Not Connected.\n");
    return -1;
  }
     
}

int myFTP::SendControlMsg( char *Buffer, int len) {

  if( send(ControlSocket,Buffer,len,0) <= 0)
    return 0;

  return 1;

}

int myFTP::FTPBinary() {
  int response;
  if( !Connected ) {
    printf("Not Connected.\n");
    return -1;
  }
  sprintf(Buffer, "TYPE I\r\n");
  SendControlMsg(Buffer,strlen(Buffer));
  response = GetReply();
  //cout << "response to TYPE " << response << "\n";
  if (response != 200) 
    return -1;
  //printf("File transfer mode set to binary.\n");
  Mode = BINARY;
  return 0;
}

int myFTP::ReadControlMsg( char *Buffer, int len) {

  int ret;
  if( (ret=recv(ControlSocket,Buffer,len,0)) <= 0)
    return 0;

  return ret;
}

int myFTP::CheckControlMsg( char *szPtr, int len) {

  return recv(ControlSocket,szPtr,len,MSG_PEEK);
}

int  myFTP::DoList()
{
  int response;
  if( !Connected ) {
    printf("Not Connected.\n");
    return 1;
  }

  /*
   * obtain a listening socket
   */
  if( GetListenSocket() < 0) {
    printf("Cannot obtain a listen socket.\n");
    return 1;
  }
   
  /*
   *  command
   */
  // this one only returns the short file only version
  //sprintf(Buffer,"NLST\r\n");
   
  //this might work better ? 
  // it returns like ls -l
  sprintf(Buffer,"LIST\r\n");
  
  /*
   * send command to server and get response
   */
  SendControlMsg(Buffer,strlen(Buffer));
  memset(Buffer,0,1024);
  response = GetReply();
  if ((response == 125) || (response == 150)) {
    // do nothing
  } else 
    return 1;

  /*
   * accept server's connection
   */
  if(AcceptConnection() < 0) {
    printf("Cannot accept connection.\n");
    return 1;
  }
  // ?? seems like this is already closed durring AcceptConection
  //CloseListenSocket();       /* close listening socket */

  /*
   * display directory listing.
   */
    FILE *pFile;
    char *home = getenv("HOME");
    char h_dr[] = "/.kpad";
    char *h_d = h_dr;
    char f[] = "/FTP.list";
    char *fnm = f;
    const size_t _length = strlen(home) +  strlen(h_d) + strlen(fnm) + 1;
    const size_t _len = strlen(home) +  strlen(h_d) + 1;
    //char _l[_len];
    //char *_hdir = _l;
    char *_hdir;
    _hdir = new char[_len];
    strcpy(_hdir,home);
    strcat(_hdir,h_d);
    //char d[_length];
    //char *m_file = d;
    char *m_file;
    m_file = new char[_length];
    strcpy(m_file,home);
    strcat(m_file,h_d);
    strcat(m_file,fnm);
    // check that the .kpad directory exists
    QString str = QString(_hdir);
    QDir _d(str);
    if ( !_d.exists() ) {
        bool b = _d.mkdir(str,TRUE);
        if (b == FALSE)
          return 1;
    }
    pFile = fopen (m_file , "w");

  while( ReadDataMsg(Buffer,1024) > 0) {
    fflush(pFile);
    //fflush(stdout);
    //printf(Buffer);
    fprintf(pFile,Buffer);
    memset(Buffer,0,1024);
    
  }
  fclose(pFile);
  
  CloseDataConnection();
  response = GetReply();
  if ((response == 226) || (response == 250)) {
  return 0;
  } else
    return 1;
 
}

QStringList  myFTP::DoOpenList()
{
  int response;
  QStringList stringList;
  if( !Connected ) {
    printf("Not Connected.\n");
    return stringList;
  }

  /*
   * obtain a listening socket
   */
  if( GetListenSocket() < 0) {
    printf("Cannot obtain a listen socket.\n");
    return stringList;
  }
   
  /*
   *  command
   */
  // this one only returns the short file only version
  sprintf(Buffer,"NLST\r\n");
   
   
  // it returns like ls -l
  // sprintf(Buffer,"LIST\r\n");
  
  /*
   * send command to server and get response
   */
  SendControlMsg(Buffer,strlen(Buffer));
  memset(Buffer,0,1024);
  response = GetReply();
  if ((response == 125) || (response == 150)) {
    //do nothing
  } else
    return stringList;
  /*
   * accept server's connection
   */
  if(AcceptConnection() < 0) {
    printf("Cannot accept connection.\n");
    return stringList;
  }
  // ?? seems like this is already closed durring AcceptConection
  //CloseListenSocket();       /* close listening socket */

  /*
   * display directory listing.
   */
    
  
  QString str;
  while( ReadDataMsg(Buffer,1024) > 0) {
    //fflush(stdout);
    str = str + QString(Buffer);
    memset(Buffer,0,1024);
  }
  
  stringList = QStringList::split( "\n", str );
  // test and see what we got 
  //  cout << stringList.join( ", " ) << endl;
  CloseDataConnection();
  //response = GetReply();
  //if ((response == 226) || (response == 250))
  //return stringList;
  GetReply();
  return stringList;
}

int myFTP::GetListenSocket()

{
  int sockfd, flag=1;
  socklen_t  len;
  struct sockaddr_in  serv_addr, TempAddr;
  char *port,*ipaddr;
  char Buffer[64]={0};
  /*
   * Open a TCP socket (an Internet stream socket).
   */

  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("socket");
    return INVALID_SOCKET;
  }
  /*
   * Fill in structure fields for binding
   */

  if( bSendPort ) {
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family      = AF_INET;
    serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    serv_addr.sin_port        = htons(0); /* let system choose */
  }

  else {

    /* reuse the control socket then */

    if(setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,

		  (char *)&flag,sizeof(flag)) < 0) {

      perror("setsockopt");
      close(sockfd);
      return INVALID_SOCKET;
    }
  }
  /*
   * bind the address to the socket
   */

  if (bind(sockfd,(struct sockaddr *)&serv_addr, 

	   sizeof(serv_addr)) < 0) {

    perror("bind");
    close(sockfd);
    return INVALID_SOCKET;
  }

      len = sizeof(serv_addr);
      if(getsockname(sockfd,

		 (struct sockaddr *)&serv_addr,

		 &len)<0) {

    perror("getsockname");
    close(sockfd);
    return INVALID_SOCKET;
  }
  len = sizeof(TempAddr);
  if(getsockname(ControlSocket,

		 (struct sockaddr *)&TempAddr,

		 &len)<0) {

    perror("getsockname");
    close(sockfd);
    return INVALID_SOCKET;
  }
  ipaddr = (char *)&TempAddr.sin_addr;
  port  = (char *)&serv_addr.sin_port;

#define  UC(b)  (((int)b)&0xff)

  sprintf(Buffer,"PORT %d,%d,%d,%d,%d,%d\r\n",
          UC(ipaddr[0]), UC(ipaddr[1]), UC(ipaddr[2]), UC(ipaddr[3]),
          UC(port[0]), UC(port[1]));
  /*
   * allow ftp server to connect
   * allow only one server
   */

  if( listen(sockfd, 1) < 0) {

    perror("listen");
    close(sockfd);
    return INVALID_SOCKET;
  }

  SendControlMsg(Buffer,strlen(Buffer));
  GetReply();
  ListenSocket = sockfd;
  return sockfd;

}

void myFTP::CloseListenSocket(  )
{
 
  close(ListenSocket);
  ListenSocket = INVALID_SOCKET;
}



int myFTP::AcceptConnection()

{
    struct sockaddr_in cli_addr;
    socklen_t  clilen = sizeof(cli_addr);
    int sockfd;
    sockfd = accept(ListenSocket, (struct sockaddr *) &cli_addr,

			   &clilen);

    if (sockfd < 0) {

        perror("accept");
	return INVALID_SOCKET;
    }

       DataSocket = sockfd;
       close(ListenSocket);
       return sockfd;

}


int myFTP::ReadDataMsg( char *Buffer, int len)

{

   int ret;
   ret=recv(DataSocket,Buffer,len,0);
   if( ret <= 0)
       return 0;
   else
       return ret;

}


void myFTP::DoClose()
{
   if( !Connected  ) {
     printf("Not Connected.\n");
    
   }
   else {
     char msg[] = "quit\r\n";
     char *message = msg;
	   SendControlMsg(message ,6);
	   GetReply();
           // return code for quit is 221
           // but what are we gona do if the
           // server won't let us quit ???
	   CloseControlConnection();
	   ControlSocket = -1;

	   Connected = 0;
   }

}


void myFTP::CloseControlConnection()

{
 
      close(ControlSocket);
      ControlSocket = INVALID_SOCKET;

}



void myFTP::CloseDataConnection()

{

      close(DataSocket);
      DataSocket = INVALID_SOCKET;

}




int myFTP::GetFile( char *fname)
{
   FILE *fp=NULL;
   int fd, nTotal=0, nBytesRead=0;
   int response;
  /*
    * did we get a filename?
    */
   if( !fname || ! (*fname)) {
      printf("No file specified.\n");
      return 1;
   }

   /*
    * open the file with current mode in hidden folder within home dir
    */
   char *_home = getenv("HOME");
   char h_dr[] = "/.kpad";
   char *h_d = h_dr;
   const size_t _len = strlen(_home) +  strlen(h_d) + 1;
   //char _l[_len];
   //char *_hdir = _l;
    char *_hdir;
    _hdir = new char[_len];
    strcpy(_hdir,_home);
    strcat(_hdir,h_d);
   QString str = QString(_hdir);
    QDir _d(str);
    if ( !_d.exists() ) {
        bool b = _d.mkdir(str,TRUE);
        if (b == FALSE)
          return 1;
    }
    //here create the destination directory
   char myDir[] = "/.kpad/";
   char *m_dir = myDir;
   const size_t _length = strlen(_home) + strlen(m_dir) +  strlen(fname) + 1;
   //char _g[_length];
   // char *fileNm = _g;
      char *fileNm;
      fileNm = new char[_length];
      strcpy(fileNm,_home);
      strcat(fileNm,m_dir);
      strcat(fileNm,fname);
   if(! (fp=fopen(fileNm,(bMode==ASCII) ? "wt" : "wb"))) {
      perror("file open");
      return 1;
   }

   /*
    * obtain a listen socket
    */
   if( GetListenSocket() < 0) {
       fclose(fp);
       return 1;
   }
   
   /*
    * send command to server and read response
    */
   sprintf(Buffer,"RETR %s\r\n",fname);
   if(!SendControlMsg(Buffer,strlen(Buffer))) {
      fclose(fp);
      return 1;
   }
   response = GetReply();
   if ((response == 125) || (response == 150)) {
     // do nothing
   } else
     return 1;
   
   /*
    * accept server connection
    */
   if( AcceptConnection() <= 0) {
       fclose(fp);
       return 1;
   }
   /* 
    * now get file and store
    */
   

   fd = fileno(fp);

   
   while( (nBytesRead=ReadDataMsg(Buffer,1024)) > 0) {
       
	   
	   write(fd,Buffer,nBytesRead);
	   nTotal+=nBytesRead;
           
	   printf("%s : %d received\r",fname,nTotal);
   }
	   
   printf("\r\n");
   close(fd);
   //CloseDataConnection(DataSocket);
   CloseDataConnection();
   //  ControlCHit = 0; 
   response = GetReply();
   if ((response == 226) || (response == 250))
     return 0;
   return 1;

}


int myFTP::DownloadFile( char *fname, char *fileNm)
{
  //FILE *fp=NULL;
  //int fd, nTotal=0, nBytesRead=0;
  int response;
  /*
    * did we get a filename?
    */
   if( !fname || ! (*fname)) {
      printf("No file specified.\n");
      return 1;
   }

   
   if(! (fp=fopen(fileNm,(bMode==ASCII) ? "wt" : "wb"))) {
      perror("file open");
      return 1;
   }

   /*
    * obtain a listen socket
    */
   if( GetListenSocket() < 0) {
       fclose(fp);
       return 1;
   }
   // get the files size
   // SIZE may not be supported by all servers
   sprintf(Buffer,"SIZE %s\r\n",fname);
   if(!SendControlMsg(Buffer,strlen(Buffer))) {
      fclose(fp);
      return 1;
   }
   // the server response for SIZE is 213  
   QString reply = ReturnReply();
   //cout << "reply string from the SIZE command \n";
   //cout << reply;
   QStringList strList = QStringList::split(' ', reply, TRUE);
   int i = strList.count() - 1;
   QString num = strList[i];
   bool ok;
   int fileSize = num.toInt( &ok, 10 );
   //cout << "file Size \n";
   //cout << fileSize;
   // here check to see if ok == true  
   // now hash up reply and get size

   /*
    * send command to server and read response
    */
   sprintf(Buffer,"RETR %s\r\n",fname);
   if(!SendControlMsg(Buffer,strlen(Buffer))) {
      fclose(fp);
      return 1;
   }

   response = GetReply();
   if ((response == 125) || (response == 150)) {
     // do nothing
   } else
     return 1;
   /*
    * accept server connection
    */
   if( AcceptConnection() <= 0) {
       fclose(fp);
       return 1;
   }
   /* 
    * now get file and store
    */
   // new thread starts here
   if (ok == true) {
     pthread_t _thread;
   struct thread_params var;
   var.size = fileSize;
   pthread_create(&_thread,NULL,&get_thread_p,&var);
   pthread_join(_thread,NULL);
   response = GetReply();
   if ((response == 226) || (response == 250)) {
     // do nothing
   } else
     return 1;
   } else { //this is if ok is not true 
     pthread_t _thread;
   struct thread_params var;
   var.size = fileSize;
   pthread_create(&_thread,NULL,&get_thread_nop,&var);
   // no join so set a timer
   threadTimer = new QTimer(this);
   connect(threadTimer,SIGNAL(timeout()),this,SLOT(threadListener())); 
   threadTimer->start(300,FALSE); 
   }
  
   
   return 0;

}

void myFTP::threadListener() {
  if (get_threadFlag == 1) {
    threadTimer->stop();
    get_threadFlag = 0;
    // not an easy way to flag a bad response here ???
    // could use a global ?? wonder if i should
    GetReply();
  }
}


void* get_thread_p(void* variables) {
   struct thread_params *p = (struct thread_params*) variables;
   int fd, nTotal=0, nBytesRead=0;
   fd = fileno(fp);
  
   myProgressDialog *progressDialog = new myProgressDialog(0,"progress",false,
   Qt::WDestructiveClose | Qt::WStyle_Customize | Qt::WType_TopLevel | Qt::WStyle_Tool |
   Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop | Qt::WX11BypassWM);
   progressDialog->init(p->size);
   progressDialog->show();
  

  
   while( (nBytesRead=recv(DataSocket,Buffer,1024,0)) > 0) {
       
       	   write(fd,Buffer,nBytesRead);
	   nTotal+=nBytesRead;
      	   // printf("%s : %d received\r",fname,nTotal);
	  progressDialog->setProgressValue(nTotal);
   }
   //printf("\r\n");
   close(fd);
   //CloseDataConnection(DataSocket);
   close(DataSocket);
   DataSocket = INVALID_SOCKET;
   progressDialog->hide();
   return NULL;
}

void* get_thread_nop(void* unused) {
  int fd, nTotal=0, nBytesRead=0;
   fd = fileno(fp);

   
   while( (nBytesRead=recv(DataSocket,Buffer,1024,0)) > 0) {
       	   write(fd,Buffer,nBytesRead);
	   nTotal+=nBytesRead;
         	   //   printf("%s : %d received\r",fname,nTotal);
      }
      //printf("\r\n");
   close(fd);
   //CloseDataConnection(DataSocket);
   close(DataSocket);
    DataSocket = INVALID_SOCKET;
    get_threadFlag = 1;
    return NULL;   
}



void* put_thread(void* variables) {
  struct thread_params *p = (struct thread_params*) variables;
  int fd, nTotal=0, nBytesRead=0;
  fd = fileno(fp);
  
  myProgressDialog *progressDialog = new myProgressDialog(0,"progress",false,
    Qt::WDestructiveClose | Qt::WStyle_Customize | Qt::WType_TopLevel | Qt::WStyle_Tool |
    Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop | Qt::WX11BypassWM);
   progressDialog->init(p->size);
  progressDialog->show();
 
   while( (nBytesRead=read(fd,Buffer,1024)) > 0) {
             send(DataSocket,Buffer,nBytesRead,0);
             nTotal+=nBytesRead;
             progressDialog->setProgressValue(nTotal);
         }
   
   /*
    * close data connection
    */
    close(DataSocket);
    DataSocket = INVALID_SOCKET;
    close(fd);
     progressDialog->hide();
     return NULL;
}

// fullpath here is the files local path
int myFTP::PutFile( char *fname, char *fullpath,int s)
{
  
  int response;

   if( !fname || ! (*fname)) {
      printf("No file specified.\n");
      return 1;
   }
   if(! (fp=fopen(fullpath,(bMode==ASCII) ? "rt" : "rb"))) {
      perror("file open");
      return 1;
   }

   if( GetListenSocket() < 0) {
       fclose(fp);
       return 1;
   }
   
   /*
    * send command to server & read reply
    */
   sprintf(Buffer,"STOR %s\r\n",fname);
   if(!SendControlMsg(Buffer,strlen(Buffer))) {
      fclose(fp);
      return 1;
   }
   response = GetReply();
   if ((response == 125) || (response == 150)) {
     // do nothing
   } else
     return 1;
   /*
    * accept server connection
    */
   if( AcceptConnection() <= 0) {
       fclose(fp);
       return 1;
   }
   /* 
    * now send file
    */
   pthread_t new_thread;
   struct thread_params var;
   var.size = s;
   pthread_create(&new_thread,NULL,&put_thread,&var);
   pthread_join(new_thread,NULL);
   response = GetReply();
   if ((response == 226) || (response == 250)) {
     //do nothing
   } else
     return 1;
   return 0;

}


int myFTP::DoCD( char *dir)
{
  int response;
   if( !Connected ) {
       printf("Not Connected.\n");
       return 1;
   }

   /*
    * ignore leading whitespace
    */
   while( *dir && (*dir == ' ' || *dir == '\t') ) 
       dir++;
     if( !(*dir) ) {
	return 1;
      }
   /*
    * send command to server and read response
    */
   sprintf(Buffer, "CWD %s\r\n",dir);
   SendControlMsg(Buffer,strlen(Buffer));
   response = GetReply();
   if (response != 250)
     return 1;
   return 0;
}

int myFTP::SendDataMsg( char *Buffer, int len)

{
      if( send(DataSocket,Buffer,len,0) <= 0)
       return 0;

      return 1;

}

const QString myFTP::DoPWD()
{
 
  if( !Connected ) {
    QString nc = "Not Connected !";
    // printf("Not Connected.\n");
      return nc;
  }
  sprintf(Buffer, "PWD\r\n");
  SendControlMsg(Buffer,strlen(Buffer));
  int i = 0;
  memset(Buffer,0,1024);

    i = GetLine();
    if (i != 257) {
      QString br = "Bad server response";
     return br;
    }
    (void)strtok(Buffer,"\r\n");

    //puts(Buffer);
    const QString msg = QString(Buffer);
   
   
    memset(Buffer,0,1024);
    return msg;
  

}

int myFTP::DoRM( char *remoteFile)
{
  int response;
   if( !Connected ) {
       printf("Not Connected.\n");
       return 1;
   }

   /*
    * ignore leading whitespace
    */
   while( *remoteFile && (*remoteFile == ' ' || *remoteFile == '\t') ) 
       remoteFile++;
     if( !(*remoteFile) ) {
	return 1;
      }
   
   
   /*
    * send command to server and read response
    */
   sprintf(Buffer, "DELE %s\r\n",remoteFile);
   SendControlMsg(Buffer,strlen(Buffer));
   response = GetReply();
   if (response != 250) 
    return 1;
   return 0;
}

int myFTP::DoMV( char *originalName, char *newName)
{
  int response;
   if( !Connected ) {
       printf("Not Connected.\n");
       return 1;
   }

   /*
    * ignore leading whitespace
    */
   while( *originalName && (*originalName == ' ' || *originalName == '\t') ) 
       originalName++;
     if( !(*originalName) ) {
	return 1;
      }
   
   while( *newName && (*newName == ' ' || *newName == '\t') ) 
       newName++;
     if( !(*newName) ) {
	return 1;
      }
   
   
   /*
    * send command to server and read response
    */
   sprintf(Buffer, "RNFR %s\r\n",originalName);
   SendControlMsg(Buffer,strlen(Buffer));
   response = GetReply();
   if (response != 350) 
    return 1;

   sprintf(Buffer, "RNTO %s\r\n",newName);
   SendControlMsg(Buffer,strlen(Buffer));
   response = GetReply();
   if (response != 250)
     return 1;
   return 0;
}

int myFTP::DoRMDIR( char *dir)
{
  int response;
   if( !Connected ) {
       printf("Not Connected.\n");
       return 1;
   }

   /*
    * ignore leading whitespace
    */
   while( *dir && (*dir == ' ' || *dir == '\t') ) 
       dir++;
     if( !(*dir) ) {
	return 1;
      }
   
   
   /*
    * send command to server and read response
    */
   sprintf(Buffer, "RMD %s\r\n",dir);
   SendControlMsg(Buffer,strlen(Buffer));
   response = GetReply();
   if (response != 250)
     return 1;
   return 0;
}

int myFTP::DoMKDIR( char *dir)
{
  int response;
   if( !Connected ) {
       printf("Not Connected.\n");
       return 1;
   }

   /*
    * ignore leading whitespace
    */
   while( *dir && (*dir == ' ' || *dir == '\t') ) 
       dir++;
     if( !(*dir) ) {
	return 1;
      }
   
   
   /*
    * send command to server and read response
    */
   sprintf(Buffer, "MKD %s\r\n",dir);
   SendControlMsg(Buffer,strlen(Buffer));
   response = GetReply();
   if (response != 257)
     return 1;
   return 0;
}














