#include "myGoToDialog.h"
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>

      

myGoToDialog::myGoToDialog( QWidget * parent , const char * name ) :
      QDialog(parent, name, FALSE)
     
  {
     
      init();
    
  }
  

  
  myGoToDialog::~myGoToDialog()
  {
      
  }
  
  
 void myGoToDialog::init()
 {
    
     QVBoxLayout *contentPane;
   
      QGridLayout *buttonPane; 
     
     contentPane  = new QVBoxLayout(this);
     
     contentPane->setMargin( 0 );
      gotoGrp = new QGroupBox(0, Qt::Vertical, "GoTo", this);
     
     gotoLayout = new QGridLayout(gotoGrp->layout());
      
     
 
     gotoLabel = new QLabel("Line to GoTo:", gotoGrp);
     goLine = new QLineEdit(this);
     
     
     gotoLayout->addWidget(gotoLabel, 0, 0);
   
     gotoLayout->addMultiCellWidget(goLine, 1, 1, 0, 1);
      
     contentPane->addWidget(gotoGrp);
 
    
     
     buttonPane = new QGridLayout(contentPane->layout());
    
     QPushButton *go, *quit;
     go = new QPushButton( "Go", this );
    
     
        quit = new QPushButton( "Quit", this );
       
	connect( go, SIGNAL(clicked()),parent(), SLOT(_goto()) );
        connect( quit, SIGNAL(clicked()), SLOT(slotQuit()) );
       
	buttonPane->addWidget(go,0,2);
        buttonPane->addWidget(quit,0,3);   
       
    
 }

 

QString myGoToDialog::line() 
 {
   QString line = goLine->text(); 
    return line;
 }
 
 
 
 
 
void myGoToDialog::slotQuit() {
  close();
}

void myGoToDialog::closeEvent( QCloseEvent *event ) {
  event->accept();
}













