#include "myMailDialog.h"
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <kcombobox.h>
#include <qstringlist.h>
#include <qrect.h>

myMailDialog::myMailDialog( QWidget * parent , const char * name ) :
      QDialog(parent, name, FALSE)
     
  {
     
      init();
      
  }


  

  
  myMailDialog::~myMailDialog()
  {
      
  }
  
  
 void myMailDialog::init()
 {
     
   
  

     QVBoxLayout *contentPane;
      
      QGridLayout *subjectPane;
      QGridLayout *buttonPane; 
    
     contentPane  = new QVBoxLayout(this);
     
     contentPane->setMargin( 0 );
      recipientGrp = new QGroupBox(0, Qt::Vertical, "Email Recipient", this);
     
     recipientLayout = new QGridLayout(recipientGrp->layout());
     
     recipientLabel = new QLabel("Recipient:", recipientGrp);
     recipients = new KHistoryCombo(TRUE,recipientGrp);
     recipients->setDuplicatesEnabled(FALSE);
     recipients->setMaxCount(10);
     recipients->setFixedWidth(400);
     recipientLayout->addWidget(recipientLabel, 3, 0);
   
     recipientLayout->addMultiCellWidget(recipients, 3, 3, 1, 3);
      
     contentPane->addWidget(recipientGrp);
 
    
     
     subjectGrp = new QGroupBox(0, Qt::Vertical,"Email Subject", this);
    
     subjectPane = new QGridLayout(subjectGrp->layout());
   
     
 
     subjectLabel = new QLabel("Subject:", subjectGrp);
     subject = new QLineEdit(subjectGrp);
     subject->setFixedWidth(400);
     
     subjectPane->addWidget(subjectLabel, 3, 0);
     
       subjectPane->addMultiCellWidget(subject, 3, 3, 1, 3);
       //contentPane->addSpacing(13);
        contentPane->addWidget(subjectGrp);
       buttonGrp = new QGroupBox(0, Qt::Vertical,0,this);
    
     buttonPane = new QGridLayout(buttonGrp->layout());
    
     QPushButton *send, *quit;
     send = new QPushButton( "Send", buttonGrp );
    
     
        quit = new QPushButton( "Quit", buttonGrp );
          connect( send, SIGNAL(clicked()),parent(), SLOT(SEND_MAIL()) );
        
        
        connect( quit, SIGNAL(clicked()), SLOT(slotQuit()) );
        
	buttonPane->addWidget(send,0,2);
        buttonPane->addWidget(quit,0,3);   
        contentPane->addWidget(buttonGrp);      
    
 }

 
QStringList myMailDialog::recipientHistory() const  {
  return recipients->historyItems();
}

QString myMailDialog::getRecipient() 
 {
   QString line = recipients->currentText(); 
   recipients->addToHistory(line);
    return line;
 }
 

void myMailDialog::setRecipientHistory(const QStringList &strings) {
  if (strings.count() > 0)
    recipients->setHistoryItems(strings,TRUE);
  else
    recipients->clearHistory();
}

QString myMailDialog::getSubject() 
 {
   QString str = subject->text(); 
    return str;
 } 
 
 
 
void myMailDialog::slotQuit() {
  close();
}

void myMailDialog::Quit() {
  close();
}

void myMailDialog::closeEvent( QCloseEvent *event ) {
  event->accept();
}













