#include "myReplaceDialog.h"
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>

bool replacecs = false;
bool replaceww = false;
bool replacesb = false;
bool replacep = false;     

myReplaceDialog::myReplaceDialog( QWidget * parent , const char * name ) :
      QDialog(parent, name, FALSE)
     
  {
     
      init();
      // setOptions();
  }
  

  
  myReplaceDialog::~myReplaceDialog()
  {
      
  }
  
  
 void myReplaceDialog::init()
 {
     
   
  

     QVBoxLayout *contentPane;
      QGridLayout *optionsPane;
      QGridLayout *replacePane;
      QGridLayout *buttonPane; 
     
     contentPane  = new QVBoxLayout(this);
     
     contentPane->setMargin( 0 );
      findGrp = new QGroupBox(0, Qt::Vertical, "Find", this);
     
     findLayout = new QGridLayout(findGrp->layout());
      
     
 
     findLabel = new QLabel("     Text to find:", findGrp);
     find = new QLineEdit(findGrp);
     
     
     findLayout->addWidget(findLabel, 3, 0);
   
     findLayout->addMultiCellWidget(find, 3, 3, 1, 2);
      
     contentPane->addWidget(findGrp);
 
    
     optionGrp = new QGroupBox(0, Qt::Vertical,"Options", this);
          optionsPane = new QGridLayout(optionGrp->layout());
     
     caseSensitive = new QCheckBox("C&ase sensitive", optionGrp);
      wholeWordsOnly = new QCheckBox("&Whole words only", optionGrp);
      backwards = new QCheckBox("&Search backwards" , optionGrp);
     prompt = new QCheckBox("&Prompt each replace" , optionGrp);
     optionsPane->addWidget(caseSensitive,0,0);
      optionsPane->addWidget(wholeWordsOnly,0,1);
      optionsPane->addWidget(backwards,1,0);
      optionsPane->addWidget(prompt,1,1);
     contentPane->addWidget(optionGrp);
     //contentPane->addSpacing(9);
     // this one is an experiment
     replaceGrp = new QGroupBox(0, Qt::Vertical,"Replace", this);
     // replaceLayout = new QGridLayout(contentPane->layout());
     replacePane = new QGridLayout(replaceGrp->layout());
      
     
 
     replaceLabel = new QLabel("  Replace with:", replaceGrp);
     replaceWith = new QLineEdit(replaceGrp);
     
     
     replacePane->addWidget(replaceLabel, 3, 0);
     
       replacePane->addMultiCellWidget(replaceWith, 3, 3, 1, 2);
       //contentPane->addSpacing(13);
        contentPane->addWidget(replaceGrp);
       buttonGrp = new QGroupBox(0, Qt::Vertical,0,this);
    
     buttonPane = new QGridLayout(buttonGrp->layout());
    
     QPushButton *replace, *quit;
     replace = new QPushButton( "Replace", buttonGrp );
    
     
        quit = new QPushButton( "Quit", buttonGrp );
       
        connect( replace, SIGNAL(clicked()),parent(), SLOT(_replace()) );
        connect( quit, SIGNAL(clicked()), SLOT(slotQuit()) );
        connect( quit, SIGNAL(clicked()),parent(), SLOT(writeReplaceSettings()) ); 
	buttonPane->addWidget(replace,0,2);
        buttonPane->addWidget(quit,0,3);   
        contentPane->addWidget(buttonGrp);      
    
 }

 
bool myReplaceDialog::case_sensitive() {
  if (caseSensitive->isChecked()) {
    replacecs = true;
    return true;
  }
  else {
    replacecs = false;
    return false;
  }
}
 
bool myReplaceDialog::word_only() {
  if (wholeWordsOnly->isChecked()) {
    replaceww = true;
    return true;
  }
  else {
    replaceww = false;
    return false;
  }
}

bool myReplaceDialog::search_backwards() {
  if (backwards->isChecked()) {
    replacesb = true;
    return true;
  }
  else {
    replacesb = false;
    return false;
  }
}

bool myReplaceDialog::_prompt() {
  if (prompt->isChecked()) {
    replacep = true;
    return true;
  }
  else {
    replacep = false;
    return false;
  }
}

void myReplaceDialog::setReplacecs(bool b) {
  replacecs = b;
}

void myReplaceDialog::setReplaceww(bool b) {
  replaceww = b;
}

void myReplaceDialog::setReplacesb(bool b) {
  replacesb = b;
}

void myReplaceDialog::setReplacep(bool b) {
  replacep = b;
}


QString myReplaceDialog::pattern() 
 {
   QString line = find->text(); 
    return line;
 }
 

QString myReplaceDialog::replacePattern() 
 {
   QString str = replaceWith->text(); 
    return str;
 } 
 
 void myReplaceDialog::setOptions()
 {
     caseSensitive->setChecked(replacecs);
     wholeWordsOnly->setChecked(replaceww);
     backwards->setChecked(replacesb);
     prompt->setChecked(replacep);
 }
 
// void myFindDialog::changed(const QString & s) {
// findString = find->text();
//}
 
//void myFindDialog::slotFind()
//{

//    Nothing to find?
//  if  (pattern().isEmpty())
// {
//       KMessageBox::error(this, i18n("You must enter some text to search for."));
//     return;
// }
 
     
     
//}
 
void myReplaceDialog::slotQuit() {
  close();
}

void myReplaceDialog::closeEvent( QCloseEvent *event ) {
  event->accept();
}













