/* This file is part of the Yzis libraries
 *  Copyright (C) 2004 Lucijan Busch <luci@yzis.org>,
 *  Copyright (C) 2004-2005 Mickael Marchand <marchand@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

/**
 * $Id: line.h 1494 2005-01-02 22:22:18Z mikmak $
 */

#ifndef YZIS_LINE_H
#define YZIS_LINE_H

#if QT_VERSION < 0x040000
#include <qobject.h>
#include <qmap.h>
#else
#include <QVector>
#endif

/**
 * this class represents a line in the buffer
 * it holds the actual data and metadata
 */
class YZLine
{
	public:
		YZLine(const QString &l);
		YZLine();
		~YZLine();

		const QString& data() const { return mData; }
		void setData(const QString &data);
		int length() { return mData.length(); }
#if QT_VERSION < 0x040000
		inline const QMemArray<short> &ctxArray () const { return m_ctx; };
		inline void setContext (QMemArray<short> &val) { m_ctx.assign (val); }
#else
		inline const QVector<short> &ctxArray () const { return m_ctx; };
		inline void setContext (QVector<short> &val) { m_ctx = val; }
#endif
		inline bool hlLineContinue () const { return m_flags & YZLine::flagHlContinue; }

		inline void setHlLineContinue (bool cont)
		{
			if (cont) m_flags = m_flags | YZLine::flagHlContinue;
			else m_flags = m_flags & ~ YZLine::flagHlContinue;
		}


		inline uchar *attributes () { return mAttributes.data(); }
		bool initialized() { return m_initialized; }

		int firstChar() const;
		int lastChar() const;
		int nextNonSpaceChar(uint pos) const;
		int previousNonSpaceChar(uint pos) const;

		enum Flags
		{
			flagNoOtherData = 0x1, // ONLY INTERNAL USE, NEVER EVER SET THAT !!!!
			flagHlContinue = 0x2,
			flagVisible = 0x4,
			flagAutoWrapped = 0x8
		};

	private:
		QString mData;

#if QT_VERSION < 0x040000
		//rendering settings for each char
		QMemArray<uchar> mAttributes;
		//contexts for HL
		QMemArray<short> m_ctx;
#else
		//rendering settings for each char
		QVector<uchar> mAttributes;
		//contexts for HL
		QVector<short> m_ctx;
#endif
		/**
		  Some bools packed
		  */
		uchar m_flags;
		bool m_initialized;
};

#endif
