#include "expDecayDialog.h"
#include "graph.h"
#include "colorBox.h"
#include "application.h"
#include "Fitter.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qmessagebox.h>

expDecayDialog::expDecayDialog(int type, QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
		setName( "expDecayDialog" );
	
	slopes = type;
	
	setCaption(tr("QtiPlot - Verify initial guesses"));	
	GroupBox1 = new QButtonGroup( 2,QGroupBox::Horizontal,tr(""),this,"GroupBox1" );

	new QLabel( tr("Exponential Fit of"), GroupBox1, "TextLabel1",0 );
	boxName = new QComboBox(GroupBox1, "boxName" );
	
	if (type < 0)
		dampingLabel = new QLabel( tr("Growth time"), GroupBox1, "TextLabel2",0 );
	else if (type == 1)
		dampingLabel = new QLabel( tr("Damping"), GroupBox1, "TextLabel2",0 );
	else
		dampingLabel = new QLabel( tr("First decay time (t1)"), GroupBox1, "TextLabel2",0 );
	
	boxFirst = new QLineEdit(GroupBox1, "boxOrder" );
	boxFirst->setText(tr("1"));
	
	if (type > 1)
	{
	new QLabel( tr("Second decay time (t2)"), GroupBox1, "TextLabel3",0 );
	boxSecond = new QLineEdit(GroupBox1, "boxPoints" );
	boxSecond->setText(tr("1"));
	
	thirdLabel=new QLabel( tr("Third decay time (t3)"), GroupBox1, "TextLabel5",0 );
	
	boxThird = new QLineEdit(GroupBox1, "boxOrder" );
	boxThird->setText(tr("1"));

	if (type < 3)
		{
		thirdLabel->hide();
		boxThird->hide();
		}
	}
	
	if (type <= 1)
		new QLabel( tr("Amplitude"), GroupBox1, "TextLabel4",0 );
	else
		new QLabel( tr("Initial time"), GroupBox1, "TextLabel4",0 );
	
	boxStart = new QLineEdit(GroupBox1, "boxStart" );
	
	if (type == 1)
		boxStart->setText(tr("1"));
	else
		boxStart->setText(tr("0"));
	
	new QLabel( tr("Y Offset"), GroupBox1, "TextLabel5",0 );
	boxYOffset = new QLineEdit(GroupBox1, "boxEnd" );
	boxYOffset->setText(tr("0"));

	new QLabel( tr("Color"), GroupBox1, "TextLabel52",0 );
	boxColor = new ColorBox( FALSE, GroupBox1);
	boxColor->setColor(QColor(red));
	
	GroupBox2 = new QButtonGroup(1,QGroupBox::Horizontal,tr(""),this,"GroupBox2" );
	GroupBox2->setFlat (TRUE);
	GroupBox2->setLineWidth (0);
	
	buttonFit = new QPushButton(GroupBox2, "buttonFit" );
    buttonFit->setAutoDefault( TRUE );
	buttonFit->setDefault( TRUE );
   
    buttonCancel = new QPushButton(GroupBox2, "buttonCancel" );
    buttonCancel->setAutoDefault( TRUE );
	
	QHBoxLayout* hlayout = new QHBoxLayout(this,5,5, "hlayout");
    hlayout->addWidget(GroupBox1);
	hlayout->addWidget(GroupBox2);

    languageChange();
   
    // signals and slots connections
	connect( buttonFit, SIGNAL( clicked() ), this, SLOT(fit()));
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT(reject()));
}


expDecayDialog::~expDecayDialog()
{
}


void expDecayDialog::languageChange()
{
	buttonFit->setText( tr( "&Fit" ) );
	buttonCancel->setText( tr( "&Close" ) );
}

void expDecayDialog::setGraph(Graph *g)
{
if (!g)
	return;

graph = g;
boxName->insertStringList (graph->curvesList(),-1);

connect (graph, SIGNAL(closedGraph()), this, SLOT(close()));
};

void expDecayDialog::fit()
{
QString curve = boxName->currentText();
QStringList curvesList = graph->curvesList();
if (curvesList.contains(curve) <= 0)
	{
	QMessageBox::critical(this,tr("QtiPlot - Warning"),
		tr("The curve <b> %1 </b> doesn't exist anymore! Operation aborted!").arg(curve));
	boxName->clear();
	boxName->insertStringList(curvesList);
	return;
	}

ApplicationWindow *app = (ApplicationWindow *)this->parent();
Fit *fitter;
if (slopes == 3)
	{		
	double x_init[7] = {1.0, boxFirst->text().toDouble(), 1.0, boxSecond->text().toDouble(), 
						1.0, boxThird->text().toDouble(), boxYOffset->text().toDouble()};
	fitter = new ThreeExpFit(app, graph);
	fitter->setInitialGuesses(x_init);
	}
else if (slopes == 2)
	{
	double x_init[5] = {1.0, boxFirst->text().toDouble(), 1.0, boxSecond->text().toDouble(), 
						boxYOffset->text().toDouble()};
	fitter = new TwoExpFit(app, graph);
	fitter->setInitialGuesses(x_init);
	}
else if (slopes == 1 || slopes == -1)
	{
	double x_init[3] = {boxStart->text().toDouble(), slopes/boxFirst->text().toDouble(), boxYOffset->text().toDouble()};
	fitter = new ExponentialFit(app, graph, slopes == -1);
	fitter->setInitialGuesses(x_init);
	}

if (fitter->setDataFromCurve(boxName->currentText(), 
	boxStart->text().toDouble(), boxStart->text().toDouble() - 1))
	{
	fitter->setColor(boxColor->currentItem());
	fitter->generateFunction(app->generateUniformFitPoints, app->fitPoints);
	fitter->fit();
	delete fitter;
	}
}
