#include <iostream>

#include <qfile.h>
#include <qstring.h>
#include <qlibrary.h>

#include <kdebug.h>
#include <kstandarddirs.h>

#include <akode/localfile.h>
#include <akode/audiobuffer.h>
#include <akode/audioframe.h>
#include <akode/framedecoder.h>


#include "kmp3burn.h"
#include "akodestuff.h"

using namespace std;


	// kde 3.3  -> libakode 1.0
	// kde 3.4  -> libakode 1.0

	// kde 3.5 -> libakode ist nicht mehr in KDE eingefügt, und darf deshalb nicht mehr in
	// den KDE Quellen gesucht werden. Ab KDE 3.5 muss akode als externes paket eingebunden werden,
	// und ist in Version 2.0 Vervügbar. Die Quellen müssen angepasst werden,
	// was bedeutet, dass ein Packet für KDE 3.5 nicht mehr für 3.4 oder 3.3 übersetzt werden kann, ohne
	// bedingte Kompelierung 

	// kde 3.4.1     31.mai       2005
	// kde 3.4.2     28.juli      2005
	// kde 3.4.3     13.october   2005

	// kde 3.5.1     31.januar    2006
	// kde 3.5.2     28.märz      2006
	// kde 3.5.3     31.mai       2006


	// sox comand:
	// sox -V -x -s -r 44100 -w -c 2 cdr_out.raw unsigned.au     

	// mono:
	// sox -V -x -s -r 44100 -w -c 1 cdr_out.raw unsigned.au 
	
	// -s = signed linear  (2's  complement)       *****************
	// -u = unsigned  linear
	// -U = u-law  (logarithmic)
	// -A = A-law (logarithmic)
	// -a = ADPCM
	// -i = IMA_ADPCM,
	// -g = GSM
	// -f = Floating-point.
	// -V = verbose
	// -t = type
	// -x = swap word order
	// -w = sample size = 16 bit words
	// -c = channels
	// -r = samplerate
	//  - = stdin, stdout 
	// -b = bytes    
	// -l = 32-bit long words
	// -d = 64-bit double long (long long) words

	// sample = 2 byte + 2 cannals
	// playtime = Samples/rate
	// sectors = playtime * 75


AkodeStuff::AkodeStuff(struct song_info *s)
{
	this->channels = s->channels;
	QString f = s->f_path;
	DecoderPlugin *dP = NULL;
	
	if (f.endsWith("mp3") || f.endsWith("MP3"))
		dP = new DecoderPluginHandler("mpeg");
	else if (f.endsWith("ogg") || f.endsWith("OGG"))
		dP = new DecoderPluginHandler("xiph");
	else if  (f.endsWith("flac") || f.endsWith("FLAC") )  
		dP = new DecoderPluginHandler("xiph");
	if (!dP) {
		kdDebug() << "AkodeStuff: cant get DecoderPlugin" << endl;
		kdDebug() << "AkodeStuff:" << f << endl;
	}

	QString link;
	link = ::locateLocal("data","kmp3burn/",true) + "link.xxx";
	unlink(link);

	symlink(QFile::encodeName(f),link);
	LocalFile *lfp = new LocalFile(link); // mp3 ogg flac
	if (!lfp->openRO()) { 
		kdDebug() << "AkodeStuff: Unreadable file: " <<  f << endl;
	}

	dec = NULL;
	dec = dP->openFrameDecoder(lfp);
	if (!dec)  {
		kdDebug() << "AkodeStuff: cant get Decoder" << endl;
		kdDebug() << "AkodeStuff:" << f << endl;
		}
}


AkodeStuff::~AkodeStuff() {}

char *AkodeStuff::decode_frame(unsigned int *s)
{
	AudioFrame *frame = new AudioFrame; 
	if ( !dec ) return false;
	if ( !dec->eof() && !dec->error() ) {

		dec->readFrame( frame );
		int16_t **data = (int16_t**)frame->data;
 
		int16_t *pcmout = new int16_t[frame->length*frame->channels];
		for( int j = 0; j < frame->channels ; j++)
			for( int i = 0; i < frame->length; i++ ) 
				pcmout[frame->channels*i+j] = data[j][i];

		unsigned int sz = (frame->length*frame->channels*2);
		*s = sz;
		char *buff;
		buff = new char[sz];
		memcpy(buff,pcmout,sz);

		delete frame;
		delete pcmout;

		// Swap byte order 
		if ( sz%2 ) kdDebug() << "AkodeStuff: warning: unexpexted Buffersize" << endl;
		for (unsigned int c = 0; c < sz; c+=2) {
			unsigned char d  = buff[c];
			unsigned char e  = buff[c+1];
			buff[c] = e;
			buff[c+1] = d;
		}

		// force stereo if mono
		if ( channels == 0 || channels == 1 ) {
			int stereobufferzize = sz*2;
			char *bufff = new char[stereobufferzize];

			for(unsigned int i = 0 ; i < sz ;) {
				unsigned char d  = buff[i+0];
				unsigned char e  = buff[i+1];
				bufff[i*2 +0] = d;
				bufff[i*2 +1] = e;
				bufff[i*2 +2] = d;
				bufff[i*2 +3] = e;
				i+=2;
			}
		*s = sz*2;
		return bufff;        // Mono
		}
		else return buff;   // Stereo
	}
	else

		// TODO error handler
	s = NULL;
	return NULL;
}

void AkodeStuff::putout_decoders()
{
	QString p;
	list<string> plugins = DecoderPluginHandler::listDecoderPlugins();
	for(list<string>::const_iterator s = plugins.begin(); s != plugins.end(); s++) {
		p+= *s;
		p+= "  ";
	}
	kdDebug() << "AkodeStuff: DecoderPlugins: " << p << endl;
}

bool AkodeStuff::have_codec(const char *codec)
{
	DecoderPlugin *dp = NULL;

	if (codec == QString("mp3")) {
		dp  = new DecoderPluginHandler("mpeg");
		if (dp) return true;
		else return false;
	}
	else if (codec == QString("ogg")) {
		dp  = new DecoderPluginHandler("xiph");
		if (dp) return true;
		else return false;
	}
	else if (codec == QString("flac")) {
		dp  = new DecoderPluginHandler("xiph");
		QLibrary lib("akode_xiph_decoder");
		bool sym = lib.resolve("FLAC__seekable_stream_decoder_process_single");
		if (dp && sym) return true;
		else return false;
	}

	else return false;
}
