
#include <unistd.h> // usleep

#include <qtimer.h>

#include <klocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kapplication.h>

#include "kmp3burn.h"
#include "burn.h"
#include "sysmonitor.h"
#include "configdialog.h"
#include "decoding.h"
#include "tools.h"
#include "myprocess.h"

Burn::Burn(QObject *parent, const char *name): QObject(parent, name),
cnt(0),cnt_txt(0)

{
	time   = new QTimer();
	time->start( 1000, false );
	connect(time,SIGNAL(timeout()),SLOT(serve_next_song(void)));
}
Burn::~Burn() {}

int Burn::start(Kmp3burn *x)
{
	all = x;
	all->sys_mon->show_win();
	all->sys_mon->all = "";
	QStringList sl;

	/** DEBUG */
	//sl.append("/home/martin/kmp3burn/software/mcdrecord");
	sl.append("cdrecord");

	sl.append("-v");
	sl.append("-eject");
	sl.append("-pad");
	sl.append("-audio");
	sl.append(QString("speed=")  + QString::number(all->con->speeed));
	sl.append(QString("dev=")    + all->con->scsi);

	if (all->tools->dao)         sl.append("-dao");
	if (all->tools->useinfo)     sl.append("-useinfo");
	if (all->tools->shorttrack)  sl.append("-shorttrack");
	if (all->tools->driveropts)  sl.append("driveropts=burnfree");
	if (all->tools->gracetime)   sl.append("-gracetime=2");
	if (all->con->dummyMode)     sl.append( "-dummy");
	if (all->tools->overburn)    sl.append("-overburn");
 
	// find path
	KStandardDirs sd;
	QString work_dir = sd.localkdedir() + sd.kde_default("data") + "kmp3burn/";

	// add inf files
	for (unsigned int i = 0 ; i < all->cnt_inf_files; i++ )
		sl.append(work_dir + QString::number(i) + ".inf");

	// cdrecord line at console and sysmonitor
	QString out1;
	for (QStringList::Iterator it = sl.begin(); it != sl.end(); ++it ) {
		out1 +=  *it + " "; 
		if(out1.endsWith(".inf ") || out1.endsWith("-overburn ")  || out1.endsWith("info "))
			out1 += '\n';
	}

	QString out0 = "\n\n\n##### CDRECORD Process: ################################\n";
	QString out2 = "\n##### CDRECORD Process END ############################\n\n\n";

	if (out1.endsWith("\n"))  out1.truncate(out1.length() -1  );   
	kdDebug() << out0 << endl << out1 << endl << out2;

	all->sys_mon->collect_std(NULL,(char *)out0.latin1(),out0.length());
	all->sys_mon->collect_std(NULL,(char *)out1.latin1(),out1.length());
	all->sys_mon->collect_std(NULL,(char *)out2.latin1(),out2.length());

	p = new MyProcess;
	p->setRawStdin(true);
	(*p) << sl; 
	p->setSuppressEmptyLines(false);

	connect (p, SIGNAL (receivedStdout(KProcess*, char* ,int)),
		all->sys_mon,SLOT(collect_std(KProcess *,char *,int)));

	connect (p, SIGNAL (receivedStderr(KProcess*, char* ,int)),
		all->sys_mon,SLOT(collect_std(KProcess *,char*, int)));

	connect (p, SIGNAL (processExited(KProcess *)), all,SLOT(burnEnd(KProcess *)));

	bool cdp = p->start(KProcess::NotifyOnExit,(KProcess::All));
	if(!cdp) { kdDebug() << "can't start cdrecord!" << endl; return -1; }

	cdrecord_stdin_fp = p->stdinFd();
	if(cdrecord_stdin_fp < 0) {
		kdDebug() << "can't get cdrecord_stdin_fp: " << endl; return -1; }

	deco = new Decoding();  // PlugInSetzen
	while(cnt < all->rechts.count()) {
		loop();
		emit song_finish(++cnt);
	}

if ( p->isRunning() ) {
	deco->write_null();
	deco->close_stream();
	}

	if(!p->isRunning()) all->burnEnd(p);

	return 0;
}

void Burn::loop()
{
	struct song_info *si = static_cast<song_info *> (all->rechts.at(cnt));
	int ret  = deco->open_music_f(si, cdrecord_stdin_fp, true );
	if ( ret < 0 ) {
		kdDebug() << "Burn: Could not load decoder-plugin!" << endl;
		return;
	}
	while(-1 != deco->decode()) ; // Decoder starten
}

int Burn::burnImage(Kmp3burn *x)
{
	all = x;
	QStringList sl;

	sl.append("cdrecord");
	sl.append("-v");
	sl.append("-audio");
	sl.append("-pad");
	sl.append("-eject");
	sl.append( QString("dev=") + all->con->scsi );
	sl.append( QString("speed=") + QString::number(all->con->speeed));

	if (all->tools->overburn)   sl.append("-overburn");
	if (all->tools->tao)        sl.append("-tao");
	if (all->tools->gracetime)  sl.append("-gracetime=2");
	if (all->con->dummyMode)    sl.append( "-dummy");

	for (unsigned int n = 0 ; n < all->rechts.count() ; n++ )
		sl.append(QString(all->work_dir + "wav/" + QString::number(n) + ".wav" ));

	all->sys_mon->setActiveWindow();
	all->sys_mon->show_win();

	QString info("##### CDRECORD Process: #####");
	QString info2("#############################");
	QString output;

	for (QStringList::Iterator it = sl.begin(); it != sl.end(); ++it ) {
		output +=  *it + " "; 
		if(output.endsWith(".wav "))
			output += '\n';
		}

	all->sys_mon->collect_std(NULL,(char *)info.latin1(),info.length());
	all->sys_mon->collect_std(NULL,(char *)output.latin1(),output.length());
	all->sys_mon->collect_std(NULL,(char *)info2.latin1(),info2.length());

	p = new MyProcess();
	(*p) << sl;
	p->start(KProcess::NotifyOnExit, KProcess::AllOutput);
	if(!p) {
		kdDebug() << "can't start cdrecord!" << endl;
		return -1;
	}

	connect (p, SIGNAL (receivedStdout(KProcess*, char* ,int)),
		all->sys_mon,SLOT(collect_std(KProcess *,char *,int)));
	connect (p, SIGNAL (receivedStderr(KProcess*, char* ,int)),
		all->sys_mon,SLOT(collect_std(KProcess *,char*, int)));
	connect (p, SIGNAL (processExited(KProcess*)),all, SLOT(burnEnd(KProcess *)));

	return 0;
}


void Burn::serve_next_song( void )
{
	if ((cnt_txt < all->rechts.count()) && ((all->sys_mon->akt_sng).isEmpty())) {
		all->sys_mon->akt_sng=(static_cast<song_info *>(all->rechts.at(cnt_txt)))->base_name;
		cnt_txt++;
	}
}
