
#include <config.h>
#include <kdebug.h>
#include "burner.h"

#ifdef K3B

#include <qptrlist.h>

#include <k3bdevicemanager.h>
#include <k3bdevice.h>
#include <k3bmsf.h>

Burner::Burner(QObject *parent, const char *name)
 : QObject(parent, name)
{
	using namespace K3bCdDevice;
	using namespace K3b;
	haveK3b = true;
	
	dm = new DeviceManager();

	kdDebug() << "Kmp3burn is compiled with libk3bdevice"  << endl;

	dm->findDevice("/dev/scd0");
	dm->findDevice("/dev/scd");

	dm->findDevice("/dev/hda");
	dm->findDevice("/dev/hdb");
	dm->findDevice("/dev/hdc");
	dm->findDevice("/dev/hdd");

	dm->findDevice("/dev/sr0");
	dm->findDevice("/dev/sr1");
	dm->findDevice("/dev/sr2");
	dm->findDevice("/dev/sr3");

	dm->scanbus();
  
	QPtrList<CdDevice> devList( dm->cdWriter() );
	for( k3bDevice = devList.first(); k3bDevice; k3bDevice = devList.next() )
		{
		if (k3bDevice->writesCd()) {

			DevName = k3bDevice->devicename();
			BusTarLun = k3bDevice->busTargetLun();
			
			 //Interface Typ

			if (k3bDevice->SCSI == k3bDevice->interfaceType()) 
				this->InterfaceType = "SCSI";
		
			if (k3bDevice->IDE == k3bDevice->interfaceType()) 
				this->InterfaceType = "IDE";
		
			if (k3bDevice->OTHER == k3bDevice->interfaceType()) { 
				this->InterfaceType = "OTHER";
				return;
			}


			if ( InterfaceType == "SCSI")
				BurnDevice = BusTarLun;
			
			if ( InterfaceType == "IDE")
				BurnDevice = DevName;


			// Dedect the speed factor of the writing process. @param mws is an
			// integer, representing a multiple of the audio speed.  This is about
			// 150 KB/s for CD-ROM, about 172 KB/s for CD-Audio media.
			
			WriteSpeed = k3bDevice->determineMaximalWriteSpeed();
			WriteSpeed = WriteSpeed/172;


			kdDebug() << "********************************************" << endl;
			kdDebug() << "Vendor CD-Burner:         " << k3bDevice->vendor() << endl;
			kdDebug() << "Description:              " << k3bDevice->description() << endl;
			kdDebug() << "Version:                  " << k3bDevice->version() << endl;
			kdDebug() << "Maximal Write Speed:      " << WriteSpeed << "x" << endl;
			kdDebug() << "Interface Typ:            " << InterfaceType << endl;
			kdDebug() << "busTargetLun:             " << BusTarLun << endl;
			kdDebug() << "DeviceName:               " << DevName << endl;
			kdDebug() << "Burn Device (Autodedect): " << BurnDevice << endl;
			kdDebug() << "********************************************" << endl;
		}
	}
}


bool Burner::isBurnerReady()
{
	k3bDevice = dm->findDevice( DevName );
	if(k3bDevice)
		return k3bDevice->isReady();
	return true;
}

#else
Burner::Burner(QObject *parent, const char *name)
 : QObject(parent, name)
{
	haveK3b = false;
}
bool Burner::isBurnerReady()   {return true;}

#endif

Burner::~Burner(){}
