#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcolor.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>

#include <kstandarddirs.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <klocale.h>

#include "configdialog.h"

ConfigDialog::ConfigDialog(QWidget *parent, const QString & caption):
KDialogBase(KJanusWidget::IconList,caption, Ok | Cancel, Ok, parent),
	cpu_mhz(0),cpu_cache(0),ram_size(0)

	{
	QFrame *cdrom = addPage(i18n("SCSIDevice"),i18n("SCSIDevice"),
		BarIcon("cdwriter_unmount",KIcon::SizeMedium));
   
	QFrame *dir = addPage(i18n("mp3 dir"), i18n("mp3 dir"),
		BarIcon("fileopen", KIcon::SizeMedium));

	QFrame *name = addPage(i18n("Playlists filename"), i18n("Playlists filename"),
		BarIcon("filesave", KIcon::SizeMedium));
	
	QFrame *speed = this->addPage(i18n("Cdrecord Speed\nDummy Mode "), i18n("cdrecord speed"),
		BarIcon("goto", KIcon::SizeMedium));
        
	QFrame *pdir = addPage(i18n("Playlists Dir"), i18n("Playlists Dir"),
		BarIcon("fileopen", KIcon::SizeMedium));

	QFrame *son = addPage((i18n("Fine Tuning")), i18n("Fine Tuning"),
		BarIcon("bookmark", KIcon::SizeMedium));	

 	// cdrom	 
	QLabel *le = new QLabel(i18n("SCSI Device:"),cdrom);
	le->setGeometry(50,50,100, 20);
	la = new QLineEdit(cdrom);
	la->setGeometry(50,80, 150, 20);
	QString info(i18n("Examples for Kernel 2.4.x: \n0,0,0 \n0,0,1 \n\nExamples for Kernel 2.6.x:\n/dev/cdrom\n/dev/dvdrecorder\n/dev/hdb\n/dev/hdc"));

	QLabel *scsiInfo = new QLabel(info,cdrom);
	scsiInfo->setGeometry(50,130, 200, 200);

	// mp3dir
	QLabel  *la_b = new QLabel(i18n("mp3 dir:"),dir);
	la_b->setGeometry(50,50, 100, 20);
	le_b = new QLineEdit(dir);
	le_b->setGeometry(50,80,230, 20);
	KIconLoader *loader = new KIconLoader();
	QPixmap fileopen;
	fileopen.load(loader->iconPath(QString("fileopen"),-32));
	QPushButton *dirButton = new QPushButton(QIconSet( fileopen ),"",dir);
	dirButton->setGeometry(50,130,40,25);
	connect(dirButton , SIGNAL( clicked() ),this, SLOT(open_file()));

	// cdrecord speed
	QLabel *label_speed = new QLabel(i18n("Cdrecord  Speed:"),speed);
	label_speed->setGeometry(50,50, 200, 20);
	sb_c = new QSpinBox(0,49,1,speed);
	sb_c->setGeometry(50,80,50, 20);
	sb_c->setValue(0);
	radBut = new QRadioButton(i18n("Dummy Mode"),speed);
	radBut ->setGeometry(50, 120, 160,  50 );
	radBut ->show();

	// playlist
	QLabel   *la_d = new QLabel(i18n("Save burned projects as playlist by default:"),name);
	la_d->setGeometry(50,50, 300, 20);
	bG = new	QButtonGroup(3,Qt::Vertical,name);
	bG->setGeometry(50,80,285,100);
	QRadioButton *butt0 = new QRadioButton(i18n("as Timestamp"),bG,"0");
	bG->insert(butt0,0);
	connect( butt0, SIGNAL(clicked()), this, SLOT(bGroup())) ;
	QRadioButton *butt1 = new QRadioButton(i18n("as First tracks name"),bG,"1");
	bG->insert(butt1,1);
	connect( butt1, SIGNAL(clicked()), this, SLOT(bGroup())) ;
	QRadioButton *butt2 = new QRadioButton(i18n("Don't save burned projects automaticly"),bG,"2");
	bG->insert(butt2,2);
	connect( butt2, SIGNAL(clicked()), this, SLOT(bGroup()));
	connect(this,SIGNAL(okClicked()),this,SLOT(ok()));
	QLabel  *playlist_label = new QLabel(i18n("Playlists Dir:"),pdir);
	playlist_label->setGeometry(50,50, 150, 20);
	playlist_le = new QLineEdit(pdir);
	playlist_le->setGeometry(50,80,230, 20);
	KIconLoader *loader2 = new KIconLoader();
	QPixmap fileopen2;
	fileopen2.load(loader2->iconPath(QString("fileopen"),-32));
	QPushButton *playlist_dirButton = new QPushButton(QIconSet( fileopen ),"",pdir);
	playlist_dirButton->setGeometry(50,130,40,25);
	connect(playlist_dirButton , SIGNAL( clicked() ),this, SLOT(set_playlist_dir()));	

	// reload last entries on start
	reload_last = new QRadioButton(i18n("Reload last Entries on Start"),son);
	reload_last->setGeometry(50,10,280,20);


	// mark double entrees Red
	red_entry = new QRadioButton(i18n("Mark double Songs Red"),son);
	red_entry->setGeometry(50,60,280,20);

	// mark bad quality entrees darkMargenta
	QGroupBox *g_limits = new QGroupBox(son);
	g_limits->setGeometry(40,100,270,90);

	// limits 
	limit_b = new QPushButton(i18n("Quality Limit"),son);
	limit_b->setGeometry(50,150,200,20);

	magenta_entry = new QRadioButton(i18n("mark bad Quality Songs Magenta"),son);
	magenta_entry->setGeometry(50,110,250,20);
	connect(magenta_entry,SIGNAL(toggled(bool)),limit_b,SLOT(setEnabled(bool)));	

	QPopupMenu *menu = new QPopupMenu(limit_b);
	menu->insertItem(" 192 kbps", 192);
	menu->insertItem(" 160 kbps", 160);
	menu->insertItem(" 128 kbps", 128);
	menu->insertItem(" 112 kbps", 112);
	menu->insertItem(" 96 kbps", 96);
	menu->insertItem(" 64 kbps", 64);
	menu->insertItem(" 56 kbps", 56);
	limit_b->setPopup(menu);
	connect(menu,SIGNAL(activated(int)),this,SLOT(limit(int)));

	// Normalize Volume
	QString n_txt(i18n(" Adjust the Volume of audio files\n to a standard level."));
	vol = new QRadioButton(i18n(n_txt),son);
	vol->setGeometry(50,210,280,40);
	connect(vol,SIGNAL(toggled(bool)),this,SLOT(unset_fly(bool)));
	
	// Burn on the fly
	QString fly_txt(i18n(" Burn CD's on the fly."));
	fly = new QRadioButton(i18n(fly_txt),son);
	fly->setGeometry(50,260,280,40);
	connect(fly,SIGNAL(toggled(bool)),this,SLOT(unset_normalize(bool)));

	// Global
	setGeometry(50,50,550,450);
}
ConfigDialog::~ConfigDialog(){}

void ConfigDialog::open_file()
{
	if (mp3_dir.isEmpty() || (!QDir(mp3_dir).exists()))
		le_b->setText(KFileDialog::getExistingDirectory(QDir::homeDirPath()));
	else 
		le_b->setText(KFileDialog::getExistingDirectory(mp3_dir));
}
void ConfigDialog::set_playlist_dir()
{
	if (playlist_dir.isEmpty() || (!QDir(playlist_dir).exists()))
		playlist_le->setText(KFileDialog::getExistingDirectory(QDir::homeDirPath()));
	else
		playlist_le->setText(KFileDialog::getExistingDirectory(playlist_dir));
}

void ConfigDialog::ok()
{
	scsi = la->text();
	mp3_dir = le_b->text();
	playlist_dir = playlist_le->text();
	speeed =  sb_c->value();

	// Dummy Mode
	dummyMode = radBut->isChecked();

	// reload last entries on start
	reload_last_entries = reload_last->isChecked();

	// mark double entrees Red 
	mark_double_songs_red = red_entry->isChecked();

	// mark bad quality entrees darkMagenta
	mark_bad_quality_entrees = magenta_entry->isChecked();

	// Normalize Volume
	if (!KStandardDirs::findExe("normalize")  &&  vol->isChecked() ) {
		QMessageBox::critical( this,"",i18n("Unable to find normalize"));
		volume_n = false;
		vol->setChecked(false);
	}
	else volume_n = vol->isChecked();

	// Burn on the fly 
	burn_fly = fly->isChecked();

	if (fly->isChecked() && vol->isChecked()) {
		vol->setChecked(false);
		volume_f = false;
	}

	emit ok_pressed(QString("config"));
}

void ConfigDialog::setValues()
{
	la->clear();
	la->insert(scsi);
	le_b->clear();
	le_b->insert(mp3_dir);
	playlist_le->clear();
	playlist_le->insert(playlist_dir);

	sb_c->setValue(speeed);
	radBut->setChecked(dummyMode);
	bG->setButton(project_name);
	limit(limitt);

	// Normalize Volume
	vol->setChecked(volume_n);

	// Burn on the fly 
	fly->setChecked(burn_fly);  

	// reload last entries on start
	reload_last->setChecked(reload_last_entries);

	// mark double Songs Red
	red_entry->setChecked(mark_double_songs_red);

	// mark bad quality entrees darkMagenta
	magenta_entry->setChecked(mark_bad_quality_entrees);
	if (magenta_entry->isChecked()) limit_b->setEnabled(true);
	else limit_b->setEnabled(false);

	this->show();
}
void ConfigDialog::bGroup() {project_name = QString(sender()->name()).toInt();}

void ConfigDialog::limit(int l)
{
	limitt = l;
	limit_b->setText(QString("Quality Limit = ") + QString::number(limitt) + " kbps");
}
void ConfigDialog::setVolume(int v)
{
if (v > 0 && v < 100)
	volume = v;
else
	volume = 50;
}


//normalize volume and burn on the fly can't used togehter!
void ConfigDialog::unset_normalize(bool x)
{
	if(!x) return; // button false
	if (vol->isChecked())
		vol->setChecked(false);
}
void ConfigDialog::unset_fly(bool x)
{
	if(!x) return; // button false
	if (fly->isChecked())
		fly->setChecked(false);
}

