#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H
#include <kdialogbase.h>

class QLineEdit;
class QSpinBox;
class QRadioButton;
class QButtonGroup;
class QColor;

class ConfigDialog : public KDialogBase
{
Q_OBJECT
public:
	ConfigDialog(QWidget * parent, const QString & caption);
	~ConfigDialog();

	QString mp3_dir, playlist_dir;
	QString scsi;
	QString paths1;

	int cpu_mhz, cpu_cache, ram_size;
	
	int speeed;
	int volume;
	int limitt;
	int project_name;  //    as Timestamp                             =  0
                         //    as First tracks name                     =  1
                         //    Don't save burned projects automaticly   =  2

	bool success_burn_p;
	bool volume_n;
	bool volume_f;
	bool dummyMode;
	bool burn_fly;
	bool mark_double_songs_red;
	bool mark_bad_quality_entrees;
	bool reload_last_entries;

public slots:
	void setValues();
	void setVolume(int v);
	
private slots:
	void open_file();
	void set_playlist_dir();
	void ok();
	void bGroup();
	void limit(int l);
	void unset_normalize(bool x);
	void unset_fly(bool x);

signals:
	void ok_pressed(QString );

private:
	QLineEdit *le_b, *playlist_le, *la;
	QSpinBox *sb_c;
	QRadioButton *radBut, *vol, *fly, *red_entry, *magenta_entry, *reload_last;
	QButtonGroup *bG;
	QPushButton *limit_b;
};

#endif
