
	// 44100 / 48000 =   0.91875
	// 2s = 2*2*2*44100 = 352800 bytes = gap
	// 1 sector = 1/75 s = 2352 bytes


#include <unistd.h> // usleep
#include <stdlib.h>  // calloc

#include <qfileinfo.h>  
#include <qstring.h> 

#include <kdebug.h>
#include <kstandarddirs.h>
#include <kapplication.h>

#include "decoding.h"
#include "kmp3burn.h"
#include "myprocess.h"
#include "akodestuff.h"

Decoding::Decoding() : resampler(NULL),

	fra_decoder(NULL),
	gelesen_total(0) 

{
	calc_fi_si_o_gap = 0;
	gelesen_pro_song = 0;
}


Decoding::~Decoding(){}

int Decoding::open_music_f(struct song_info *s, int fd, bool create_gap )
{

	this->create_gap = create_gap;
	playtime_ms = s->zeit_ms;
	samplerate = s->samplerate;
	m_channels = s->channels;

	as = new AkodeStuff(s);

	calc_fi_si_o_gap = ((int) (playtime_ms/13.333)) * 2352 ;  // Calk file size without gap

	// Die Dateigrösse muss gerade ist, sonst haben wir ein
	// Problem mit dem nächsten Song: Falsche sampleinterpretation, und somit nur noch rauschen.
	// deshalb, wenn ungerade dann +=1.
	if(calc_fi_si_o_gap%2) {
		kdDebug() << "akodeplugin: add agliment Byte in filesize" << endl;
		calc_fi_si_o_gap++;
	}
	samplefactor = ((float) 44100/ (float) samplerate);    // Samplefactor


	if (samplerate != 44100)  // Test if resampling is nessesary 
		{
		resampler = new MyProcess;	
		kdDebug() << "akodeplugin: Start Sox resampler...  Samplerate: " << s->samplerate << "  Resample ratio: " << samplefactor << endl;

		*resampler << "sox" << "-x" << "-t" << "raw"  << "-s" << "-w" << "-c" << "2" << "-r" << QString::number(samplerate) << "-" << "-t" << "raw"  << "-x" << "-s" << "-w" << "-c" << "2" << "-r" << "44100" << "-";

		resampler->setRawStdout(true);
		resampler->setRawStdin(true);
		resampler->writeToFd( fd );
		bool sx = resampler->start(MyProcess::NotifyOnExit,MyProcess::All );
		if(!sx)  kdDebug() << "cant start sox resampler!" << endl;

		instream_for_decoder = resampler->stdinFd();

	}

	else instream_for_decoder = fd;
	return 0;
}

int Decoding::decode()
{
	unsigned int z;
	char *buf = as->decode_frame(&z);
	while( buf ) {
		write(instream_for_decoder, buf, z);
		free(buf);
		gelesen_pro_song += z;
		kapp->processEvents();
		buf = as->decode_frame(&z);

		// wenn die Playtime widererwartend zu kurz berechnet ist,
		// muss akode stoppen, damit die nachfolgenden tracks
		// am richtigen sector starten.
		// Es darf eine sekunde (176400 bytes) in die Gap hineingeschrieben werden,
		// danach wird abgebrochen (Variable deadline).

		int gelesen_song = (int) ((float) gelesen_pro_song * samplefactor);
		int deadline = calc_fi_si_o_gap + 176400;

		if(gelesen_song > deadline) {
			kdDebug() << "akodeplugin: Deadline reached! Stop decode now!" << endl;
			break;
			// TODO: delete AkodeStuff after decoding
		}
	}

	int gelesen_pro_song_samp_fak = (int) ((float) gelesen_pro_song * samplefactor);
	if(gelesen_pro_song_samp_fak%2) {
		kdDebug() << "akodeplugin: add agliment Byte in write stream" << endl;
		gelesen_pro_song_samp_fak++;
	}

	int rest_bytes = calc_fi_si_o_gap - gelesen_pro_song_samp_fak;
	QString n = QString::number(playtime_ms);
	int l = n.length();
	if ( l > 2 ) n.insert(l-3,'.');

	kdDebug() << "akodeplugin: Playtime:    " <<  n  << " s  Channels: " << m_channels << " Restbytes:  " << rest_bytes << " bytes" << endl;

	if(rest_bytes > 0) {   // Write Restbytes if there any
		char *b = (char * ) calloc(rest_bytes,1); 
		if (!b) {
			kdDebug() << "Calloc Error" << endl;
			return -1;
		}
		write(instream_for_decoder,b,rest_bytes);
		gelesen_pro_song += rest_bytes;
	}

	// write exact gap, if nessesary
	if( create_gap ) {
		igap = 2*2*2*44100;  // 2 bytes, Stereo, 2 s
		int alles = calc_fi_si_o_gap + igap;
		int exact_gap = alles - (int) ( (float) gelesen_pro_song * samplefactor ) ;

		/** exact_gap entspricht jetzt ziemlich genau 352800 bytes.
		Eventuell sind wir aber mit dem resampler verbunden, und würden diesen Wert dann z. B. verdoppeln.
		Also muss die Lücke durch die Samplerate wieder geteilt werden */
		exact_gap = (int) (((float) exact_gap/samplefactor));

		gelesen_total += (int) (gelesen_pro_song * samplefactor) + exact_gap;
		gelesen_pro_song += exact_gap;

		if (exact_gap > 0) {
			char *b = (char * )calloc(exact_gap,1); 
			if (!b) {
				kdDebug() << "Calloc Error" << endl;
				return -1;
			}
			write(instream_for_decoder,b,exact_gap);

			if (!gelesen_total%2352)
				kdDebug() << "akodeplugin: no sector agliment: " << endl;

			kdDebug() << "akodeplugin: wrote gap: " << exact_gap << " bytes     Sectors: "  << exact_gap/2352  << " Track_end: " << gelesen_total/2352 <<  "\n\n";  
		}
	}

	usleep(100000);
	if(resampler) { // Stop resampler if running
		resampler->closeStdout();   // flush rest bytes
		resampler->closeStdin();
		resampler = NULL;
	}

	gelesen_pro_song = 0;


	// FIXME
	// on very short tracks (playtime < 1 s),
	// we get trouble with not exact filesize

	return -1;
}


void Decoding::error_handler()
{
	// this should not happen!
	// if we create __no__  gap, we make an Image
	// and its not nessesary, to to anything, so
	// return, to cut the track to zero.
	// else, we are burn on the fly and must produce an (emyty) PCM-Stream 

	if (!create_gap) {
		gelesen_pro_song = 0;
		return;
	}
	else {
		kapp->processEvents();     // draw window new
		int pcmstream = calc_fi_si_o_gap + 2*2*2*44100;  // 2 bytes, Stereo, 2 s 
		int written = (int) ((float) gelesen_pro_song * samplefactor);
		int w = pcmstream - written;
		char *b = (char * )calloc(w,1); 
		kdDebug() << "akodeplugin: error_handler: write NULL stream : " << w << endl << endl;
		if (!b) {
			kdDebug() << "calloc error" << endl;
			return;
		}
		write(instream_for_decoder,b,w);
		gelesen_pro_song = 0;
		return;
	}
}

void Decoding::close_stream()
{
	close( instream_for_decoder);
	return;
}

void Decoding::write_null()
{
	char *b = (char * ) calloc(100000,1); 
	if (!b) {
		kdDebug() << "Calloc Error" << endl;
		return;
	}
	write(instream_for_decoder,b,100000);
	free(b);
}
