#ifndef DECODING_H
#define DECODING_H

#include <akode/framedecoder.h>

using namespace aKode;

class MyProcess;
class Kmp3burn;
class AkodeStuff;

class Decoding
	{
	public:
	Decoding();
	~Decoding();

	// Args:
	// struct song_info defined in kmp3burn.h,
	// fd = an open descriptor, the stream is written, create_gap = if true, it will create a gap 
	// 150 sectors ( 2 sec ) pregap.
	int open_music_f(struct song_info *s, int fd, bool create_pregap);

	// do the decodeing
	int decode();

	// call after the last track is written
	void close_stream();
	void write_null();


	int instream_for_decoder;

	private:
	void error_handler();
	MyProcess *resampler;
	FrameDecoder *fra_decoder;
	AkodeStuff *as;

	int gelesen_pro_song;
	long gelesen_total;
	int igap;
	int calc_fi_si_o_gap;
	int samplerate;
	long playtime_ms;
	int m_channels;

	float samplefactor;
	bool create_gap;
	};

#endif
