//
// C++ Interface: diroperator
//
// Author: Martin Keil <martin-keil@gmx.net>, (C) 2006
// Copyright: See COPYING file that comes with this distribution
//

#ifndef _DIROPERATOR_H_
#define _DIROPERATOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <kurl.h>
#include <kfileitem.h>

class KURL;
class KURLComboBox;
class KDirOperator;
class QString;
class KHistoryCombo;
class QToolButton;
class QVBox;
class QFileInfo;
class QTimer;
class QDockArea;
class KToolBar;

class DirOperator : public QWidget
{
    Q_OBJECT
public:
	DirOperator(QWidget *parent = 0, const char *name = 0);
	~DirOperator();
	QFileInfo *akt_sng;

public slots:
	void slotFilterChange( const QString & nf );
	void setDir( KURL u );
	void cmbPathActivated( const KURL& u );
	void cmbPathReturnPressed( const QString& u );
	void dirUrlEntered( const KURL& u );
	void btnFilterClick();
	void selectionChange(const KFileItem *);
	void clearSelection();
	const KFileItemList *getSelectedItems();
	void setURL(const QString url);
	void dirFinishedLoading();
	void selectNext();
	void selectPrev();
	void enable();
	void disable();


signals:
	void selectionChange();
	void doubleKlick();

private:
	KURLComboBox *cmbPath;
	KDirOperator *dir;
	KHistoryCombo *filter;
	QString lastFilter;
	QToolButton *btnFilter;
	KFileItem *last_kfi;
	QTimer *timer;

	QDockArea *da;
	KToolBar *tb;

};

#endif // _DIROPERATOR_H_
