/***************************************************************************
                          kmp3burn.cpp  -  description
                             -------------------
    begin                : Sam M� 27 13:38:45 MET 2004
    copyright            : (C) 2004 by Martin Keil
    email                : martin-keil@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <config.h>
#include <time.h>

#include <qpushbutton.h>
#include <qdir.h>
#include <qstring.h>
#include <qgroupbox.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qdropsite.h>
#include <qstatusbar.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qlcdnumber.h>
#include <qcursor.h>
#include <qstringlist.h> 
#include <qregexp.h> 
#include <qlayout.h>

#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>
#include <kaboutdata.h>
#include <kaboutdialog.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kapplication.h>
#include <kconfigdialog.h>
#include <kfiledialog.h>
#include <kdebug.h>
#include <kmessagebox.h>

#include "kmp3burn.h"
#include "configdialog.h"
#include "tools.h"
#include "mylistbox.h"
#include "mlb.h"
#include "sysmonitor.h"
#include "song.h"
#include "myslider.h"
#include "myplayer.h"
#include "burner.h"
#include "burn.h"
#include "diroperator.h"

Kmp3burn::Kmp3burn(): KMainWindow(),

	si(NULL),
	cnt_inf_files(0),
	kernel_major(0),
	kernel_minor(0),
	kernel_patch(0),
	marked_item(NULL),
	index(0),
	totaltime_ms(0),
	blinking(0),
	clear_old_session(false)
{
	rechts.setAutoDelete( TRUE );

	sys_mon = new SysMonitor(); 
	con     = new ConfigDialog(this,QString(i18n("config")));
	connect(con,SIGNAL(ok_pressed(QString)),SLOT(status(QString)));

	createBasicGUI();
	work_dir = ::locateLocal("data","kmp3burn/",true);
	write_kernel_version(); // detect in createBasicGUI()
	dedect_pc_power();
	putout_free_space();
	make_dirs();
	read_config(); // from Dialog
	mp->setVolume(con->volume);
	connect(mp,SIGNAL(volume_changed(int)),con,SLOT(setVolume(int)));

	search_executes();
	search_codecs();
	dedectDevice();
	reload_last_entries();
	status(QString("Konstructor"));
}

Kmp3burn::~Kmp3burn() {end();}

void Kmp3burn::createBasicGUI()
{
	setGeometry(50,80,790,555); 
	setPlainCaption(QString(kapp->name()) + " " + VERSION );

	KIconLoader *l = new KIconLoader();
	const QPixmap pm_open(l->iconPath(QString("fileopen"),-16));
	const QPixmap pm_exit(l->iconPath(QString("exit"),-16));
	const QPixmap pm_conf(l->iconPath(QString("configure"),-16));

	file = new KPopupMenu();
	file->insertItem(QIconSet(pm_open),i18n("&Open..."),0 );
	file->insertItem(i18n("O&pen Playlist..."),1 );
	file->insertItem(i18n("Save &Playlist..."),2 ); file->insertSeparator();
	file->insertItem(QIconSet(pm_exit),i18n("&Exit"),this,SLOT(end()),CTRL+Key_Q );
	file->connectItem(2,this,SLOT(save_project_as()));
	connect(file,SIGNAL(activated(int)),SLOT(handler(int)));

	config_menu = new KPopupMenu();
	config_menu->insertItem(QIconSet(pm_conf),i18n("&Config Kmp3burn..."),0);
	connect(config_menu,SIGNAL(activated(int)),con,SLOT(setValues()));

	if (Tools::getVersion(&kernel_major,&kernel_minor,&kernel_patch))
		kdDebug() << "Kernel: " << kernel_major << "." << kernel_minor << "." << kernel_patch << endl;  

	KHelpMenu *kpm = new KHelpMenu( this,kapp->aboutData());
	menuBar()->insertItem(i18n("&File"), file);
	menuBar()->insertItem(i18n("&Settings"),config_menu); menuBar()->insertSeparator();
	menuBar()->insertItem(i18n("&Help"),kpm->menu());

	QPixmap  *pm_left  = new QPixmap;
	QPixmap  *pm_up    = new QPixmap;
	QPixmap  *pm_down  = new QPixmap;
	QPixmap  *wav      = new QPixmap;

	KIconLoader     *loader = new KIconLoader();
	pm_left         ->load(loader->iconPath(QString("back"),-32));
	pm_up           ->load(loader->iconPath(QString("up"),-32));
	pm_down         ->load(loader->iconPath(QString("down"),-32));
	wav             ->load(loader->iconPath(QString("forward"),-32));

	view = new QWidget(this);
	setCentralWidget(view);
	QGroupBox *g_boxr = new QGroupBox(1,Qt::Horizontal,(i18n("Burnbox")),view);
	boxr = new MyListBox(g_boxr, "boxr");

	connect(boxr,SIGNAL(selected(QListBoxItem *)),SLOT(extractFile()));
	connect(boxr,SIGNAL(highlighted(int )),SLOT(status()));
	connect(boxr,SIGNAL(drop_file(QStringList)),
		SLOT(drop_file_handler_boxr(QStringList)));

	dop = new DirOperator(view);
	connect(dop,SIGNAL(selectionChange()),boxr,SLOT(clearSelection()));
	connect(boxr,SIGNAL(selectionChanged()),dop,SLOT(clearSelection()));
	connect(dop,SIGNAL(doubleKlick()),SLOT(extractFile()));

	QWidget *ctrl = new QWidget(view);	// CTRL Frame
	ctrl->setFixedSize(QSize(360,110));

	(mpb = new MyProgressBar(ctrl))->move(0,50);

	(lcd = new QLCDNumber(6,ctrl))->setGeometry(0,10, 100, 26);
	lcd->setSegmentStyle(QLCDNumber::Flat);
	lcd->display(QString("000:00"));

	(vorb_b = new QPushButton(i18n("Create"),ctrl))->setGeometry(140,0,80,40);
	connect(vorb_b,SIGNAL(clicked()),SLOT(create()));

	(brennen_b = new QPushButton(ctrl))->setGeometry(240,0,120,40);
	connect(brennen_b,SIGNAL(clicked()),SLOT(burn_button()));

	QWidget *arrowL = new QWidget(view); // Arrow Buttons
	arrowL->setFixedWidth(50);
	QBoxLayout *arrowLayout = new QVBoxLayout(arrowL,0,10);

	(moveup_b = new QPushButton(arrowL))->setPixmap(*pm_up);
	connect(moveup_b,SIGNAL(clicked()),SLOT(moveup()));

	(movedown_b = new QPushButton(arrowL))->setPixmap(*pm_down);
	connect(movedown_b,SIGNAL(clicked()),SLOT(movedown()));

	(remove_b = new QPushButton(arrowL))->setPixmap(*pm_left);
	connect(remove_b,SIGNAL(clicked()),SLOT(remove()));

	(add_b = new QPushButton(arrowL))->setPixmap(*wav);
	connect(add_b,SIGNAL(clicked()),SLOT(addItems()));

	mp = new MyPlayer(view); /** create Player */
	connect(dop,SIGNAL(selectionChange()),mp,SLOT(setPlayButton()));
	connect(mp,SIGNAL(play_button_clicked()),SLOT(extractFile()));
	connect(mp,SIGNAL(bring_rew_song()),SLOT(rew()));
	connect(mp,SIGNAL(bring_fwd_song()),SLOT(fwd()));
	connect(mp,SIGNAL(player_stop(QString)),SLOT(status(QString)));
	connect(dop,SIGNAL(selectionChange()),mp,SLOT(setPlayButton()));

	arrowLayout->addWidget(moveup_b);
	arrowLayout->addWidget(movedown_b);
	arrowLayout->addWidget(remove_b);
	arrowLayout->addWidget(add_b);

	QGridLayout *gridLayout = new QGridLayout(view,2,1,10,10);
	gridLayout->addWidget(dop,0,0);
	gridLayout->addWidget(arrowL,0,1);
	gridLayout->addWidget(g_boxr,0,2);
	gridLayout->addWidget(mp,1,0);
	gridLayout->addWidget(ctrl,1,2);

	statusBar()->message("Loading........... ",5000);
}

void Kmp3burn::handler(int entry)  {
	if(entry == 0) open_mp3_files(KFileDialog::getOpenFileName(con->mp3_dir,available_codecs));
	if(entry == 1) open_m3u_file(KFileDialog::getOpenFileName(con->playlist_dir,"*.m3u"));
}

void Kmp3burn::open_mp3_files(QString file) {dop->setURL(file);}

void Kmp3burn::status(QString src)
{
	if ( con->speeed < 1)
		statusBar()->message("Set the config datas in the config window! ",5000);

	if (boxr->count() < 1) file->setItemEnabled ( 2, false );
	else file->setItemEnabled ( 2, true );

	if (src == "create") {  // Create button
		if (!boxr->item(0)) return;
		boxr            ->setEnabled(false);
		vorb_b          ->setEnabled(false);
		moveup_b        ->setEnabled(false);
		movedown_b      ->setEnabled(false);
		remove_b        ->setEnabled(false);
		add_b           ->setEnabled(false);
		boxr            ->clearSelection();

		mp->unsetPlayButton();
		mp->unset_fwd_button(); 
		mp->unset_rew_button(); 

		file->setItemEnabled(0,false); 
		file->setItemEnabled(1,false); 
		QApplication::setOverrideCursor( QCursor(Qt::WaitCursor));
	}

	if (src == "ready_for_burn_image") {
		brennen_b     ->setEnabled(true);
		moveup_b      ->setEnabled(false);
		movedown_b    ->setEnabled(false);
		remove_b      ->setEnabled(false);
		add_b         ->setEnabled(false);
		vorb_b        ->setEnabled(false);
		QApplication::setOverrideCursor( QCursor(Qt::ArrowCursor));
	}

	if (src == "Konstructor") {

		statusBar()->message("Select mp3s from Harddisc ",5000);

		if (boxr->count() < 1) {
			moveup_b      ->setEnabled(false);
			movedown_b    ->setEnabled(false);
			remove_b      ->setEnabled(false);
			vorb_b->setEnabled(false);
			statusBar()->message("Push mp3's to Burn Box ",5000);
		}
		else {
			moveup_b      ->setEnabled(true);
			movedown_b    ->setEnabled(true);
			remove_b      ->setEnabled(true);
		}
	}

	if (src == "Load_files")
		if ( boxr->selectedItem() ) mp->setPlayButton();


	if (src == "play_music") {
		MyListBoxI *i = static_cast<MyListBoxI *>   (boxr->selectedItem());

		// boxr fwd rew
		if ( i ) {                    // boxr selected
			i->setBackground();        // mark item light blue
			mp->setPlayButton();
			marked_item = i;

			if (i->next()) mp->set_fwd_button();
			else  mp->unset_fwd_button();

			if(i->prev()) mp->set_rew_button();
			else mp->unset_rew_button();
		}

		// DirOperator fwd rew
		if (dop->getSelectedItems()) {
			mp->set_fwd_button();
			mp->set_rew_button();
		}
		else {
			mp->unset_fwd_button();
			mp->unset_rew_button();
		}
	}

	if (src == "player_stop") {
		if ( marked_item ) {
			marked_item->unsetBackground();
			boxr->triggerUpdate(true);
		}
	}

	if (src == "add") {
		if(boxr->count() > 0) {
			vorb_b        ->setEnabled(true);
			remove_b      ->setEnabled(true);
		}

		if(boxr->count() > 1) {
			moveup_b      ->setEnabled(true);
			movedown_b    ->setEnabled(true);
			boxr->clearSelection();
		}
	}
	if (src == "remove") {
		if(boxr->count() < 2) {
			moveup_b      ->setEnabled(false);
			movedown_b    ->setEnabled(false);
		}
		if(boxr->count() < 1) {
			remove_b      ->setEnabled(false);
			vorb_b        ->setEnabled(false);
		}
	}

	if (src == "burnEnd") {         // set all normal
		boxr            ->setEnabled(true);
		vorb_b          ->setEnabled(true);
		moveup_b        ->setEnabled(true);
		movedown_b      ->setEnabled(true);
		remove_b        ->setEnabled(true);
		add_b           ->setEnabled(true);
		mp->setPlayButton();
		file->setItemEnabled (0,true); 
		file->setItemEnabled (1,true); 

		config_menu->setItemEnabled(0,true);
		config_menu->setItemEnabled(1,true);
		statusBar()->clear();

		if(con->burn_fly && (0 < boxr->count())) {
			brennen_b->setEnabled(true);
			vorb_b->setEnabled(false);
		}
		else if(!con->burn_fly && (0 < boxr->count())) {
			brennen_b->setEnabled(false);
			vorb_b->setEnabled(true);
		}
	}

	if (src == "remove" || src == "add" || src == "config") {
		if (con->burn_fly) {
			brennen_b->setText(i18n("Burn on the Fly"));
			vorb_b->setEnabled(false);
			if (0 < boxr->count()) brennen_b->setEnabled(true);
			else brennen_b->setEnabled(false);
		}
		else {
			brennen_b->setText(i18n("Burn"));
			brennen_b->setEnabled(false);
			blinking = 0;
			if (0 < boxr->count()) vorb_b->setEnabled(true);
		}
	}

	if(src == "burning") {    // burn on the fly
		brennen_b->setEnabled(false);
		config_menu->setItemEnabled(0,false);		
		config_menu->setItemEnabled(1,false);

		boxr            ->setEnabled(false);
		vorb_b          ->setEnabled(false);
		moveup_b        ->setEnabled(false);
		movedown_b      ->setEnabled(false);
		remove_b        ->setEnabled(false);
		add_b           ->setEnabled(false);
		boxr            ->clearSelection();

		mp->unsetPlayButton();
		mp->unset_fwd_button(); 
		mp->unset_rew_button(); 
		file->setItemEnabled(0,false); 
		file->setItemEnabled(1,false); 
	}
}

void Kmp3burn::status() {status(QString(""));}

void Kmp3burn::save_dat() // save entres in boxr
{
	KConfig *conf = KGlobal::config();
	conf->deleteGroup("Boxr entrees");
	conf->setGroup("Boxr entrees");
	for (unsigned  int n = 0; boxr->count() > n; n++ )
	conf->writeEntry(QString::number(n),rechts.at(n)->f_path);
	conf->setGroup(QString());
	conf->sync();
}

void Kmp3burn::reload_last_entries()
{
	statusBar()->clear();
	if ( con->reload_last_entries  == false ) return;

	KConfig *conf = KGlobal::config();
	conf->setGroup("Boxr entrees");

	for (int n = 0 ;; n++ ) {
		QString f = conf->readEntry(QString::number(n));
	if (f.isNull()) break;
		else {
			QFileInfo *fi = new QFileInfo(f);
			insertSongBoxr( fi, false );
		}
	}
}

void Kmp3burn::read_config()
{
	KConfig *conf = KGlobal::config();
	conf->setGroup(QString("main config"));

	//scsi-device
	QString scsi = conf->readEntry("SCSI device");
	if ( scsi.length() < 2 || scsi.length() > 300 ) scsi = "/dev/cdrom";  // default
	con->scsi = scsi;

	//cdrecord_speed
	int s = conf->readNumEntry("cdrecord speed");
	if (s < 1 || s > 49 ) s = 8 ;                 // default = 8 
	con->speeed = s;

	// volume
	int v = conf->readNumEntry("volume");
	if (v < 1 || v > 100 ) v = 50;                //default = 50 % 
	con->volume = v;

	// quality limit                             // default = 96 kbps
	con->limitt = conf->readNumEntry("quality limit",96);  

	// default = timestamp
	//project name    0=timestamp; 1=first track; 2=don't save
	int p = conf->readNumEntry("project name");
	if (p > -1 || p < 3) con->project_name = p;
	else con->project_name = 0;

	//mp3 dir                      // default = $HOME
	QString m = conf->readPathEntry("mp3 dir",QDir::homeDirPath());
	QDir mp3d(m);
	if (mp3d.exists()) con->mp3_dir = m;
	else con->mp3_dir = QDir::homeDirPath();
	const QString f(con->mp3_dir);
	dop->setURL(f);

	// playlist dir                               // default = $HOME
	QString dir = conf->readPathEntry("playlist dir",QDir::homeDirPath());
	QDir d(dir);
	if(d.exists()) con->playlist_dir = dir;  
	else con->playlist_dir = QDir::homeDirPath();

	// cdrecord_exe
	conf->setGroup("Cdrcord Path");
	QString Paths1 = conf->readPathEntry("1");
	QFileInfo cdr(Paths1);
	if ((QString("cdrecord") == cdr.baseName()) && (cdr.isExecutable()))
		con->paths1 = Paths1;

	conf->setGroup("main config");

	// mark double Songs Red                  // default = true
	con->mark_double_songs_red = conf->readBoolEntry("mark double songs red", true);

	// reload last entries on start           // default = false
	con->reload_last_entries = conf->readBoolEntry("reload last entries", false );

	// mark bad quality entrees darkMagenta  // default = true
	con->mark_bad_quality_entrees = conf->readBoolEntry("mark bad quality entrees",true );

	// success burn process                  // default = false 
	con->success_burn_p = conf->readBoolEntry("success burn process",false);

	// normalize Volume                      // default = fales
	con->volume_n = conf->readBoolEntry("normalize volume",false);  

	// burn on the fly                      // default = true 
	con->burn_fly = conf->readBoolEntry("burn on the fly", true );

	//cdrecord dummyMode                    // default = false 
	con->dummyMode = conf->readBoolEntry("cdrecord dummy mode",false);
}

void Kmp3burn::save_config()
{
   KConfig *conf = KGlobal::config();
	conf->setGroup(QString("main config"));

	conf->writeEntry("SCSI device",con->scsi);           
	conf->writeEntry("mp3 dir",con->mp3_dir);
	conf->writeEntry("cdrecord speed",con->speeed);  
	conf->writeEntry("cdrecord dummy mode",con->dummyMode);         
	conf->writeEntry("project name",con->project_name);
	conf->writeEntry("playlist dir",con->playlist_dir);               
	conf->writeEntry("volume",con->volume);                 
	conf->writeEntry("success burn process",con->success_burn_p);     
	conf->writeEntry("normalize volume",con->volume_n);      
	conf->writeEntry("burn on the fly",con->burn_fly);
	conf->writeEntry("mark double songs red",con->mark_double_songs_red);
	conf->writeEntry("mark bad quality entrees",con->mark_bad_quality_entrees);
	conf->writeEntry("quality limit",con->limitt);
	conf->writeEntry("reload last entries",con->reload_last_entries);

	conf->sync();
}
void Kmp3burn::make_dirs()
{
	KStandardDirs *sD = new KStandardDirs();
	QDir *d = new QDir();

	if (!d->cd(work_dir)) {   // .kmp3burn nicht gefunden
		d->cd(sD->localkdedir() += sD->kde_default("data"));
		d->mkdir("kmp3burn");
		d->cd("kmp3burn");
		d->mkdir("wav");
		d->cdUp();
	}
	else {
		if ( !d->cd("wav")) d->mkdir("wav");
		else rmWavs();
		d->cdUp();
	}
}
void Kmp3burn::save_project_automatic()
{
	QString input;
	time_t t;
	time(&t);        
	char *tme = ctime(&t);
	tme[strlen(tme) -1 ] = '\0';

	switch( con->project_name ) {
		case 0:                            // Timestamp
			input = tme;                    // cut last char ?
			break;
		case 1:                            // First tracks name
			si = rechts.take(0);
			input = si->base_name;
			break;
		case 2:                            // Don't save
			status(QString("Save_files"));
			return;
	}
	QString filename(con->playlist_dir + "/" + input + ".m3u");
	save_m3u_file(filename);
	status(QString("Save_files"));
}
void Kmp3burn::save_project_as()
{
	QString filename;
	filename = KFileDialog::getSaveFileName(work_dir,"*.m3u");
	save_m3u_file(filename);
	status(QString("Save_files"));
}

void Kmp3burn::drop_file_handler_boxr(QStringList lst)
{
	statusBar()->clear();
	for ( QStringList::Iterator it = lst.begin(); it != lst.end(); ++it ) {
		QFileInfo *fi = new QFileInfo( QFileInfo(*it));
		insertSongBoxr(fi);
	}
	status(QString("Load_files"));
}

void Kmp3burn::search_executes()
{
	/** 
	find cdrecord + normalize + sox
	check cdrecord -version
	test cdrecord -scanbus (if Linuxkernel == 2.4.x)
	test if arts is running and its able to play mp3s
	test if cdrecord knows -overburn 
	test if cdrecord knows -gracetime */

	tools = new Tools();

	QString scanbus_failed(i18n("         cdrecord -scanbus... failed!\n\n \
	Start the burn process will be not successful!\n \
	Try to set the SUID Bit as Root for cdrecord.\n \
	Open Setupmanager in Settingsmenue\n \
	You also can start kmp3burn as user you have access to /dev/sg0.\n \
	Maybe as Root to test the burn process,\n \
	but for working are superuser privilegs not recommended!\n \
	See Kmp3burn Help for details."));

	if(KStandardDirs::findExe("cdrecord") || (!con->paths1.isEmpty())) 
		kdDebug() << "Found cdrecord" << endl;

	else {
		QMessageBox::information( this,kapp->name(),i18n("Unable to find cdrecord"));
		kdDebug() << "Unable to find cdrecord" << endl;
	}

	if (KStandardDirs::findExe("normalize")) 
		kdDebug() << "Found normalize" << endl; 
	else
		kdDebug() << "Unable to find normalize" << endl;


	if (KStandardDirs::findExe("sox")) 
		kdDebug() << "Found sox" << endl; 
	else
		kdDebug() << "Unable to find sox" << endl;

	cdr_version = tools->check_cdrecord_version();
	tools->check_sox_reampler();

	if (!tools->check_cdrecord_scanbus()) // if Linuxkernel == 2.4.x
	QMessageBox::information( this,kapp->name(),scanbus_failed);
	tools->check_cdrecord_features();
}

int Kmp3burn::insertSongBoxr(QFileInfo *fi, bool save)
{
	QString msg;

	if (!fi->exists()) {
		msg = QString("No valid File:  ") + fi->absFilePath();
		kdDebug() << msg << endl;
		statusBar()->message(msg,5000);
		return -1;
	}

	if(!((fi->extension()).contains(QRegExp(available_codecs_exp)))) {
		msg = QString("No valid File extension:  ") + fi->absFilePath();
		kdDebug() << msg << endl;
		statusBar()->message(msg,5000);
		return -1;
	}

	Song *sg = Song::createTag(fi->absFilePath());
	if(!sg) return -1;

	int tt = sg->getLength();
	if (tt < 1 ) {
		msg = QString("Playtime less then 1 second!: ") + fi->absFilePath();
		kdDebug() << msg << endl;
		statusBar()->message(msg,5000);
		return -1;
	}

	QString tmp;
	tmp.sprintf("%.2d:%.2d",tt/60,tt%60);

	// samplerate
	int sr = sg->getSamplerate();
	if ( sr != 44100 ) {
		if(!tools->have_sox_resampler ) {
			msg = QString("Resampling not supported: ") + fi->absFilePath();
			kdDebug() << msg << endl << endl; 
			statusBar()->message(msg,5000);
			return( -1 );
		}
		else if ( sr < 500 || sr > 80000 ) {
			msg = QString("Samplerate not supported:  ") + fi->absFilePath();
			kdDebug() << msg << endl;
			statusBar()->message(msg,5000);
			return( -1 );
		}
		else {
			msg = QString("Resample to 44100... ") + fi->absFilePath();
			kdDebug() << msg << endl << endl;
			statusBar()->message(msg,5000);
		}
	}

	si = new song_info();
	si->time_string   = tmp;
	si->zeit_titel    = tmp + QString("    ") + fi->fileName();
	si->f_path        = fi->absFilePath();
	si->base_name     = fi->baseName(true); 
	si->wav_file      = fi->baseName(true) + QString(".wav");
	si->time_wav_file = tmp + QString("    ") + fi->baseName(true) + QString(".wav");
	si->zeit_ms       = tt*1000;
	si->title         = sg->getTitle();
	si->artist        = sg->getArtist();
	si->bitrate       = sg->getBitrate();
	si->samplerate    = sg->getSamplerate();
	si->channels      = sg->getChannels();
	si->format        = sg->getFormat();

	int i = boxr->count();
	rechts.insert(i,si);
	QString it = (rechts.at(i))->zeit_titel;

	MyListBoxI *mlb = static_cast<MyListBoxI *>(boxr->findItem(it,Qt::CaseSensitive));
	MyListBoxI *mlb2 = new MyListBoxI(it,boxr);

	// bad quality
	int b_rate = (rechts.at(i))->bitrate;
	if (b_rate < con->limitt) {
		QString meldung("Bitrate = ");
		meldung += QString::number(b_rate) += " kbps\n The Quality of this track may be to Bad!";

		if (con->mark_bad_quality_entrees && b_rate < con->limitt) {
			mlb2->setBaseColor(QColor("darkMagenta"));
			mlb2->changeColor(QColor("darkMagenta"));
		}
		else {
			mlb2->setBaseColor(QColor("black"));
			mlb2->changeColor(QColor("black"));
		}

		KMessageBox::information(this,i18n(meldung),kapp->name(),QString("show"),4);
	}
	else mlb2->setBaseColor(QColor("black"));

	 // double entree 
	if(mlb) {   
		if (con->mark_double_songs_red) {        
			mlb->changeColor(QColor("red"));
			mlb2->changeColor(QColor("red"));
			boxr->insertItem(mlb2);      // new (last) item red
		}
		else {
		boxr->insertItem(mlb2);
		}
	}
	else boxr->insertItem(mlb2);       // new (last) item black

	totaltime_ms = totaltime_ms + ((rechts.at(i))->zeit_ms) + 2000; // 2 sec pregap

	char hilfs[20];
	sprintf(hilfs,"%.3d:%.2d",(int)(totaltime_ms/60000),(int)(totaltime_ms/1000)%60);
	lcd ->display(hilfs);

	mpb->setProgress(totaltime_ms/60000);
	status(QString("add"));
	if (save) save_dat();

	kapp->processEvents();  // draw window new
	i++;
	return 0;
}

int Kmp3burn::insertSongPlayer()
{
	QFileInfo *fi = NULL;
	fi = dop->akt_sng;
	if ( !fi ) return -1;  // Nothing selected

	if (!fi->exists()) {
		kdDebug() << "insertSong: no valid File:  "<< fi->absFilePath() << endl;
		return -1;
	}

	if(!((fi->extension()).contains(QRegExp(available_codecs_exp)))) {
		kdDebug() << "insertSong: no valid File extension:  " << fi->absFilePath() << endl;
		return -1;
	}

	Song *sg = Song::createTag(fi->absFilePath());
	if(!sg) return -1;

	int tt = sg->getLength();
	if (tt < 1 ) {
		kdDebug() << "Insert Song: Playtime less then 1 second!: "  << fi->absFilePath() << endl;
		return -1;
	}

	QString tmp;
	tmp.sprintf("%.2d:%.2d",tt/60,tt%60);

	// samplerate
	int sr = sg->getSamplerate();
	if ( sr != 44100 ) {
		if(!tools->have_sox_resampler ) {
			kdDebug() << "resampling to 44100 not supported, sox not found" << endl;
			kdDebug() << fi->absFilePath() << " Samplerate: " << sr << endl << endl; 
			return( -1 );
		}
		else if ( sr < 500 || sr > 80000 ) {
			kdDebug() << fi->absFilePath() << " Samplerate: " << sr << endl;
			kdDebug() << "Samplerate not supported" << endl;
			return( -1 );
		}
		else
			kdDebug() << fi->fileName() << " Samplerate: " << sr << " resample to 44100..."<<endl<<endl;
	}

	si = new song_info();
	si->time_string   = tmp;
	si->zeit_titel    = tmp + QString("    ") + fi->fileName();
	si->f_path        = fi->absFilePath();
	si->base_name     = fi->baseName(true); 
	si->wav_file      = fi->baseName(true) + QString(".wav");
	si->time_wav_file = tmp + QString("    ") + fi->baseName(true) + QString(".wav");
	si->zeit_ms       = tt*1000;
	si->title         = sg->getTitle();
	si->artist        = sg->getArtist();
	si->bitrate       = sg->getBitrate();
	si->samplerate    = sg->getSamplerate();
	si->channels      = sg->getChannels();
	si->format        = sg->getFormat();

	kapp->processEvents();  // draw window new
	mp->play_music(*si);
	return 0;
}

void Kmp3burn::blinking_button()
{
	QTimer *tim   = new QTimer();
	tim->start( 100, true );
	blinking++;

	KIconLoader *lder = new KIconLoader();
	QPixmap *pm_tst = new QPixmap;
	pm_tst->load(lder->iconPath(QString("star.png"),-64));

	if(blinking%2) brennen_b->setPixmap(*pm_tst);
	else brennen_b ->setText("Burn");

	if(blinking < 20) connect(tim,SIGNAL(timeout()),SLOT(blinking_button()));
	brennen_b->setEnabled(true);
}

// Wird  von spielen button aufgerufen
void Kmp3burn::extractFile()
{
	if (boxr->selectedItem()) {
		QListBoxItem *i = boxr->selectedItem();
		si = rechts.at(boxr->index(i));
		mp->play_music(*si);
	}
	else
		if(insertSongPlayer() == -1 ) return;

	status(QString("player_stop"));  // hack to clear blue listboxentry!
	status(QString("play_music"));
}

void Kmp3burn::burn_button()
{
	save_dat();
	save_project_automatic();
	if (con->burn_fly && !calc_power_fly()) return;

	if ( false == checkImageSize()) return;
	if ( false == test_media()) return;
	if ( false == test_dummy_mode()) return ;

	dop->disable();
	setListBoxGrey();
	status("burning");

	if (con->burn_fly) burn_on_the_fly();  // Burn on the fly
	else {                                 // Burn an existing Image
		Burn *b = new Burn(); 
		b->burnImage(this);
		connect(b,SIGNAL(song_finish(int)),SLOT(update_boxr(int)));
	}
}

void Kmp3burn::burn_on_the_fly() 
{
	if (!checkPropertiesExact()) return;
	create_inf_files();

	if (0 == rechts.count()) return;
	QString txt(i18n("Burn image on the fly is not supported by this version of cdrecord"));
	if (!tools->useinfo) {
		QMessageBox::information(this,kapp->name(),txt);
		kdDebug() << txt << endl; 
		return;
	}

	statusBar()->message("Prepare Burning... ",5000);
	index = 1;
	Burn *b = new Burn();
	connect(b,SIGNAL(song_finish(int)),SLOT(update_boxr(int)));
	b->start(this);
	return;
}

bool Kmp3burn::test_media() /** if there is no k3blib, don' t show Message Box */
{
	if (bu->haveK3b) {
		if (!bu->isBurnerReady()) {
			QMessageBox::information( this,kapp->name(),i18n("Insert Media and close Device"));
			return false;
		}
		return true;
	}
	return true;
}

bool Kmp3burn::test_dummy_mode()
{
	if (con->dummyMode) {
		int n = QMessageBox::question( this,kapp->name(),
		i18n("Dummy Mode: The recording process will just simulate"),
		i18n("Ok"),i18n("Cancel"));
		if (n == 1) return false;
	}
	return true;
}
