/***************************************************************************
                          kmp3burn.h  -  description
                             -------------------
    begin                : Sam M� 27 13:38:45 MET 2004
    copyright            : (C) 2004 by Martin Keil
    email                : martin-keil@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMP3BURNER_H
#define KMP3BURNER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <kmainwindow.h>

class QSlider;
class QRadioButton;
class QFileInfo;
class QPushButton;
class QLCDNumber;
class QListBoxItem;

class KSimpleConfig;
class KProcess;
class QWidget;

class ConfigDialog;
class Tools;
class MyListBox;
class SysMonitor;
class Client;
class MyPlayer;
class MyProgressBar;
class Burner;
class BurnFly;
class Tools;
class DirOperator;
class MyListBoxI;

	/** GLOBAL */
	struct song_info {
		QString time_string;
		QString time_wav_file;      // 03:21 test.wav
		QString f_path;             // /mp3/august/irgengwas.mp3
		QString zeit_titel;         // 04:32 test.mp3
		QString base_name;          // test
		QString wav_file;           // test.wav
		QString w_f_p;              // home/../test.wav
		QString title;
		QString artist;
		QString format;             // mp3,ogg,flac
		long zeit_ms;               // 70447 = 1 min, 10 sec, 447 ms   
		int bitrate;                // 193
		int samplerate;             // 44100
		int channels;               // 1=mono  2=stereo 
	};

class Kmp3burn : public KMainWindow
{
	Q_OBJECT
public:
	Kmp3burn();
	~Kmp3burn();
	QPtrList<song_info>  rechts ;
	song_info *si;
	ConfigDialog  *con;
	SysMonitor *sys_mon;
	Tools *tools;
	QString  work_dir;
	unsigned int cnt_inf_files;  // create_inf_files

public slots:
	int boxr_cnt();
	void save_config();
	void update_boxr(int entry);
	void burnEnd(KProcess *);

private slots:
	void createBasicGUI();
	void handler(int);
	void read_config();
	void addItems();
	int remove ();
	void moveup ();
	void movedown ();
	void create ();
	void to_wav(struct song_info *s, QString wavfile);
	void check_result(int );
	void to_normalize(QString wavfile);
	void normalize_finish(KProcess *p);
	void burn_on_the_fly();
	void save_dat();
	void reload_last_entries();
	void status(QString src);
	void status();
	void end();
	void make_dirs();
	void save_project_automatic();
	void save_project_as();
	void drop_file_handler_boxr(QStringList);

	void search_executes();
	int insertSongBoxr( QFileInfo *fi, bool save = true );
	int insertSongPlayer();
	void blinking_button();
	void extractFile();
	void rmWavs();
	void fwd();
	void rew();
	void setListBoxGrey();
	void setListBoxBlack();
	void dedectDevice();
	void print_db(KProcess *,char * ,int);
	void ready_for_burn_image();
	bool testFreeDiscSpace(); 
	int save_m3u_file(QString filename);
	void search_codecs();
	void putout_free_space();
	void write_kernel_version();
	void create_inf_files();
	void open_mp3_files(QString mp3_file);
	void open_m3u_file(QString m3u_file);
	bool test_media();
	bool test_dummy_mode();
	void burn_button();
	void clearOldSession();
	bool checkPropertiesExact();
	bool checkImageSize();
	void dedect_pc_power();
	bool calc_power_fly();   

private:
	MyListBox          *boxl;
	QListBox           *boxr;
	QPushButton        *movedown_b, *moveup_b, *remove_b, *vorb_b, *add_b, *brennen_b;
	QRadioButton       *button;
	KPopupMenu         *file;
	QString            statusBarFile, available_codecs, available_codecs_exp;
	QLCDNumber         *lcd;
	KPopupMenu         *config_menu;
	MyPlayer *mp; 
	MyProgressBar *mpb;
	Burner *bu;
	DirOperator *dop;
	QWidget *view;

	int cdr_version;
	int kernel_major,kernel_minor,kernel_patch;
	MyListBoxI *marked_item;

	unsigned int index; // fr to_wav
	long totaltime_ms;
	int blinking;    // Blinking button
	bool clear_old_session;
	bool image_ok;
	bool loop;
};

#endif
