
#include <qlcdnumber.h>
#include <qmessagebox.h>
#include <qpushbutton.h> 
#include <qdir.h>
#include <qtimer.h> 
#include <qprogressdialog.h>

#include <kstatusbar.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <kaudioplayer.h>
#include <kprocess.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <kfileitem.h>

#include "kmp3burn.h"
#include "mylistbox.h"
#include "configdialog.h"
#include "mlb.h"
#include "sysmonitor.h"
#include "burner.h"
#include "tools.h"
#include "myplayer.h"
#include "myslider.h"
#include "makewav.h"
#include "madlib.h"
#include "akodestuff.h"
#include "diroperator.h"

void Kmp3burn::addItems(void)
{
	statusBar()->clear();
	if(!dop->getSelectedItems()) return;
	const KFileItemList *lst = dop->getSelectedItems();
	for ( KFileItemList::Iterator it = lst->begin(); it != lst->end(); ++it )
		insertSongBoxr(new QFileInfo(((static_cast<KFileItem *>(*it))->url()).pathOrURL()));

	status(QString("Load_files"));

}

int Kmp3burn::remove() {
	int i = boxr->currentItem();
	int ende = boxr->count();
	if (ende < 1) {return(2);}      // boxr leer
	if (i == (-1)) {return(2);}     // boxr nichts selectiert

	QString it = boxr->text(i);
	boxr->removeItem(i);

	int j = 0;
	int equal = 0;
	while (ende >= j ){
		if (it == boxr->text(j)) {
			equal++;
		}
		j++;
	}

	if (equal == 1 ) {
		MyListBoxI *mlb = static_cast<MyListBoxI *> (boxr->findItem(it));
		int ind = boxr->index(mlb);  // index merken
		QString t = mlb->text();
		QColor c = mlb->getBaseColor();
		boxr->removeItem(ind);

		MyListBoxI *ttt = new MyListBoxI(t,boxr);
		ttt->setBaseColor(c);
		ttt->changeColor(c);
		boxr->insertItem(ttt, ind);
	}
	totaltime_ms = totaltime_ms - ((rechts.at(i))->zeit_ms) - 2000; // 2 sec pregap

	rechts.remove(i);// Liste bis oben ordnen

	if ( (int) (boxr->count()) > i ) boxr->setSelected( i, true );
	else boxr->setSelected( i - 1 ,true );

	while (ende > i) {i++;}

	char hilfs[20];
	sprintf(hilfs,"%.3d:%.2d",(int)(totaltime_ms/60000),(int)(totaltime_ms/1000)%60);
	lcd->display(hilfs);
	mpb->setProgress(totaltime_ms/60000);
	status(QString("remove"));
	save_dat();
	return 0;
}

void Kmp3burn::moveup () {
	int n = boxr->currentItem();
	if (n <= 0) return;  
	QString t = boxr->text(n);
	MyListBoxI *mlb = static_cast<MyListBoxI *> (boxr->item(n));

	QColor c = mlb->getColor();
	QColor bc = mlb->getBaseColor();

	MyListBoxI *mlb2 = new MyListBoxI(t,boxr);
	mlb2->setBaseColor(bc);
	mlb2->changeColor(c);

	boxr->insertItem(mlb2,(n -1));
	boxr->setCurrentItem(n - 1 );
	boxr->removeItem(n + 1); 

	song_info *si;
	si = rechts.take(n);
	rechts.insert(n-1,si);

	status(QString("moveup"));
	save_dat();
}

void Kmp3burn::movedown ()
{
	int n = boxr->currentItem();
	if (n < 0) return;
	if ( n+1  == (int) boxr->count()) return;
	QString t = boxr->text(n);

	MyListBoxI *mlb = static_cast<MyListBoxI *>(boxr->item(n));
	QColor c = mlb->getColor();
	MyListBoxI *mlb2 = new MyListBoxI(t,boxr);
	mlb2->changeColor(c);

	boxr->insertItem(mlb2, (n + 2));
	boxr->setCurrentItem(n + 2);
	boxr->removeItem(n);

	song_info *si;
	si = rechts.take(n);
	rechts.insert(n+1,si);

	status(QString("movedown"));
	save_dat();
}

int Kmp3burn::boxr_cnt() {return(boxr->count());}

void Kmp3burn::burnEnd(KProcess *p)
{
	if(p)
		if(p->normalExit() && p->exitStatus() != 0 ) image_ok = false;
		else image_ok = true;
	clearOldSession();
}

void Kmp3burn::clearOldSession()
{
	if(!clear_old_session) {
		clear_old_session = true;
		QTimer *timer = new QTimer(this);
		connect( timer, SIGNAL(timeout()),this, SLOT(clearOldSession()));
		timer->start( 500 , TRUE ); // 5/10 seconds single-shot
	}
	else {
		blinking = 0;
		index = 0;
		setListBoxBlack();
		dop->enable();
		status(QString("burnEnd"));
		rmWavs();
		clear_old_session = false;
		if(image_ok) {
			con->success_burn_p = "yes";
			statusBar()->message("Cdrecord Exitstatus: Normal Exit",5000);
			kdDebug() << "Cdrecord Exitstatus: Normal Exit: 0" << endl;
			KAudioPlayer pl(::locate("data","kmp3burn/snd/success.wav"));
			pl.play();
		}
		else
			statusBar()->message("Burning goes Wrong",5000);
	}
}

void Kmp3burn::create()
{
	if (!checkPropertiesExact()) return;

	dop->disable();

	if (!KStandardDirs::findExe("sox")) {
		QString m = "Can't create image, sox not found.\nTry Burn Image on the Fly.";
		QMessageBox::information(this,kapp->name(),i18n(m));
		return;
	}
	
	index = 0;
	if (!testFreeDiscSpace()) return;
	setListBoxGrey();
	status("create");

	QDir d(work_dir);  // delete all inf files
	if(!d.exists()) return;
	for (unsigned int x = 0 ; x < d.count(); x++) 
		if( d[x].endsWith( ".inf" ))  d.remove(d[x]);

	QString wavFile = work_dir + "wav/" + QString::number(index) + ".wav";
	to_wav( static_cast<song_info *> (rechts.at(index)) ,wavFile);     // Prozess starten 1.Mal
}

void Kmp3burn::end()
{
	mp->play_music_stop();
	save_dat();
	save_config();
	rmWavs();
	kapp->quit();
}
void Kmp3burn::rmWavs()  // delete all files in wavdir
{
	QDir d(work_dir + "wav");
	if(!d.exists()) return;
	for ( unsigned int x = 0 ; x < d.count(); x++) d.remove(d[x]);
}

void Kmp3burn::rew()
{
	if (boxr->selectedItem()) {  // boxr
		int i = boxr->currentItem();
		boxr->setCurrentItem(i - 1);
		si = rechts.at(boxr->currentItem());
	}
	else {
		dop->selectPrev();        // boxl
		if(insertSongPlayer() == -1 ) return;
	}

	status(QString("player_stop")); 
	status(QString("play_music"));
	mp->play_music(*si);
}

void Kmp3burn::fwd()
{
	if (boxr->selectedItem()) {         // boxr
		int i = boxr->currentItem();
		boxr->setCurrentItem(i + 1);
		si = rechts.at(boxr->currentItem());
	}
	else {
		dop->selectNext();           // boxl
		if(insertSongPlayer() == -1 ) return;
	}

	status(QString("player_stop")); 
	status(QString("play_music"));
	mp->play_music(*si);
}

void Kmp3burn::setListBoxGrey()
{

	// Bugfix: Kmp3burn chrashed if the last track of burnbox
	// was stopped while a CD was burned
	marked_item = NULL;


	int n = 0;
	while ( n < (int) boxr->count() ) {
		MyListBoxI *lbi = new MyListBoxI((rechts.at(n))->zeit_titel,boxr);
		lbi->changeColor(QColor("gray"));
		boxr->insertItem(lbi,n);
		boxr->removeItem(n+1);
		n++;
	}
}

void Kmp3burn::setListBoxBlack()
{
	int n = 0;
	while ( n < (int) boxr->count() ) {
		MyListBoxI *lbi = new MyListBoxI((rechts.at(n))->zeit_titel,boxr);
		lbi->changeColor(QColor("black"));
		boxr->insertItem(lbi,n);
		boxr->removeItem(n+1);
		n++;
	}
}

void Kmp3burn::dedectDevice()
{
	bu = new Burner();
	/** if there is no k3blib, do nothing */
	if (!bu->haveK3b) return;

	/** Device is configured, do nothing */
	if (con->success_burn_p == true) return;

	 /** set autodedect Values */
	con->scsi = bu->BurnDevice;

	if ((bu->WriteSpeed < 2) || (bu->WriteSpeed > 80))
		bu->WriteSpeed = 8;

	return;
	 /**
	  * TODO
	  * There isn't a new scan in case of hardware changes
	  */
}

void Kmp3burn::to_wav(struct song_info *s, QString wavfile)
{
	statusBarFile = s->base_name;
	MakeWav *mw = new MakeWav();
	connect(mw,SIGNAL(finish(int )),this,SLOT(check_result(int )));
	index++;
	mw->do_it(s, wavfile);
}

void Kmp3burn::print_db(KProcess *p,char *c ,int n)
{
	n = 0; p = 0; /** avoid compiler warnung */
	QString cc; cc = c;
	QString status = " Convert file and adjust Volume Level to ";

	if (cc.contains("Applying")) {
		cc =  cc.left(30); cc = cc.right(8);
		status += cc + " : " + statusBarFile + "  ";
		statusBar()->message(status);
	}
	else if (cc.contains("already normalized")) {
		status += " 0.00dB : "  + statusBarFile + "  ";
		statusBar()->message(status);
	}
}
void Kmp3burn::ready_for_burn_image()
{
	status(QString("ready_for_burn_image"));
	statusBar()->message("Ready for Burn Image!  ");
	blinking_button();
}
void Kmp3burn::update_boxr(int boxr_entry) 
{
	if(boxr_entry == 0 || boxr_entry > ((int) boxr->count())) {
		kdDebug() << "warning: update_boxr item not found: " << boxr_entry << endl;
	 	return;
	}

	QString entry = (rechts.at(boxr_entry - 1 ))->zeit_titel;
	if ( entry.isNull() ) return;

	MyListBoxI *lbi = new MyListBoxI(entry,boxr);
	lbi->changeColor(QColor("blue"));
	boxr->insertItem(lbi,boxr_entry - 1 );
	boxr->setCurrentItem(boxr_entry - 1 );
	boxr->setSelected(boxr_entry - 1, false );
	boxr->removeItem(boxr_entry);

	//This should be moved in a seperat function
	QString b("Burning:  "); b += rechts.at(boxr_entry - 1)->f_path;
	if (con->burn_fly) statusBar()->message(b);
}
void Kmp3burn::open_m3u_file(QString file)

{
	statusBar()->clear();
	QFile m3u(file);
	if ( !m3u.open( IO_ReadOnly ) ) return;

	int tTime = 0;
	int tracks = 0;

	QTextStream stream( &m3u );
	while ( !stream.atEnd() ) {     // find playtime between 0-30 min
		QString line = stream.readLine();
		if ( 0 == line.find("#EXTINF:") ) {
			int i = (line = (line.remove(0,8)).section(',',0,0)).toInt();
			if ( i>0  &&  i<1800 ) {
				tTime+= i;
				tracks++;
			}
		}
	}

	// Limit == 240 min or 200 tracks
	QString w_msg(i18n("m3u list is to big"));
	if ( tTime > 14400 || tracks > 200 ) {
		KMessageBox::information(this,w_msg,"");
		return;
	}

	m3u.reset();
	stream.reset();

		while ( !stream.atEnd() ) {
			QFileInfo *fi = new QFileInfo(stream.readLine());
			if(fi->exists()) insertSongBoxr(fi);
		}
	m3u.close();
	status(QString("Load_files"));
}

int Kmp3burn::save_m3u_file(QString file)
{
	QFile m3u(file);
	if ( !m3u.open( IO_WriteOnly ) ) return -1;
	QTextStream stream( &m3u );
	stream << QString("#EXTM3U") << "\n";

	for (unsigned int n = 0; n < boxr->count(); n++) {
		stream << QString("#EXTINF:") << QString::number((rechts.at(n)->zeit_ms)/1000);
		if((rechts.at(n)->title).isEmpty() && (rechts.at(n)->artist).isEmpty() )
			stream << "\n" ; // no Tag
		else
			stream << "," << rechts.at(n)->artist << " - " << rechts.at(n)->title << "\n" ;

		stream << rechts.at(n)->f_path << "\n";
	}
	m3u.close();
	return 0;
}

// result 1 == OK from to_wav
//        2 == OK from normalize
//        -1 == ERROR from to_wav
//        -2 == ERROR from normalize 
void Kmp3burn::check_result(int a)
{
	update_boxr(index);
	QString noFile = work_dir + "wav/" + QString::number(index-1) + ".wav";

	// last item is created
	if (index == boxr->count()) {
		// last run normalize, if necessary 
		if (a == 1) {
			to_normalize(noFile);
			return;
		}
		else {
			// This delay is useful :-)
			QTimer *timer = new QTimer(this);
			connect( timer, SIGNAL(timeout()),this, SLOT(ready_for_burn_image())); 
			timer->start(2000, TRUE);    // 2 sec, single-shot 
			return;
		}
	}

	QString wavFile = work_dir + "wav/" + QString::number(index) + ".wav";

	if (a == 1)      to_normalize(noFile);
	else if (a == 2) to_wav(static_cast<song_info *> (rechts.at(index)),wavFile);
	else if (a == -2)
		{
		kdDebug() << "Error: to_normalize" << endl; 
		to_wav(static_cast<song_info *> (rechts.at(index)),wavFile);
	}
	else if (a == -1)
		{
		kdDebug() << "Error: to_wav" << endl;
		to_wav(static_cast<song_info *> (rechts.at(index)),wavFile);
	}
}

bool Kmp3burn::testFreeDiscSpace() 
{
	if (totaltime_ms < 1000 || totaltime_ms > 6000000) return true;   // 80 Min

	/** 1ms Playtime == 0,000168 Mb == 176400 bytes */ 
	int needSpace = (int) ((double) totaltime_ms * 0.000168);
	Tools *t = new Tools();
	long freeSpace = t->getFreeDiscSpace();
	if (freeSpace < 1) {
		kdDebug() << "Warning: Can not detect free disc space" << endl;
		return true;
	}
	kdDebug() << "Free Disc Space: " << freeSpace << " MB" << endl;

	if (freeSpace < needSpace) {
		QString msg = "Can not create Image, Free Disc Space only: ";
		msg +=  QString::number(freeSpace) + " MB\n";
		kdDebug() << msg << endl;
		msg += "Needed space: " + QString::number(needSpace) + " MB!\n";
		msg += "Press Cancel, and remove any songs from Burnbox";
		int r = KMessageBox::warningContinueCancel(this,msg,kapp->name(),
			KStdGuiItem::cont(),"space");

		if ( r == KMessageBox::Cancel ) return false;
		else return true;
	}

	else kdDebug() << "CD Image Size = " << needSpace << " MB" << endl; 
	return true;
}

void Kmp3burn::search_codecs()
{
	AkodeStuff::putout_decoders();
	QString output;
	QString w_msg(i18n("Unable to find libakode_mpeg_decoder.so\nNo mp3 support!"));

	// mp3
	if(AkodeStuff::have_codec("mp3")) {
		available_codecs += "*.mp3 *.MP3";
		available_codecs_exp += "mp3|MP3|";
		output += "mp3 ";
	}
	else	KMessageBox::information(this,w_msg,kapp->name(),QString("codec"),4);

	// ogg
	if (AkodeStuff::have_codec("ogg")) {
		available_codecs += " *.ogg *.OGG";
		available_codecs_exp += "ogg|OGG|";
		output += "ogg ";
	}

	// flac
		if (AkodeStuff::have_codec("flac")  ) {
		available_codecs += " *.flac *.FLAC";
		available_codecs_exp += "flac|FLAC|";
		output += "flac ";
	}

	// drop last '|'
	int sl = available_codecs_exp.length();
	if ( available_codecs_exp.endsWith ("|")) available_codecs_exp.remove(sl-1,1); 

	kdDebug() << "Available Codecs: " << output << endl;
}

void Kmp3burn::putout_free_space()
{
	Tools *t = new Tools();
	long freeSpace = t->getFreeDiscSpace();
	if (freeSpace < 1)
		kdDebug() << "Warning: Can not detect free disc space" << endl;
	else kdDebug() << "Free Disc Space: " << freeSpace << " MB" << endl;
}

void Kmp3burn::write_kernel_version()
{
	KConfig *conf = KGlobal::config();
	conf->setGroup("Kernel version");
	conf->writeEntry("Major",QString::number(kernel_major));
	conf->writeEntry("Minor",QString::number(kernel_minor));
	conf->writeEntry("Patchlevel",QString::number(kernel_patch));
	conf->setGroup(QString());
	conf->sync();
}

void Kmp3burn::dedect_pc_power()
{
if (!tools->check_pc_power(&con->cpu_mhz, &con->cpu_cache, &con->ram_size)) return;
kdDebug() << "CPU Takt Frequence: " << con->cpu_mhz << " MHz    CPU Cache: " << con->cpu_cache << " KB     RAM Size: " << con->ram_size << " MB" << endl;
}

void Kmp3burn::to_normalize(QString wav_file)
{
	/** if normalize should not exe, just create statusline and return  */
	if (!KStandardDirs::findExe("normalize") || con->volume_n == false ) {
		QString status(" Convert file: ");
		status +=  statusBarFile + "  ";
		statusBar()->message(status);
		check_result(2);
	}
	else {
		KProcess *adjustVol = new KProcess();
		(*adjustVol) << "normalize" << "-v" << wav_file ;
		connect(adjustVol,SIGNAL(processExited(KProcess*)),this,SLOT(normalize_finish(KProcess*)));
		connect (adjustVol,SIGNAL(receivedStdout(KProcess *,char *, int)), //stdout
		this,SLOT(print_db(KProcess *,char * ,int)));
		connect (adjustVol,SIGNAL(receivedStderr(KProcess *,char *, int)), //stderr
		this,SLOT(print_db(KProcess *,char * ,int)));
		adjustVol->start(KProcess::NotifyOnExit,KProcess::AllOutput);
	}
}

void Kmp3burn::normalize_finish(KProcess *p)
{
p = 0;/** avoid compiler warnung */
check_result(2);
}

void Kmp3burn::create_inf_files()
{
	// 1000/75 = 13,333
	// 4*44100/1000 = 176.4
	// 1 sector = 1/75 s = 2352 bytes = 13,333 ms

	cnt_inf_files = 0;

	QDir d(work_dir);  // delete all inf files
	if(!d.exists()) return;

	for (unsigned int x = 0 ; x < d.count(); x++) 
		if( d[x].endsWith( ".inf" ))  d.remove(d[x]);

	int trackstart = 0;  // first pregap
	for ( unsigned int i = 0; i < boxr->count(); i++ ) { //create_inf_files

		long zeit_ms    = rechts.at(i)->zeit_ms;
		long zeit_gap   = zeit_ms + 2000;
		int cannels     = rechts.at(i)->channels;

		QFile fp(work_dir + QString::number(i) + ".inf");
		if ( !fp.open( IO_WriteOnly )) return;
		QTextStream s( &fp );

		s << "# Filename: "             << QString::number(i) + ".wav" << "\n";
		s << "# Length + 2s pregap: "   << QString::number( (int) ((zeit_gap) / 1000  )) << "\n";
		s << "# Sectors : "             << QString::number((int) (zeit_ms / 13.333)) << "\n";
		s << "# Sectors + 2s pregap : " << QString::number((int) ((zeit_gap) / 13.333)) << "\n";
		s << "Tracknumber=\t"           << QString::number(i) << "\n";
		s << "Trackstart=\t"            << QString::number(trackstart) << "\n";
		s << "Tracklength=\t"           << QString::number((int) ((zeit_gap)/13.333)) << ", 0" << "\n";
		s << "Channels=\t"              << QString::number(cannels) << "\n"; 
		s << "Calc Filesize + Gap =\t"  << QString::number((int) ((zeit_gap) * 176.4) ) << "\n";

		fp.close();
		cnt_inf_files++;
		trackstart += (int) (( zeit_gap ) / 13.333);
		kdDebug() << QString::number(i) + ".inf " << "Trackend: " << trackstart << endl; 

		// deadline = 80 min = 4800 s = 360000 sectors
		if  (trackstart  >= 360000 ) {
			kdDebug() << "create_inf_files: Max Sector size reached" << endl;
			break;
		}
	}
	/** Putout finaly the calculated Image size in Bytes */ 
	kdDebug() << "create_inf_files: Calculated Imagefilesize: " << trackstart*2352 << " bytes" <<  endl;
}

bool Kmp3burn::checkPropertiesExact()
{
	// check snd properties exact, and get totaltime from madlib
	kdDebug() << "checkPropertiesExact" << endl << "#######################" << endl;

	int new_totaltime_ms = 0;
	int cnt = boxr->count();
	if (cnt < 1 ) return false;

	QProgressDialog progress( i18n("Check file properties..."),NULL, cnt, this);
	progress.setMinimumDuration(0);

	for (int i = 0; i < cnt; i++)
	{
		progress.setProgress( i );
		qApp->processEvents();

		const QString *file = new QString((rechts.at(i))->f_path);
		long old_play_time_ms = ((rechts.at(i))->zeit_ms);
		long new_playtime_ms = 0;
		long diff_playtime_ms = 0;

		bool ret = true;
		if((rechts.at(i))->format == "mp3") {
			madlib *m = new madlib();
			ret = m->MpegAudioDecoder(
				file,
				(rechts.at(i))->zeit_ms,
				(rechts.at(i))->bitrate,
				(rechts.at(i))->samplerate,
				(rechts.at(i))->channels
			);

			new_playtime_ms = rechts.at(i)->zeit_ms;
			diff_playtime_ms = new_playtime_ms - old_play_time_ms;
		}

		if ( diff_playtime_ms > 1000 || diff_playtime_ms < -1000 )
			kdDebug() << "Warning: Playtime_diff: "<< diff_playtime_ms << "ms" << endl;

		// we got back a file that's too short or corrupt -> rm song
		if ( new_playtime_ms < 1000 || ret == false ) {
			kdDebug() << "Remove Song, because it seems to be corrupt:" << endl;
			kdDebug() << (rechts.at(i))->f_path << endl;

			QString msg =  (rechts.at(i))->base_name + '\n';
			msg += i18n("seems to be too short or corrupt, remove from selection?");

			int r =  KMessageBox::warningContinueCancel(this,msg,"",KStdGuiItem::cont());
			if (r == KMessageBox::Cancel) return false;

			boxr->setCurrentItem(i);
			remove();
			cnt--;
			i--;
		}
		else new_totaltime_ms += (rechts.at(i))->zeit_ms + 2000;

		kdDebug() << endl;
	}

	progress.setProgress(cnt);
	kdDebug() << "Totaltime diff: " << totaltime_ms-new_totaltime_ms << "ms" << endl; 
	totaltime_ms = new_totaltime_ms;
	char hilfs[20];
	sprintf(hilfs,"%.3d:%.2d",(int)(totaltime_ms/60000),(int)(totaltime_ms/1000)%60);
	lcd->display(hilfs);
	mpb->setProgress(totaltime_ms/60000);

	return true;
}

bool Kmp3burn::checkImageSize()  
{  
	//  80 min = 4800s            85 min = 5100s       90 min = 5400
	if ( totaltime_ms > 5400000 ) {
		QMessageBox::information(this,kapp->name(),i18n("Image is too big, drop any songs!"));
		return false;
	}
	else return true;
}

bool Kmp3burn::calc_power_fly()
{ // my Values:    cpu_cache = 512 KB     cpu_mhz = 1389 MHz    RAM Size = 463 MB    

	// 0 = not valid -> do nothing, return true
	if(con->cpu_cache == 0 || con->cpu_mhz == 0 || con->ram_size == 0) return true;

	// enougth_power -> do nothing, return true
	if(con->cpu_cache > 500 && con->cpu_mhz > 1300 && con->ram_size > 460 ) return true;

	// 0 = not valid -> do nothing, return true
	int cnt = boxr->count();
	if  (cnt < 1 ) return true;

	bool set = false;
	QString sr_songs = 
	i18n("Resampling this files to 44100 Hz needs a lot of CPU Power. \
	Burn_on_the_fly could produce Buffer Underruns.      \
	Kmp3burn advice you to drop these files below,              \
	or don't use Burn_on_the_fly.\n");   

	for (int i = 0; i < cnt; i++) {
		int sr = rechts.at(i)->samplerate;

		// Upsample from 22050 to 44100 its OK on my old PC,
		// for all other resamples I advice to create an Image.
		if ( sr != 22050 && sr != 44100 ) {
			sr_songs += "Samplerate: ";
			sr_songs += QString::number(sr);
			sr_songs += " --> ";
			sr_songs += QFileInfo(rechts.at(i)->f_path).baseName(true);
			sr_songs += '\n';
			set = true;
		}
	}

	if(!set) return true; // No high samplerate files in List

	int r = KMessageBox::warningContinueCancel(this,sr_songs,"",
		KStdGuiItem::cont(),"power");

	if (r == KMessageBox::Cancel) return false;
	else return true;
}
