/***************************************************************************
                          madlib.h  -  description
                             -------------------
    begin                : april 10 2006
    copyright            : (C) 2006 by Martin Keil
    email                : martin-keil@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// This code was orginally written in C by Bertrand Petit.
// (c) 2001--2004 Bertrand Petit


#ifndef MADLIB_H
#define MADLIB_H

#include <stdio.h>
#include <mad.h>

#if (!defined(unix) && !defined (__unix__) && !defined(__unix))
/* Memory exhausted */
# ifndef ENOMEM
#  define ENOMEM	(1)
# endif

/* Bad file descriptor */
# ifndef EBADF
#  define EBADF		(1)
# endif

/* Invalid address. */
# ifndef EFAULT
#  define EFAULT	(1)
# endif

/* Invalid argument. */
# ifndef EINVAL
#  define EINVAL	(1)
# endif
#endif

#define BFILE_BUFSIZE (8192U)

struct bstdfile {
	char buffer[BFILE_BUFSIZE];
	char *live;
	size_t	live_size;
	FILE	*fp;
	int eof, error;
	};

typedef struct bstdfile bstdfile_t;

class QString;

/** @author Martin Keil */
class madlib{

public:
	madlib();
	~madlib();

	//Main decoding loop
	bool MpegAudioDecoder(const QString *file, long &lenght_ms, int &bitrate, int &samplerate, int &channels);


private:
	// This works as read(2) but operates on a bfile instead of a file descriptor
	size_t BstdRead(void *UserBuffer, size_t ElementSize, size_t ElementsCount, bstdfile_t *BstdFile);

	bstdfile_t *NewBstdFile(FILE *fp);
	int BstdFileDestroy(bstdfile_t *BstdFile);
	int BstdFileEofP(const bstdfile_t *BstdFile) {return(BstdFile->eof);}
	int BstdFileErrorP(const bstdfile_t *BstdFile) {return(BstdFile->error);}

	mad_header *first_header; 

};

#endif
