
#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kmainwindow.h>
#include "kmp3burn.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


static KCmdLineOptions options[] = {{ 0, 0, 0 }};

int main(int argc, char *argv[])
{
	// I18N_NOOP is OK in this case
	KAboutData about( "kmp3burn",I18N_NOOP("kmp3burn"),VERSION,
	"Select mp3 files and put them in an easy way on any audio CD",KAboutData::License_GPL,
	"(c) 2004-2007  Martin Keil", 0, "http://www.martin-keil.de");
	
	about.addAuthor("Martin Keil",0, "martin-keil@gmx.net","http://www.martin-keil.de");
	about.addCredit("Tomil Grabowski",I18N_NOOP("Add Polish translation"),"tomig@tomig.com", 0);
	about.addCredit("Jozef Riha",I18N_NOOP("Add Slovak translation"),"jose1711@gmail.com", 0);

	KCmdLineArgs::init( argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );

	KApplication a;
	Kmp3burn *kmp3burn = new Kmp3burn();
	a.setMainWidget(kmp3burn);
	kmp3burn->show();
	return a.exec();
}
