
#include <qtimer.h>
#include <qstring.h>

#include <kdebug.h>

#include "decoding.h"
#include "makewav.h"
#include "myprocess.h" 
#include "kmp3burn.h"

MakeWav::MakeWav(QObject *parent, const char *name)  : QObject(parent, name) {}
MakeWav::~MakeWav() {}

int MakeWav::do_it(struct song_info *si, QString wav_file)
{

	MyProcess *s = new MyProcess;
	*s << "sox" <<  "-t" << "raw"  << "-x" << "-s" << "-w" << "-c" << "2" << "-r" << "44100" << "-"   << wav_file ;
	s->setRawStdin(true);
	bool sx = s->start(MyProcess::NotifyOnExit,MyProcess::All );
		if(!sx) {
			kdDebug() << "can't start sox!" << endl;
			emit finish(-1);  // 0 == success
			return -1;
		}

	Decoding *deco = new Decoding();
	int ret = deco->open_music_f(si, s->stdinFd(),false);

	if ( ret < 0 ) {
		kdDebug() << "MakeWav: Could not load decoder-plugin!" << endl;
		emit finish(-1);
		return -1;
	}
 
	while(-1 != deco->decode()) ;  // Decoder starten
	s->kill();
	sleep(1);
	emit finish(1);              // 1 == success
	return 0;
}

