
/*
 *  Class MyListBoxItem
 *  Draw ListBoxItems Red or Blue, change Background  
 *  Martin Keil 15.05.2004
 */

#include <qwidget.h>
#include <qlistbox.h>	
#include <qpainter.h>


class MyListBoxI : public QListBoxItem
{
public:
	MyListBoxI(const QString s, QListBox *lb );
	~MyListBoxI();
	void changeColor(QColor color) {if(color.isValid()) co = color; };
	void setBaseColor(QColor c) { base_co = c; };
	void setBackground() {backgr_co.setRgb(100,200,255); };
	void unsetBackground() {backgr_co.setRgb(255,255,255);};
	QColor getBaseColor() {return base_co; };
	QColor getColor() {return(co);};

protected:
	virtual int height( const QListBox *lb) const;
	virtual int width(const QListBox *lb) const; 
	virtual QPixmap *pixmap() { return &pm; }
	virtual void paint( QPainter * );

private:
	QPixmap pm;
	QColor base_co, backgr_co, co;
};
