
#include <qdropsite.h>
#include <qdragobject.h>
#include <qmime.h>
#include <qstringlist.h>

#include "mylistbox.h"

MyListBox::MyListBox(QWidget *parent, const char *name ) : QListBox(parent,name)
{
	setAcceptDrops(TRUE);
}

MyListBox::~MyListBox(){}

void MyListBox::mouseReleaseEvent (QMouseEvent *e)
	{if(e->button() == RightButton) emit button_2();}

void MyListBox::dropEvent(QDropEvent *e)
{
	if ( !QUriDrag::canDecode(e) ) {
		e->ignore();
		return;
	}
	QStringList lst;
	QUriDrag::decodeLocalFiles( e, lst );
	emit drop_file(lst);
}
