
#include <qlabel.h>
#include <qtimer.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qfileinfo.h>
#include <qpainter.h>

#include <kiconloader.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include "myplayer.h"
#include "player.h"
#include "kmp3burn.h"

MyPlayer::MyPlayer(QWidget *parent, const char *name)
: QWidget(parent, name)
{
	setFixedSize(360,110);

	QFileInfo vol(::locate("data","kmp3burn/pics/volume.png"));  // Volume Vertical
	if (vol.exists()) {
		QPixmap pm;
		KIconLoader *lder = new KIconLoader();
		pm.load(lder->iconPath(vol.fileName(),-64));
		QLabel *l = new QLabel(this);
		l->setGeometry(330,10,25,80);
		l->setPixmap(pm);
	}
	QString v;
	volume_l = new QLabel(this);
	volume_l->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken);
	volume_l->setGeometry(330,0,25,20);
	volume_l->setAlignment(Qt::AlignCenter);
	volume_l->setText(v.setNum(0));  // default

	qs = new mySlider(0,1000 ,1,0,QSlider::Horizontal,this,"qs");
	qs->setGeometry(0,45,300,20);
	qs->setTracking(false); // wichtig fr connect
	connect(qs,SIGNAL(sliderPressed()),     this,SLOT(slider_dont_move()));
	connect(qs,SIGNAL(sliderReleased()),    this,SLOT(play_music_position()));

	slider_pressed = false;

	vs = new mySlider(0,100,1,100,Qt::Vertical,this); 
	vs->setGeometry(305,0,25,105);
	vs->setEnabled(false);
	connect(vs,SIGNAL(valueChanged(int)),this,SLOT(setSliderVolume(int)));

	display = new QLabel(this);
	display->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken);
	display->setGeometry(0,0,300,40);
	display->setAlignment(Qt::AlignCenter);
	display->setLineWidth(3);
	display->setMidLineWidth(3);
	display->setPaletteBackgroundColor("gray");

	QPixmap         *pm_play          = new QPixmap;
	QPixmap         *pm_stop          = new QPixmap;
	QPixmap         *pm_pause         = new QPixmap;
	QPixmap         *pm_fwd           = new QPixmap;
	QPixmap         *pm_rew           = new QPixmap;
	
	KIconLoader     *loader = new KIconLoader();
	pm_play         ->load(loader->iconPath(QString("player_play"),-32));
	pm_pause        ->load(loader->iconPath(QString("player_pause"),-32));
	pm_stop         ->load(loader->iconPath(QString("player_stop"),-32));
	pm_fwd          ->load(loader->iconPath(QString("player_fwd"),-32));
	pm_rew          ->load(loader->iconPath(QString("player_rew"),-32));

	spielen_b = new QPushButton(this,"spielen_b");
	spielen_b->setGeometry(0,66, 60,40 );
	spielen_b->setPixmap(*pm_play);
	spielen_b->setEnabled(false);
	connect(spielen_b,SIGNAL(clicked()),this,SIGNAL(play_button_clicked()));

	pause_b = new QPushButton(this);
	pause_b->setGeometry(60,66, 60, 40 );
	pause_b->setPixmap(*pm_pause);
	pause_b->setEnabled(false);
	connect(pause_b,SIGNAL(clicked()),this,SLOT(pause()));	

	stop_b = new QPushButton(this);
	stop_b->setGeometry(120,66, 60, 40 );
	stop_b->setPixmap(*pm_stop);
	stop_b->setEnabled(false);
	connect(stop_b,SIGNAL(clicked()),this,SLOT(play_music_stop()));

	fwd_b = new QPushButton(this);
	fwd_b->setGeometry(180,66, 60, 40 );
	fwd_b->setPixmap(*pm_fwd);
	fwd_b->setEnabled(false);
	connect(fwd_b,SIGNAL(clicked()),this,SIGNAL(bring_fwd_song()));	

	rew_b = new QPushButton(this);
	rew_b->setGeometry(240,66, 60, 40 );
	rew_b->setPixmap(*pm_rew);
	rew_b->setEnabled(false);
	connect(rew_b,SIGNAL(clicked()), this,SIGNAL(bring_rew_song()));

	QTimer *timer   = new QTimer();
	timer->start( 500, false );
	connect(timer,SIGNAL(timeout()),this,SLOT(update_player()));  // need m_player

	setupPlayer();
}

MyPlayer::~MyPlayer() {}

void MyPlayer::setupPlayer()
{
	m_player = Player::createPlayer();

	QString aRts_not_playable_mp3(i18n("\
	Warning: aRts is not playable mp3 \n\n \
	Maybe you can' t hear mp3 tracks,\n \
	or you' ve got bad audio quality! \n\n \
	Install Package:\n \
	mpeglib\n \
	mpeglib_artsplug\n \
	from kdemultimedia."));   
}

void MyPlayer::update_player()  // wird 3x pro Sekunde aufgerufen
{

	if (!m_player->playing() && !m_player->paused())  {
		display->setBackgroundColor("gray");
		display->clear();
		qs->setEnabled(false);
		emit song_played();
		if (loop == true) bring_fwd_song();
		return;
	}

	if (slider_pressed == false && !m_player->paused())
		qs->setValue(m_player->position());

	// Layout
	vs->setEnabled(true);
	qs->setEnabled(true);
	display->setBackgroundColor("blue");
	QString curTime, bitRate, sRate, song, song2;
	song =  akt_song.base_name + QString("               ");
	if (playTime == 0) slidesong = song;
	slidesong += slidesong.mid(playTime,1);
	song2 = slidesong.right(slidesong.length() - playTime);

	playTime++;
	int t = (int) m_player->currentTime();

	curTime.sprintf("%.2d:%.2d",t/60,t%60);
	bitRate.setNum(akt_song.bitrate); bitRate += " kbps";
	sRate.setNum(akt_song.samplerate); sRate += " Hz";

	QPixmap map(285,40);
	map.fill(display, 285,40 );
	QPainter pt;
	pt.begin(&map);
	pt.setPen( QColor("yellow") );
	QFont f;
	f.setBold(true);
	pt.setFont(f);
	QFontMetrics fm( f );
	if (fm.width(akt_song.base_name) < 285)
		song2 = akt_song.base_name;
	
	pt.drawText(QPoint(0,16), song2);
	pt.drawText(QPoint(0,32),curTime);
	f.setBold(false);
	pt.setFont(f);
	pt.drawText(QPoint(55,32),bitRate);
	pt.drawText(QPoint(123,32),sRate);
	pt.drawText(QPoint(192,32),akt_song.time_string);

	if ( akt_song.channels >= 2)
		pt.drawText(QPoint(242,32),QString("Stereo")); 

	pt.end();
	display->setPixmap(map);	 
}

int MyPlayer::play_music(song_info song)
{
	if (m_player->playing() || m_player->paused()) m_player->stop();
	akt_song = song;
	float v = (((float) 100 - vs->value())/100);  // Volume
	m_player->play(song.f_path,v);
	playTime = 0;
	stop_b->setEnabled(true);
	pause_b->setEnabled(true);
	loop = true;
	update_player();
	return(0);
}
int MyPlayer::play_music_stop()
{
	emit player_stop("player_stop");
	m_player->stop();
	qs->setValue(0);
	loop = false;
	stop_b->setEnabled(false);
	pause_b->setEnabled(false);
	return 0;
}
void MyPlayer::setSliderVolume(int vol)
{
	QString n;
	volume =  ( (float) 100 - vol)/100;
	volume_l->setText(n.setNum(100 - vol));
	m_player->setVolume(volume);
	emit volume_changed(100 - vol);
}
void MyPlayer::setVolume(int vol)
{
	QString n;
	float  v =  ( (float) vol)/100;
	volume_l->setText(n.setNum(vol));
	m_player->setVolume(v);
	vs->setValue(100 - vol);
}

int MyPlayer::play_music_position()
{
	m_player->seekPosition(qs->value());        
	slider_pressed = false ;
	return 0;
}
void MyPlayer::pause()
{
if (m_player->playing())  m_player->pause();
else if (m_player->paused()) m_player->play(volume);
}

long MyPlayer::total_time_ms(QString file)
{
return m_player->totalTime(file);
}

void MyPlayer::slider_dont_move() {slider_pressed = true;}
void MyPlayer::slider_released() {slider_pressed = false;}
void MyPlayer::setPlayButton() {spielen_b->setEnabled(true);}
void MyPlayer::unsetPlayButton() {spielen_b->setEnabled(false);}
void MyPlayer::set_fwd_button()  {fwd_b->setEnabled(true);}
void MyPlayer::set_rew_button() {rew_b->setEnabled(true);}
void MyPlayer::unset_fwd_button()  {fwd_b->setEnabled(false);}
void MyPlayer::unset_rew_button() {rew_b->setEnabled(false);}


mySlider::mySlider( int minValue, int maxValue, int pageStep, int value, Orientation orientation, QWidget * parent, const char *name )
: QSlider( minValue, maxValue, pageStep, value, orientation, parent,  name ){};
mySlider::~mySlider() {}

void mySlider::mousePressEvent(QMouseEvent *e) {
	if(e->button() == LeftButton) {
		QMouseEvent reverse(QEvent::MouseButtonPress, e->pos(), MidButton, e->state());
		QSlider::mousePressEvent(&reverse); 
	}
	else if(e->button() == MidButton) {
		QMouseEvent reverse(QEvent::MouseButtonPress, e->pos(), LeftButton, e->state());
   	QSlider::mousePressEvent(&reverse); 
	}
}
