//
// Description: A simple GUI mp3player 
// Author:      Martin Keil martin-keil@gmx.net (C) 2005
// Licenze:     GPL
//

#ifndef MYPLAYER_H
#define MYPLAYER_H

#include <qwidget.h>
#include "kmp3burn.h"

class QSlider;
class QPushButton;
class QLabel;
class Player;

class MyPlayer : public QWidget
{
	Q_OBJECT
public:

	 MyPlayer(QWidget *parent = 0, const char *name = 0);
	~MyPlayer();

signals:
	void play_button_clicked();
	void bring_rew_song();
	void bring_fwd_song();
	void song_played();
	void volume_changed(int v);
	void player_stop(QString );    /** "player_stop"  */

public slots:
	int play_music(song_info so);  /** song_info == global in kmp3burn.h */
	int play_music_stop();
	void setVolume(int );          /** range: 0 - 100 */
	void setPlayButton();
	void unsetPlayButton();
	void set_fwd_button(); 
	void set_rew_button(); 
	void unset_fwd_button(); 
	void unset_rew_button(); 
	long total_time_ms(QString file);

private slots:
	void setupPlayer();
	void update_player();
	int play_music_position();
	void pause();
	void slider_dont_move();
	void slider_released();
	void setSliderVolume(int vol);

private:
	QSlider *qs, *vs;
	QLabel *display, *volume_l; 
	QPushButton *stop_b, *pause_b, *fwd_b, *rew_b, *spielen_b;

	Player *m_player;
	QString slidesong;
	song_info akt_song;
	
	int playTime;
	float  volume;
	bool slider_pressed;
	bool loop;
};


/**
 * This "custom" slider reverses the left and middle buttons.  Typically the 
 * middle button "instantly" seeks rather than moving the slider towards the
 * click position in fixed intervals.  This behavior has now been mapped on
 * to the left mouse button.
 */

#include <qslider.h>
class mySlider : public QSlider
{
public:
	mySlider( int minValue, int maxValue, int pageStep, int value, Orientation orientation, QWidget * parent, const char * name = 0 );
	virtual ~mySlider();

protected:
	virtual void mousePressEvent(QMouseEvent *e);
};


#endif
