
#include <qgroupbox.h>
#include <qstring.h>
#include <qframe.h>
#include <qlabel.h>

#include <klocale.h>

#include "myslider.h"

MyProgressBar::MyProgressBar(QWidget *parent, const char *name) : QWidget(parent, name)
{
	
	this->setFixedSize(360,60);

	QGroupBox *t_time = new QGroupBox((i18n("Total Time")),this);
	t_time->setGeometry(0,10,355,40);
	
	progressBar = new QFrame(this);
	progressBar->setGeometry(10,26,1,15);
	progressBar->setPaletteBackgroundColor("blue");

	QLabel *min = new QLabel(this);
	min->setGeometry(242,0,45,15);
	min->setText("80 min");
	min->setPaletteForegroundColor("red");	

	QFrame *mk = new QFrame(this);
	mk->setGeometry(288,4,0,45);
	mk->setPaletteBackgroundColor("red");
}


MyProgressBar::~MyProgressBar()
{
}

void MyProgressBar::setProgress(int min)
{
	// range 0 - 330  -> 0 - 94 min
	if (min < 0) min = 0 ;
	if (min > 94) min = 94;
	int l = (int) ((float)min*3.5106);
	progressBar->setGeometry(10,28,l,15);
}
