
#ifndef SONG_H
#define SONG_H

#include <qstring.h>
#include <qobject.h>
#include <qfileinfo.h>

#include <fcntl.h>

namespace TagLib { class File; }

class Song
{
public:

	static Song *createTag(const QString &fileName);
	virtual ~Song();

	QString getTitle() const {return m_title;}
	QString getArtist() const {return m_artist;}
	void setFormat(QString f) {m_format = f;}   // mp3 or ogg
	QString getFormat() const {return m_format;}
	int getLength() const {return m_length;}
	int getBitrate() const {return m_bitrate;}
	int getSamplerate() const {return m_samplerate;}
	int getChannels() const {return m_channels;}


private:
	Song(const QString &fileName, TagLib::File *file, QString format);

	FILE *fp;
	unsigned char *mbp;

	QFileInfo m_info;
	QString m_fileName;	
	QString m_title;
	QString m_artist;
	QString m_album;
	QString m_genre;
	QString m_comment;
	QString m_format;
	int m_track;
	int m_year;
	int m_seconds;
	int m_bitrate;
	int m_length;
	int m_samplerate;
	int m_channels;
	int m_samplewidth;
};

#endif
