/***************************************************************************
                          sysmonitor.cpp  -  description
                             -------------------
    begin                : Fre Aug 16 2003
    copyright            : (C) 2002 by martin keil
    email                : martin-keil@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtextedit.h>
#include <qstring.h>
#include <qprogressbar.h>
#include <qlabel.h>

#include <klocale.h>
#include <kdebug.h>

#include "sysmonitor.h"

SysMonitor::SysMonitor(QWidget *parent, const char *name )
	: QWidget(parent,name),all(""),akt_sng(""),
		totalsize("0"),part_total(-1),slide(true)

{
	setCaption(i18n("Progress Monitor"));
	setGeometry(100,100,710,490 );
	setFixedSize(710,490);
	editor = new QTextEdit(this);
	editor->setGeometry(5,5,700,400 );
	editor->setReadOnly(true);


	total = new QProgressBar(this);
	sng   = new QProgressBar(this);
	total->setGeometry(30,440,200,30);
	sng->setGeometry(270,440,200,30);

	l_total = new QLabel(this);
	l_sng = new QLabel(this);
	l_total->setGeometry(30,410,200,30);
	l_sng->setGeometry(270,410,500,30);

	QString pro(i18n("Progress:"));
	pro = "<b>" + pro + "<\b>";
	l_total->setText(pro);

	connect(editor,SIGNAL(verticalSliderPressed()),this,SLOT(stopSlide()));
	connect(editor,SIGNAL(verticalSliderReleased()),this,SLOT(startSlide()));
}

SysMonitor::~SysMonitor() {}

void SysMonitor::collect_std(KProcess *, char *stream, int)
{
	qstream = stream;

	if ( qstream.contains("Lout start:") ) {
		totalsize = (qstream.section("Lout start:",1,1)).section("MB",0,0);
		totalsize.stripWhiteSpace();
	}

	// Track 01: 29 of 32 MB written (fifo 100%) 8.3x
	if ( qstream.contains("MB written") && qstream.contains(":") ) {
		QString part = (qstream.section(":",1,1)).section("of",0,0);
		part.stripWhiteSpace();
		part_total++;

		QString track = (qstream.section("of",1,1)).section("MB",0,0);
		track.stripWhiteSpace();

		bool a, b, c;
		int p = part.toInt(&a);
		int t = track.toInt(&b);
		int s = totalsize.toInt(&c);

		if ( a==true && b==true && c==true ) {
			sng->setProgress(p,t);
			total->setProgress(part_total,s);
			l_sng->setText(QString("<b>" + akt_sng + "<\b>"));

			if ( p == 1 && (!qstream.contains("Track 01:"))) // new song, not first
				akt_sng = "";
			
		}
	}

	if (!qstream.contains("MB written")) {
		all += qstream;
		print_text = all;
	}

	else {
		if( qstream.contains("Total"))
			all+=last_text;
		else {
			QChar c;
			uint l = qstream.length();
			c = qstream.at(0);
			if(!c.isPrint())
			qstream = qstream.right(l-1);

			last_text = qstream + '\n';
			qstream += '\n';
			print_text = all + qstream;
		}
	}

	if( qstream.contains("Fixating time:") ) { // end
		total->setProgress(part_total,part_total);
		//all += "<b>END<\b>";
	}

	if ( slide ) editor->scrollToBottom();

	editor->setText(print_text);
}

void SysMonitor::show_win()
{
	all = "";
	akt_sng = "";
	totalsize = "0";
	slide = true;
	total->reset();
	sng->reset();
	part_total = -1;
	show();
}

