/***************************************************************************
                          sysmonitor.h  -  description
                             -------------------
    begin                : Fre Aug 16 2003
    copyright            : (C) 2002 by martin keil
    email                : martin-keil@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYSMONITOR_H
#define SYSMONITOR_H

#include <qwidget.h>
#include <kprocess.h>
#include <qtextedit.h>

class QString;
class QProgressBar;
class QLabel;

class SysMonitor : public QWidget {
   Q_OBJECT
public:
	SysMonitor(QWidget *parent=0, const char *name=0);
	~SysMonitor();
	void show_win();

	QString all;
	QString akt_sng;

public slots:
	void collect_std(KProcess *,char *, int);

private slots:
	inline void stopSlide() {slide = false;}
	inline void startSlide() {slide = true;}

private:
	QTextEdit *editor;
	QProgressBar *sng, *total;
	QString last_text;
	QString print_text;
	QString qstream; // next block from cdrecord
	QString totalsize;
	QLabel *l_total;
	QLabel *l_sng;
	int part_total;
	bool slide;
};

#endif
