
#include <sys/utsname.h>        // kernel version

#include <qstring.h>
#include <qfile.h>
#include <qregexp.h>

#include <kstandarddirs.h>
#include <kprocess.h>
#include <kgenericfactory.h>
#include <kdebug.h>

#include "tools.h"

Tools::Tools() : 
	overburn(false),
	tao(false),
	gracetime(false),
	driveropts(false),
	shorttrack(false),
	useinfo(false),
	dao(false),
	have_sox_resampler(false),
	flag_support(false)
	{}

Tools::~Tools(){}

bool Tools::check_cdrecord_scanbus()
{
	// if linuxkernel != 2.4.x or
	// we dont know it, do nothing
	int major,minor,patch;
	if (!getVersion(&major,&minor,&patch)) return true;                
	if(major != 2 || minor != 4) return true;

	KProcess *proc1 = new KProcess();
	*proc1 << "cdrecord" << "--scanbus";
	if( proc1->start(proc1->Block ) == false )return false;
	if (proc1->exitStatus() != 0 ) return false;
	return true;
}
int Tools::check_cdrecord_version()
{
	KProcess *proc2 = new KProcess();
	*proc2 << "cdrecord" << "-version";
	connect(proc2,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(collect_std(KProcess*,char*,int)));

	if (proc2->start(proc2->Block ,proc2->Stdout )== false ) return -1;
	if (proc2->exitStatus() != 0 ) return -1;
	if (str.contains("2.0")) return 20;
	if (str.contains("1.8.1")) return 181;
	if (str.contains("1.1"))   return 11;

	return -1;
}
void Tools::collect_std(KProcess*, char *stream, int a)
{
	str = stream;
	a = 0;
}

void Tools::overb(KProcess*,char *stream,int l)
{
over += stream;
l = 0;
}
bool Tools::check_cdrecord_features()
{
	KProcess *proc3 = new KProcess();
	*proc3 << "cdrecord" << "--help";
	connect(proc3,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(overb(KProcess*,char*,int)));
	connect(proc3,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(overb(KProcess*,char*,int)));

	if (proc3->start(proc3->Block ,proc3->Stderr) == false )
		return false;

	if (proc3->exitStatus() != 0 )    return false;
	if (over.contains("overburn"))    overburn = true;
	if (over.contains("gracetime"))   gracetime = true;
	if (over.contains("driveropts"))  driveropts = true;
	if (over.contains("shorttrack"))  shorttrack = true;
	if (over.contains("useinfo"))     useinfo = true;
	if (over.contains("dao"))         dao = true;
	if (over.contains("tao"))         tao = true;

	if(!overburn)   kdDebug() << "Tools: Feature not found: cdrecord -overburn" <<  endl; 
	if(!gracetime)  kdDebug() << "Tools: Feature not found: cdrecord -gracetime" <<  endl; 
	if(!driveropts) kdDebug() << "Tools: Feature not found: cdrecord -driveropts" <<  endl; 
	if(!shorttrack) kdDebug() << "Tools: Feature not found: cdrecord -shorttrack" <<  endl; 
	if(!useinfo)    kdDebug() << "Tools: Feature not found: cdrecord -useinfo" <<  endl; 
	if(!dao)        kdDebug() << "Tools: Feature not found: cdrecord -dao" <<  endl; 	
	if(!tao)        kdDebug() << "Tools: Feature not found: cdrecord -tao" <<  endl; 

	return true;
}

void Tools::check_sox_reampler()
{
	KProcess *proc4 = new KProcess();
	*proc4 << "sox" << "--help";
	connect(proc4,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(overb(KProcess*,char*,int)));
	connect(proc4,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(overb(KProcess*,char*,int)));
	if (proc4->start(proc4->Block ,proc4->Stderr) == false ) return;

	if (over.contains("resample"))    have_sox_resampler = true;
	if(!have_sox_resampler)   kdDebug() << "Tools: sox resampler not found" <<  endl; 

}

long Tools::getFreeDiscSpace()
	{
	KProcess *df = new KProcess();
	*df << "df" << "/";
	connect(df,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(processOut(KProcess*, char*, int )));
	connect(df,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(processOut(KProcess*, char*, int )));
	
	if (df->start(df->Block,df->Stdout) == false ) return -1;
	if (df->exitStatus() != 0 ) return -1;

	/** 1. Zeile überspringen */
	int pos = process_out.find(QRegExp("\\n"));
	if( pos < 0 )
		return -1;

	pos++;
	/**  a whitespace */
	pos = process_out.find(QRegExp("\\s"),pos);
	if( pos < 0 )
		return -1;

	pos++;
	/** no whitespace */
	pos = process_out.find(QRegExp("\\S"),pos);
	if( pos < 0 )
		return -1;
		pos++;
	/**  a whitespace */
	pos = process_out.find(QRegExp("\\s"),pos);
	if( pos < 0 )
		return -1;

	pos++;
	/** no whitespace */
	pos = process_out.find(QRegExp("\\S"),pos);
	if( pos < 0 )
		return -1;
	pos++;
	/**  a whitespace */
	pos = process_out.find(QRegExp("\\s"),pos);
	if( pos < 0 )
		return -1;

	pos++;
	/** no whitespace */
	pos = process_out.find(QRegExp("\\S"),pos);
	if( pos < 0 )
		return -1;

	/** end */
	int endPos = process_out.find(QRegExp("\\s"),pos);
	if( pos < 0 ) return -1;

	QString k_bytes = process_out.mid(pos,endPos-pos);
	bool ok = false;
	long MB = k_bytes.toLong(&ok);
	if (MB == 0) return -1;
	MB = MB/1024;

	if(!ok) return -1;
	else return MB;
	}

void Tools::processOut(KProcess*,char *stream,int l)
{
	process_out += stream;
	l = 0;
}

bool Tools::getVersion(int *major, int *minor, int *patchlevel)
{
	QString ma, mi, patch;
	utsname unameinfo;
	if( uname(&unameinfo) != 0 ) return false;


	QString line = unameinfo.release;
	//line =  "2.4.8-24-default";
	
	int pos = line.find( QRegExp("\\d"));    // digit
	if( pos < 0 ) return false;

	int endPos = line.find( QRegExp("-" ), pos+1 );  // "-" 
	if( endPos < 0 ) return false;

	QString vString = line.mid( pos, endPos-pos );
	vString = vString.stripWhiteSpace();

	int p = vString.find( QRegExp("\\D") );     // no digit
	ma = vString.mid(0,p);                      // 0 == start, p == len
	vString.remove(0,p +1 );                    // +1 == point 

	p = vString.find( QRegExp("\\D"), p ); 
	mi = vString.mid(0,p);   
	vString.remove(0,p +1 ); 

	p = vString.find( QRegExp("\\D"), p );  
	patch = vString.mid(0,p);  
	vString.remove(0,p +1 );  

	if( ma.toInt() > -1 && ma.toInt() < 100)
		if( mi.toInt() > -1 && mi.toInt() < 100)
			if( patch.toInt() > -1 && patch.toInt() < 100)
				{
					*major       = ma.toInt();
					*minor       = mi.toInt();
					*patchlevel  = patch.toInt();
					return true;
				}
	else return false;

	return false;
}
	
bool Tools::has_flac_support()
{
	KStandardDirs *ks = new KStandardDirs();
	QString akd = ks->findResource("lib", "libakode_xiph_decoder.so");

	KProcess *p = new KProcess();
	*p << "ldd" << "/opt/kde3/lib/libakode_xiph_decoder.so";

	connect(p,SIGNAL(receivedStdout(KProcess*,char*,int)),
		this,SLOT(collect_std(KProcess*, char*, int )));
	connect(p,SIGNAL(receivedStderr(KProcess*,char*,int)),
		this,SLOT(collect_std(KProcess*, char*, int )));

	if (p->start(p->Block,p->Stdout) == false ) return false;
	if ( str.contains("libFLAC.so") && !str.contains("not found"))
		{ 
		flag_support = true;
		return true;
	}
	else {
		kdDebug() << "Tools: No FLAG support" <<  endl;
		return false;
	}
}

bool Tools::check_pc_power(int *cpu_mhz, int *cpu_cache, int *ram_size)
{
	*cpu_mhz = *cpu_cache = *ram_size = 0;
	QFile cpuinfo( "/proc/cpuinfo" );
	if ( !cpuinfo.open( IO_ReadOnly ) ) return false; 
	QTextStream stream( &cpuinfo );
	QString line; int i = 1;
	while ( !stream.atEnd() ) {
		line = stream.readLine();
		if (line.contains("cpu MHz") && line.contains(": ")) {
			line = line.section(": ",1);
			*cpu_mhz =  (int) line.toFloat();
			if (*cpu_mhz < 300 || *cpu_mhz > 10000) return false;
		}
		if (line.contains("cache size") && line.contains(": ")) {
			line = (line.section(": ",1));
			line = line.remove(" KB");
			*cpu_cache =  (int) line.toInt();
			if (*cpu_cache < 16 || *cpu_cache > 10000) return false;
		}
		i++;
	}
	cpuinfo.close(); 

	QFile meminfo( "/proc/meminfo" );
	if ( !meminfo.open( IO_ReadOnly ) ) return false; 
	QTextStream stream2( &meminfo );
	i = 1;
	while ( !stream2.atEnd() ) {
		line = stream2.readLine();
		if (line.contains("MemTotal: ")) {
			line = line.section(": ",1);
			line.stripWhiteSpace();
			line.remove("kB");
			*ram_size =  line.toInt();
			*ram_size = *ram_size/1000;
			if (*ram_size < 16 || *ram_size > 20000) return false;
		}
	i++;
	}
	return true;
}

bool Tools::is_soundfile(QString file)
{
	process_out = "";
	KProcess *f = new KProcess();
	*f << "file" << file;
	connect(f,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(processOut(KProcess*, char*, int )));
	connect(f,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(processOut(KProcess*, char*, int )));

	if (!f->start(f->Block,f->Stdout) || f->exitStatus() ) {
		kdDebug() << "Tools: warning: can't test mp3 file: " << file << endl << endl;
		return true;
	}

	/** skip filename */
	process_out = process_out.section(": ",1);

	/** search (mp3 ogg flac) stuff */
	if(process_out.contains( QRegExp( "(MP3|mp3|OGG|Ogg|ogg|FLAC|flac|MPEG|mpeg)" ))) return true;
	else return false;


return true;
}



