#ifndef TOOLS_H
#define TOOLS_H

#include <qobject.h>

class KProcess;

class Tools  : public QObject
{
Q_OBJECT
public:
	Tools();
	~Tools();

	// exec "cdrecord -scanbus" only if we found the kernel 2.4.x
	bool check_cdrecord_scanbus();
	int check_cdrecord_version();
	bool check_cdrecord_features();
	void check_sox_reampler();

	/** if success, return true */
	bool check_pc_power(int *cpu_mhz, int *cpu_cache, int *ram);
	
/*
	ldd ohne flac
	martin@(none):/opt/kde3/lib> ldd libakode_xiph_decoder.so
        linux-gate.so.1 =>  (0xffffe000)
        libakode.so.1 => /opt/kde3/lib/libakode.so.1 (0x40005000)
        libpthread.so.0 => /lib/tls/libpthread.so.0 (0x4002d000)
        libdl.so.2 => /lib/libdl.so.2 (0x4003f000)
        libvorbisfile.so.3 => /usr/lib/libvorbisfile.so.3 (0x40043000)
        libvorbis.so.0 => /usr/lib/libvorbis.so.0 (0x4004a000)
        libogg.so.0 => /usr/lib/libogg.so.0 (0x40072000)
        libstdc++.so.5 => /usr/lib/libstdc++.so.5 (0x40078000)
        libm.so.6 => /lib/tls/libm.so.6 (0x40135000)
        libc.so.6 => /lib/tls/libc.so.6 (0x40158000)
        libgcc_s.so.1 => /lib/libgcc_s.so.1 (0x4026e000)
        /lib/ld-linux.so.2 => /lib/ld-linux.so.2 (0x80000000)
  
        mit flag:
        martin@(none):/opt/kde3/lib> ldd libakode_xiph_decoder.so
        linux-gate.so.1 =>  (0xffffe000)
        libakode.so.1 => /opt/kde3/lib/libakode.so.1 (0x40008000)
        libpthread.so.0 => /lib/tls/libpthread.so.0 (0x40030000)
        libdl.so.2 => /lib/libdl.so.2 (0x40042000)
        libOggFLAC.so.3 => /usr/local/lib/libOggFLAC.so.3 (0x40046000)
        libFLAC.so.7 => /usr/local/lib/libFLAC.so.7 (0x40058000)
        libvorbisfile.so.3 => /usr/lib/libvorbisfile.so.3 (0x4008f000)
        libvorbis.so.0 => /usr/lib/libvorbis.so.0 (0x40097000)
        libogg.so.0 => /usr/lib/libogg.so.0 (0x400bf000)
        libstdc++.so.5 => /usr/lib/libstdc++.so.5 (0x400c4000)
        libm.so.6 => /lib/tls/libm.so.6 (0x40181000)
        libc.so.6 => /lib/tls/libc.so.6 (0x401a4000)
        libgcc_s.so.1 => /lib/libgcc_s.so.1 (0x402ba000)
        /lib/ld-linux.so.2 => /lib/ld-linux.so.2 (0x80000000)
       */
	bool has_flac_support();
	
	static bool getVersion(int *major, int *minor, int *patchlevel);

	/** return free disc space in MB or -1 if it fails */  
	long getFreeDiscSpace();

	/**  determine file type whith the unix program file. See "man file" */
	/**  return also true if file can't be executed */
	bool is_soundfile(QString fileName);

	bool overburn;
	bool tao;
	bool gracetime;
	bool driveropts;
	bool shorttrack;
	bool useinfo;
	bool dao;
	bool have_sox_resampler;
	bool flag_support;


private slots:
	void collect_std(KProcess*, char *stream, int a);
	void overb(KProcess*,char*,int);
	void processOut(KProcess*,char*,int);

private:

	QString str;
	QString out;
	QString over;
	QString process_out;
};

#endif
