/*  KRunning - CertificationEdit.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Okt 14 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "CertificationEdit.h"

CertificationEditor::CertificationEditor(QCanvas* c, QWidget* parent, const char* name, WFlags f) :  QCanvasView(c,parent,name,f) {

}


void CertificationEditor::clear() {
    QCanvasItemList list = canvas()->allItems();
    QCanvasItemList::Iterator it = list.begin();
    for (; it != list.end(); ++it) {
        if ( *it )
            delete *it;
    }
}

void CertificationEditor::contentsMousePressEvent(QMouseEvent* e)
{
    QPoint p = inverseWorldMatrix().map(e->pos());
    QCanvasItemList l=canvas()->collisions(p);
    for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it) {
        /*if ( (*it)->rtti() == 1 ) {
            ImageItem *item= (ImageItem*)(*it);
            if ( !item->hit( p ) )
        	 continue;
        } */
        moving = *it;
        moving_start = p;
        return;
    }
    moving = 0;
}


void CertificationEditor::contentsMouseMoveEvent(QMouseEvent* e)
{
    if ( moving ) {
        QPoint p = inverseWorldMatrix().map(e->pos());
        moving->moveBy(p.x() - moving_start.x(),
                       p.y() - moving_start.y());
        moving_start = p;
        canvas()->update();
    }
}


CertificationEdit::CertificationEdit(QCanvas* c, QWidget* parent, const char* name, WFlags f) :   QWidget(parent,name,f),   canvas(c) {
    QGridLayout* grid = new QGridLayout(parent, 4, 3, 1, 5, "grid" );

    QPushButton *save=new QPushButton(parent,"Text hinzufgen");
    save->setText("TEST");
    grid->addWidget(save,0,0);
    KFontCombo * font = new  KFontCombo (parent,"Font Chooser");
    grid->addWidget(font,0,1);
    editor = new CertificationEditor(canvas,parent);
    editor->setMinimumWidth(640);
    editor->setMinimumHeight(480);
    grid->addWidget(editor,1,0);
    clear();
    canvas->setBackgroundColor(QColor(255,255,255));
    QCanvasText* i = new QCanvasText(canvas);
    i->setText(prefs->getEventname());
    i->setFont(QFont("Arial",20));
    i->setColor( QColor(0,0,0) );
    //    i->setPen( QPen(QColor(rand()%32*8,rand()%32*8,rand()%32*8), 6) );
    i->move(canvas->width()/2,canvas->height()/2);
    i->setZ(1);
    i->show();
    addText(prefs->getSubEventname());
    addText(prefs->getEventLocation());
    addText(prefs->getEventDate().toString());

}


void CertificationEdit::addText(const QString &text) {
    QCanvasText* a = new QCanvasText(canvas);
    a->setText(text);
    a->setFont(QFont("Arial",20));
    a->move(20,20);
    a->show();
}


CertificationEdit::~CertificationEdit() {
}

void CertificationEdit::init() {
}

void CertificationEdit::clear() {
    editor->clear();
}

/*TODO: hsjdja*/
CertificationEditDialog::CertificationEditDialog(QWidget *parent, const char *name) :
KDialogBase( Plain, i18n("Certification Edit Dialog" ),  Ok|Cancel, Ok, parent,  name, true, true) {
    KPrinter *printer=new KPrinter();
    QPaintDeviceMetrics metrics=QPaintDeviceMetrics(printer);
    QFrame *page=plainPage();
    QCanvas *canvas = new QCanvas(metrics.width(),metrics.height());
    canvas->setAdvancePeriod(30);
    ceWidget = new CertificationEdit::CertificationEdit(canvas,page, "CertficationWidget");

    connect(this, SIGNAL(okClicked()), SLOT(ok()));
    delete (printer);
}

CertificationEditDialog::~CertificationEditDialog() {
    destroy();
}

void CertificationEditDialog::ok() {
}
