/*  KRunning - CreateTables.cpp
 *  Copyright (C) 2003 by Andreas Scherf
 *  Begin Mon Apr 14 2003 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "CreateTables.h"
#include "SQLiteConnection.h"
#include "PostgreSQLConnection.h"
#include <qtooltip.h>
#include <qwidgetstack.h> 
#include <iostream>
using namespace std;

CreateTables::CreateTables (QWidget * parent, const char *name) : CreateTablesGUI(parent,name,true) {
    connect (CancelButton,SIGNAL(clicked()),this,SLOT(slotQuit()));
    connect (OkButton,SIGNAL(clicked()),this,SLOT(slotOk()));
    connect (FileChooseButton,SIGNAL(clicked()),this,SLOT(slotChooseDatabaseFile()));
    connect (SelectButtonGroup,SIGNAL(clicked(int)),this,SLOT(slotSelectionChanged(int)));
    connect(DriverComboBox, SIGNAL(activated (const QString &)), SLOT(sqlDriverChanged(const QString &)));
    NewDbNameEdit->setText(i18n("NewDatabaseName"));

    m_pConfig = KGlobal::config();
    m_pConfig->setGroup("RecentFiles");
    
    m_lRecentFiles = m_pConfig->readListEntry("Files");
	checkRecentFiles();
    RecentFileCombo->insertStringList(m_lRecentFiles);

	if (m_lRecentFiles.isEmpty())
	{
		 slotSelectionChanged(3);
	}
	else
	{
		 slotSelectionChanged(2);
	}
    m_pConfig->setGroup( "Database" );

    DriverComboBox->insertStringList(DBConnection::getDriverList());
    DriverComboBox->insertItem("SQLITE");
    DriverComboBox->setCurrentText(m_pConfig->readEntry("Driver","SQLITE"));
    QToolTip::add(DriverComboBox,i18n("Select the database driver."));
    DriverTextLabel->setText(i18n("Sqlite the internal database."));

    UserNameEdit->setText(m_pConfig->readEntry( "Username",getenv( "USER" ) ));

    LocationEdit->setText(m_pConfig->readEntry( "Hostname","localhost" ));
    DatabaseNameEdit->setText( m_pConfig->readEntry( "Databasename","lauf" ));
    PortInput->setValue(m_pConfig->readEntry( "Port","5432" ).toInt());
    PasswordEdit->setText( QString(KCodecs::base64Decode(m_pConfig->readEntry( "Password","" ).latin1())));

    QToolTip::add (DatabaseNameEdit, i18n ("Enter the name of the database."));
    QToolTip::add (PortInput, i18n ("Enter the port number. Default is 5432."));
    QToolTip::add (LocationEdit, i18n ("Enter the location (i.e. localhost, IP, etc)."));
    QToolTip::add (UserNameEdit,i18n	("Enter your database username (i.e. root, blank, etc)."));
    QToolTip::add (PasswordEdit, i18n ("Enter your password if you have one."));

    m_sDriverName=getDriver();
	connectTextMessage->setText("Hello World\n");
    connectTextMessage->setReadOnly(true);
}

CreateTables::~CreateTables() {
}


void CreateTables::slotQuit() {
    this->close();

}
void CreateTables::sqlDriverChanged(const QString &name) {
    m_sDriverName=name;
    if (m_sDriverName.compare("SQLITE")==0) {
        widgetStack->raiseWidget(0);
        DriverTextLabel->setText(i18n("Sqlite the internal database."));
    } else {
        widgetStack->raiseWidget(1);
        DriverTextLabel->setText(i18n(name +" an external database driver."));
    }

}

void CreateTables::slotOk() {
    QString dbname;
    g_pMainUseCase->getConnection()->setDefaultDB(m_sDriverName); //Changed Jaap

    if (m_sDriverName.compare("SQLITE")==0) 
	{
		SQLiteConnection *pConnection=dynamic_cast<SQLiteConnection *>(g_pMainUseCase->getConnection());
		cerr << "SQLITE DB" << endl;
        if (RadioEmpty->isChecked()) 
		{
            m_sFilename=NewDbNameEdit->text();
            if (!m_sFilename.endsWith(".db") && !m_sFilename.endsWith(".DB")) {
                m_sFilename.append(".db");
            }
            dbname=QDir::currentDirPath()+'/'+m_sFilename;
			pConnection->setConnectionParameter( dbname);
            pConnection->connect();
            if (m_lRecentFiles.contains(dbname)==0) {
                m_lRecentFiles.append(dbname);
                m_pConfig->setGroup("RecentFiles");
                m_pConfig->writeEntry("Files",m_lRecentFiles);
                m_pConfig->sync();
            }
        }
        else if (RadioRecent->isChecked()) {
            m_sFilename=RecentFileCombo->currentText();
			cerr << "RECENT" << m_sFilename << endl;
			pConnection->setConnectionParameter(m_sFilename);
            pConnection->connect();
        }
        else if (RadioExisting->isChecked()) {
			pConnection->setConnectionParameter( m_sFilename);
            pConnection->connect();
        }
    } else {
		PostgreSQLConnection *pConnection = dynamic_cast<PostgreSQLConnection *>(g_pMainUseCase->getConnection());
        pConnection->setDefaultDB(  m_sDriverName );
		pConnection->setConnectionParameter( getName(),getUser(),getPasswd(),getLocation());
        pConnection->connect();
        connectTextMessage->setColor(QColor(255,0,0));
        connectTextMessage->append("WARNING !!\nCouldn't connect to "+getName()+" Database.");
        return;
    }
	if (g_pMainUseCase->getConnection()->isConnected()) {
            // store new settings ...
            KConfig* kc=KGlobal::config();
            kc->setGroup( "Database" );
            kc->writeEntry( "Databasename",getName() );
            kc->writeEntry( "Username",getUser() );
            kc->writeEntry( "Password",  KCodecs::base64Encode(getPasswd().latin1()).data())  ;
            kc->writeEntry( "Location", getLocation() );
            kc->writeEntry( "Port", getPort() );
            kc->writeEntry( "Driver", getDriver() );
            kc->sync();
        }
    this->accept();
}

void CreateTables::slotSelectionChanged(int num) {
    switch (num) 
	{
    	case 0:
			RadioExisting->setChecked(true);
			FileChooseButton->setEnabled(true);
			RecentFileCombo->setEnabled(false);
			NewDbNameEdit->setEnabled(false);
        break;
		case 2:
			RadioRecent->setChecked(true);
			FileChooseButton->setEnabled(false);
			RecentFileCombo->setEnabled(true);
			NewDbNameEdit->setEnabled(false);
        break;
		case 3:
			RadioEmpty->setChecked(true);
			FileChooseButton->setEnabled(false);
			RecentFileCombo->setEnabled(false);
			NewDbNameEdit->setEnabled(true);
			NewDbNameEdit->setFocus();
        break;
    }
}

/**
 * Removes none existant files from the recent file list.
 */
void CreateTables::checkRecentFiles()
{
	if (m_lRecentFiles.isEmpty()) return;

	for (QStringList::Iterator it = m_lRecentFiles.begin(); it != m_lRecentFiles.end();)
	{
		if (!QFile::exists((*it)))
		{
			it=m_lRecentFiles.remove(it);
		}
		else
		{
			++it;
		}
	}
	
}

void CreateTables::slotChooseDatabaseFile() {

    url=KFileDialog::getOpenURL(QDir::currentDirPath(),
                                i18n("*.db *.DB |SQLite files\n*|All files"), this, i18n("Load Database ..."));
    if (!url.isValid()) return;
    m_sFilename=url.directory()+'/'+url.fileName();
    DbNameLabel->setText(m_sFilename);
    if (m_lRecentFiles.contains(m_sFilename)==0) {
        m_lRecentFiles.append(m_sFilename);
        m_pConfig->setGroup("RecentFiles");
        m_pConfig->writeEntry("Files",m_lRecentFiles);
        m_pConfig->sync();
    }
}

// Interfaces
QString CreateTables::getDriver () const {
    return DriverComboBox->currentText();
}

/** Returns the name */
QString CreateTables::getName () const {
    QString result;
    if ( DriverComboBox->currentText()=="SQLITE") {
        result=QString();
    } else {
        result= DatabaseNameEdit->text();
    }
    return result;
}

/** Returns the location */
QString CreateTables::getLocation () const {
    return   LocationEdit->text ();
}

/** Returns the password. */
QString  CreateTables::getPasswd () const {
    return PasswordEdit->text ();
}

/** Returns the port */
QString CreateTables::getPort () const {
    return QString::number(PortInput->value ());
}

/** Returns the username. */
QString CreateTables::getUser () const {
    return UserNameEdit->text ();
}
