/*  KRunning - DBConnection.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Sam Mai 11 2002 write to scherfa@web.de if you found a bug.
 *
 *  Roll up between december 2006 and january 2007 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef DBCONNECTION_H
#define DBCONNECTION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#define DIALOG_MARGIN 15
#include <qsqldatabase.h>
#include <qsqlcursor.h>
#include <qvaluelist.h>
#include <qvaluevector.h>

// Settings & i18n
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include <kmdcodec.h> // Passwort decode DBConnection dialog -> better in Preferences ?
#include "DBObjects.h"

class DBConnection;



/** Main Class wich interacts between the KRunning Obj and a database (Postgres).
@author Andreas Scherf
@version 0.3
@short Layer between the database and the Objects
*/


class DBConnection 
{
public:
	enum DBConnectionType {
		eSQLiteIntern=0,
		ePostgreSQL,
		eSQLite,
		eMySQL,
		eUnknown
	};
	DBConnection();
	virtual ~DBConnection();
	void setDefaultDB(const QString &driver){m_sDBDriver=driver;}
	// void setDBParameters();
	virtual void connect ()=0;
	virtual void disconnect()=0;

	virtual bool isConnected() const{return m_bConnected;}

	virtual int query(KRunningObject *pObject,KRunningResultSet *pResultSet) = 0;

	bool testTables();
	bool createEmptyTables();

	DBConnectionType getDBType() const {return m_eDBType;}
	//
	virtual bool createInitialTable(KRunningTableObject* pTable)=0;
	virtual bool startTransaction()=0;
	virtual bool commitTransaction()=0;
	virtual bool rollbackTransaction()=0;

	static QStringList getDriverList();
	virtual QString getDBVersion()=0;
	QString getCountString(const QString & );
	virtual QString getDatabaseName()=0;
	virtual bool insertValues(KRunningObject *pKRunningObject)=0;
	virtual bool updateValues(KRunningObject *pKRunningObject,const QString& sFilter=QString::null)=0;
	virtual bool deleteValues(KRunningObject *pKRunningObject)=0;
	virtual QString getTableRows(const QString& sTablename)=0;

public:
		
	typedef QValueList<KRunningEventObject> EventList;
	typedef QValueList<KRunningTeamObject> TeamList;
	typedef QValueList<KRunningTimeObject> TimeList;
	typedef QValueList<KRunningRunnerObject> RunnerList;
	typedef QValueList<KRunningRunnerTimeObject> RunnerTimeList;


	// String Lists for Combo Boxes ...
	QStringList getTeamNameList();
	QStringList getEventNameList();
	// And the AutopCompletion
	QStringList getNameList(bool name);
	// Get all Startnumberframes
	QStringList getStartNumberFrames();

	// Lists
	RunnerList getRunnerListByEvent (int event,bool join);
	RunnerList getRunnerListByEventAndSex (int event,KRunningRunnerObject::SexNum sex);
	RunnerTimeList getRunnerTimeListByEvent (int event);
	TimeList getTimeListByEvent(int event);
	EventList getEventList();
	TeamList getTeamList();
	// Obj
	KRunningEventObject *getEventByNumber (int number);
	KRunningEventObject *getEventByStartnumber (long long nNumber);
	KRunningEventObject *getEventByName(const QString &name);
	
	KRunningTimeObject getTimeByNumber(int number);
	KRunningRunnerObject getRunnerByNumber (int number);
	QString getEventNameByNumber (int number);
	QString getTeamNameByNumber (int number);
	long long getTeamnumberByName (const QString &team);
	long long getEventnumberByName (const QString &event);

	// Delete
	bool deleteTimeByTimestring(const QString & time,int event);
	bool deleteTeamByString( const QString & team);
	// Checks
	bool checkIfRunnerInEvent(int runner,int event);
	bool checkIfRunnerHasTime(int  runner,int event);
	int testStartNumberFrame(QString & frame);
	
	protected:
	KRunningEventObject* getEvent(KRunningEventObject *pEvent);
	virtual long getTableCount()=0;
	bool m_bConnected;
	QString m_sDBName;
	private:

	QString m_sDBDriver;
	DBConnectionType m_eDBType;
};


class KRunningUseCase
{
public:
	KRunningUseCase();
	virtual ~KRunningUseCase();
	DBConnection * getConnection();
	KRunningEventObject *  getCurrentEvent(){return m_pCurrentEvent;}
    KConfig* getConfig(){return m_pKRunningConfig;}
	void setConfigGroup(const QString& sName){m_pKRunningConfig->setGroup( sName );}
	void setCurrentEvent(const QString &sName);
	bool isConnected();
private:
 	DBConnection * m_pDBConnection;
	KRunningEventObject * m_pCurrentEvent;
	KConfig* m_pKRunningConfig; 
};


extern KRunningUseCase *g_pMainUseCase;

#endif // DBCONNECTION_H
