//
// C++ Implementation: DBObjects
//
// Description: 
//
//
// Author: Andreas Scherf <scherfa@web.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "DBObjects.h"
#include "DBConnection.h"

KRunningObject::KRunningObject() : m_nNumber(0)
{
	m_pDBConnection=NULL;	
	setPrimaryKeyTableColumn( "number",QVariant::LongLong);
}

KRunningObject::KRunningObject(long nNumber):m_nNumber(nNumber)
{
	m_pDBConnection=NULL;	
	setPrimaryKeyTableColumn( "number",QVariant::LongLong);
}

KRunningObject::~KRunningObject()
{
}

DBConnection *KRunningObject::getConnection()
{
	if (!m_pDBConnection)
	{
		m_pDBConnection = g_pMainUseCase->getConnection();
	}
	return m_pDBConnection;
}

void KRunningObject::setValue(const QString& sColumnName,const QString& sValue)
{
    KRunningSqlField oColumn;
	oColumn.setName(sColumnName);
	oColumn.setType(QVariant::String);
	oColumn.setValue(sValue);
	m_vSqlFields.append(oColumn);
}

void KRunningObject::setValue(const QString& sColumnName,long long nValue)
{
	KRunningSqlField oColumn;
	oColumn.setName(sColumnName);
	oColumn.setType( QVariant::LongLong );
	oColumn.setValue(nValue);
	m_vSqlFields.append(oColumn);
}

void KRunningObject::setValue(const QString& sColumnName,long nValue)
{
	KRunningSqlField oColumn;
	oColumn.setName(sColumnName);
	oColumn.setType( QVariant::LongLong );
	oColumn.setValue((long long)nValue);
	m_vSqlFields.append(oColumn);
}

void KRunningObject::setValue(const QString& sColumnName,int nValue)
{
	KRunningSqlField oColumn;
	oColumn.setName(sColumnName);
	oColumn.setType( QVariant::Int );
	oColumn.setValue(nValue);
	m_vSqlFields.append(oColumn);
}	

void KRunningObject::setValue(const QString& sColumnName,const QDate& oValue)
{
	KRunningSqlField oColumn;
	oColumn.setName(sColumnName);
	oColumn.setType( QVariant::Date );
	oColumn.setValue(oValue);
	m_vSqlFields.append(oColumn);
}


KRunningSqlField::KRunningSqlField() :	m_bPrimaryKey(false),m_bUnique(false),m_bHeader(false),m_bDistinct(false),m_vType ( QVariant::Invalid)
{
}

KRunningSqlField::~KRunningSqlField()
{
}

/**
 * Kopierkonstruktor 
 * @param column 
 * @return 
 */
KRunningSqlField::KRunningSqlField (const KRunningSqlField & column)
{
	m_sName = column.m_sName;
	m_sReference = column.m_sReference;
	m_vType = column.m_vType;
	m_bPrimaryKey= column.m_bPrimaryKey;
	m_bUnique=column.m_bUnique;
	m_vValue=column.m_vValue;
	m_bHeader=column.m_bHeader;
	m_bDistinct=column.m_bDistinct;
}

KRunningSqlField& KRunningSqlField::operator=(const KRunningSqlField& column)
{
	if (this == &column) return *this;
	m_sName = column.m_sName;
	m_sReference = column.m_sReference;
	m_vType = column.m_vType;
	m_bPrimaryKey= column.m_bPrimaryKey;
	m_bUnique=column.m_bUnique;
	m_vValue=column.m_vValue;
	m_bHeader=column.m_bHeader;
	m_bDistinct=column.m_bDistinct;
	return (*this);
}

KRunningResultSet::KRunningResultSet()
{
	m_nRows = 0;
	m_nColumns = 0;
}

KRunningResultSet::~KRunningResultSet()
{
}

bool KRunningResultSet::setValue( long nRow, const QString& sColumn, QVariant vValue)
{
	
	bool bReturn = false;
	QString sKey = QString (sColumn+":%1").arg(nRow);
	// Check for Key to prevent duplikate keys 
	if (m_mapResultSet[sKey].isNull())
	{
		m_mapResultSet[sKey]=vValue;
		bReturn = true;
	}
	return bReturn;
}

QVariant KRunningResultSet::getValue( long nRow,const QString& sColumn)
{
	QString sKey = QString (sColumn+":%1").arg(nRow);
	return m_mapResultSet[sKey];
}

KRunningTableObject::KRunningTableObject() : m_bAutoIndex(true) , m_cTableAlias('a')
{
	m_lReferenceTables.clear();
	m_vSqlFields.clear();
}

KRunningTableObject::~KRunningTableObject()
{
	m_vSqlFields.clear();
}

void KRunningTableObject::setPrimaryKeyTableColumn(const QString& sColumnName,QVariant::Type vType)
{
	KRunningSqlField column;
	column.setName( sColumnName );
	column.setType( vType );
	column.setPrimaryKey( true );
	column.setHeader(true);
	m_vSqlFields.append(column);
}

void KRunningTableObject::setUniqueTableColumn(const QString& sColumnName,QVariant::Type vType)
{
	KRunningSqlField column;
	column.setName( sColumnName );
	column.setUnique( true );
	column.setType( vType );
	column.setHeader(true);
	m_vSqlFields.append(column);
}

void KRunningTableObject::setTableColumn(const QString& sColumnName,QVariant::Type vType)
{
/*
QSqlFieldInfo ( const QString & name = QString::null, QVariant::Type typ = QVariant::Invalid, int required = -1, int len = -1, int prec = -1, const QVariant & defValue = QVariant ( ), int typeID = 0, bool generated = TRUE, bool trim = FALSE, bool calculated = FALSE )
*/
	KRunningSqlField column;
	column.setName(sColumnName);
	column.setType(vType);
	column.setHeader(true);
	m_vSqlFields.append(column);
}

void KRunningTableObject::setTableReference(const QString& sColumnName,const QString& sReferenceTable,QVariant::Type vType)
{
	KRunningSqlField column;
	column.setName( sColumnName);
	column.setType( vType);
	column.setReferenceTable( sReferenceTable);
	column.setValue( QVariant::Invalid);
	column.setHeader(true);
	m_vSqlFields.append(column);
}

void KRunningTableObject::setTableReference( KRunningTableObject * const pTable)
{
	pTable->setTableAlias();
	m_lReferenceTables.append(pTable);
}

void KRunningTableObject::setTableAlias()
{
	ushort nAlias=m_cTableAlias;
	nAlias++;
	m_cTableAlias=(QChar)nAlias;
}

KRunningSqlField *KRunningTableObject::getField( const QString& sName) 
{
	for (uint i=0; i < m_vSqlFields.count(); ++i)
	{
		if (m_vSqlFields[i].getName() == sName)
		{
			return &m_vSqlFields[i];
		}
	}
	return NULL;
}

KRunningSqlField *KRunningTableObject::getField( uint i )
{
	
	if (i <= m_vSqlFields.count())
	{
		return &m_vSqlFields[i];
	}

	return NULL;
}



void KRunningTableObject::addOrderIndex( const QString& sFieldName,bool desc)
{
	m_lOrder.append(getField( sFieldName ));
	m_lbSort.append(desc);
}

void KRunningTableObject::addWhereIndex( const QString &sFieldName,const QVariant& vValue)
{
	KRunningSqlField *pField=getField(sFieldName);
	
	if (pField);
	{
		pField->setValue(vValue);
		m_lWhere.append(pField);
	}
}

void KRunningTableObject::addSelectIndex(const QString &sFieldName,bool bDistinct)
{
	KRunningSqlField *pField=getField(sFieldName);
	if (pField)
	{
		pField->setDistinct( bDistinct);
		m_lSelect.append(pField);
	}
}

QString KRunningTableObject::getTableName()
{
	QString sResult;
	if (hasTableReferences())
	{
		sResult = m_sTableName;
		KRunningTableObject *pReferenceTable=NULL;
    	for ( pReferenceTable = m_lReferenceTables.first(); pReferenceTable; pReferenceTable = m_lReferenceTables.next() )
		{
			sResult+=" ,"+pReferenceTable->getTableName();
		}
	}
	else
	{
		sResult = m_sTableName;
	}
	return sResult;
}

KRunningTableObject *KRunningTableObject::getTableReference(const QString& sName)
{
	for (KRunningTableObject *pReferenceTable = m_lReferenceTables.first(); pReferenceTable; pReferenceTable = m_lReferenceTables.next() )
	{
		if (QString::compare(pReferenceTable->getTableName().lower(), sName.lower())==0)
		{
			return pReferenceTable;
		}
	}
	return NULL;
}

QString KRunningTableObject::toFromString(const QString& sep)
{
	QString sResult=m_sTableName+" "+m_cTableAlias;
	
	if (hasTableReferences())
	{
		KRunningTableObject *pReferenceTable=NULL;
    	for ( pReferenceTable = m_lReferenceTables.first(); pReferenceTable; pReferenceTable = m_lReferenceTables.next() )
		{
			sResult+=sep+" "+pReferenceTable->toFromString( );
		}
	}
	return sResult;
}

QString KRunningTableObject::toWhereString(const QString & prefix,const QString& sep)
{
	QString pflist;
	QString pfix=prefix.isEmpty() ? m_cTableAlias+'.' : prefix+".";
	bool bComma = false;

	if (m_lWhere.isEmpty()) return QString();
 
	if (hasTableReferences())
	{
		for (uint i=0; i < m_vSqlFields.count(); ++i)
		{
			QString sReferenceTable = m_vSqlFields[i].getReferenceTable();
			KRunningTableObject *pReferenceTable=getTableReference(sReferenceTable);
			if (!sReferenceTable.isEmpty() && pReferenceTable)
			{			
				pflist+=  QString(getTableAlias())+"."+m_vSqlFields[i].getName()+" = "+QString(pReferenceTable->getTableAlias())+".number AND ";
			}
    	}	
	}

	QValueList<const KRunningSqlField*>::iterator it;
    for ( it = m_lWhere.begin(); it != m_lWhere.end(); ++it )
    {    
		const QString sName = (*it)->getName();
		const QVariant vValue = (*it)->getValue();
		QString sValue;
		switch (vValue.type())
		{
			case  QVariant::String :
			sValue = "'"+vValue.toString()+"'";
			break;
			default:
			sValue = vValue.toString();
			break;
		}
		
	
		if (bComma)
		{
			pflist += sep + " ";
		}
		
		pflist += pfix + sName + " = " +sValue;
		bComma = true;		
	}
	return pflist;
}

QString KRunningTableObject::toOrderString(const QString & prefix,const QString& sep)
{
	QString pflist;
	QString pfix=prefix.isEmpty() ? m_cTableAlias+'.': prefix+".";
	bool bComma = false;

	if (m_lOrder.isEmpty()) return QString();

	QValueList<const KRunningSqlField*>::iterator it;
    for ( it = m_lOrder.begin(); it != m_lOrder.end(); ++it )
    {
		const QString fname = (*it)->getName();
			if (bComma)
			{
				pflist += sep + " ";
			}
			
			pflist += pfix + fname;
			bComma = true;		
	}
	return pflist;
}


QString KRunningTableObject::toIndexString(const QString & prefix,const QString& sep)
{
	QString sResult;
	QString pfix=prefix.isEmpty() ? QString::null : prefix+".";
	bool bComma = false;
	
	if (m_lSelect.isEmpty() && m_vSqlFields.isEmpty()) return QString();
	if (!m_lSelect.isEmpty())
	{
		QValueList<const KRunningSqlField*>::iterator it;
    	for ( it = m_lSelect.begin(); it != m_lSelect.end(); ++it )
   		{
			if (bComma)
			{
				sResult += sep + " ";
			}
			
			if ((*it)->isDistinct())
			{
				sResult+=" distinct ";
			}
			sResult+=QString("%1.%2").arg(m_cTableAlias).arg((*it)->getName());
			bComma = true;	
		}
	}
	else
	{	
		KRunningSqlFields::iterator it;
		for( it = m_vSqlFields.begin(); it != m_vSqlFields.end(); ++it )
		{	
			if (bComma)
			{
				sResult += sep + " ";
			}
			
			if ((*it).isDistinct())
			{
				sResult+=" distinct ";
			}
			
			QString sReferenceTable = (*it).getReferenceTable();
			if (sReferenceTable.isEmpty())
			{
				sResult+=QString("%1.%2").arg(m_cTableAlias).arg((*it).getName());
			}
			else
			{
				sResult+=QString("%1.%2").arg(m_cTableAlias).arg((*it).getName());
				KRunningTableObject *pTableObject=getTableReference(sReferenceTable);
				if (pTableObject)
				{
					sResult+=", "+pTableObject->toIndexString();
				}
				
			}
			bComma = true;
		}		
	}
	return sResult;
}

KRunningSqlFields KRunningTableObject::getHeaderVector()
{
	KRunningSqlFields vReturn;
	KRunningSqlFields::iterator it;
    for( it = m_vSqlFields.begin(); it != m_vSqlFields.end(); ++it )
	{	
		if ((*it).isHeader())
		{
			vReturn.append(*it);
		}
	}
	return vReturn;
}

void KRunningTableObject::clear()
{
	m_sTableName="";
	m_vSqlFields.clear();
}


/**
 * 
 * @return TRUE if save was sucessfull 
 */
bool KRunningObject::save ()
{
	onFillValues();
	return getConnection()->insertValues(this);
}

/**
 * 
 * @return TRUE if update was sucessfull
 */
bool KRunningObject::update()
{
	onFillValues();
	return getConnection()->updateValues(this);
}

KRunningRaceObject::KRunningRaceObject() : KRunningObject()
{
	setTableName("races");

	setTableColumn("racename",QVariant::String);
	setTableColumn("subname",QVariant::String);
	setTableColumn("location",QVariant::String);
	setTableColumn("organisation",QVariant::String);
	setTableColumn("date",QVariant::Date);
}

KRunningRaceObject::~KRunningRaceObject()
{
}

void KRunningRaceObject::onClear()
{
}

void KRunningRaceObject::onFillValues() 
{
	if (g_pMainUseCase->isConnected()) 
    {
		setValue("racename",m_sName);
		setValue("subname", m_sSubName);
		setValue("location", m_sLocation);
		setValue("organisation",m_sOrganisation);
		setValue("date",m_oDate);
	}
}

KRunningEventObject::KRunningEventObject() : KRunningObject()
{
	setTableName("events");	
	
	setTableColumn( "eventname",QVariant::String);
	setTableColumn( "startnumberframes",QVariant::String);
	setTableColumn( "starttime_0",QVariant::String);
	setTableColumn( "starttime_1",QVariant::String);
	setTableColumn( "distance",QVariant::Int);
	setTableColumn( "document",QVariant::Int);
}

KRunningEventObject::~KRunningEventObject()
{
}

void KRunningEventObject::onClear()
{
	m_nDistance=0;
}


void KRunningEventObject::onFillValues() 
{
    if (g_pMainUseCase->isConnected()) 
    {
        /*if (g_pMainUseCase->getDBType()==DBConnection::eSQLite) {
            if (bUpdate) {
                sqlite_exec_printf(g_pMainUseCase->getSQLiteDB(), "UPDATE events SET eventname='%q',startnumberframes='%q',starttime_0='%q',distance=%d WHERE number=%d" , 0, 0, 0,name.latin1(),startnumberframes.latin1(),starttime.toString("hh:mm:ss.zzz" ).latin1(),distance,number);
                return TRUE;
            }  else {
                sqlite_exec_printf(g_pMainUseCase->getSQLiteDB(),
                                   "INSERT INTO events (number,eventname,startnumberframes,starttime_0,distance) VALUES(NULL,'%q','%q','%q',%d)",
                                   0, 0, &zErrMsg, name.latin1(),startnumberframes.latin1(),starttime.toString("hh:mm:ss.zzz" ).latin1(),distance);
                number=sqlite_last_insert_rowid(g_pMainUseCase->getSQLiteDB());
                return TRUE;
            } // UPDATE
        } else {
            QSqlCursor cur( "events" );
            QSqlRecord *buffer;
            if (bUpdate) {
                cur.select(QString("number='%1'").arg(number));
                cur.next();
                buffer=cur.primeUpdate();
            } else {
                buffer=cur.primeInsert();
                QSqlQuery q( "select nextval('events_number_seq');" );
                if ( q.next() ) {
                    buffer->setValue( "number", q.value(0) );
                    number=q.value(0).toInt();
                }
            }*/
	
		setValue( "eventname", m_sName );
		setValue( "startnumberframes", m_sStartnumberframes);
		setValue( "starttime_0", m_tStarttime.toString("hh:mm:ss.zzz" ));
		setValue( "distance", m_nDistance );
            /*if (bUpdate) {
                cur.update();
            }  else   {
                cur.insert();
                //               cerr <<        cur.lastQuery() << endl;
            }*/ //UPDATE
    }
}



QString KRunningEventObject::getDistanceString(DistanceUnit nUnit)
{
    QString sReturn;
    
	if (nUnit == eUndefined)
	{
		nUnit = m_nUnit;
	}
	
    switch (nUnit)
    {
    case eKilometers:
        sReturn="km";
        break;
    case eMeters:
        sReturn ="m";
        break;
    case eMiles:
        sReturn ="miles";
        break;
    default:
        sReturn ="km";
        break;
    }
    return sReturn;
}
KRunningTeamObject::KRunningTeamObject() : KRunningObject()
{
	setTableName("teams");
	setUniqueTableColumn( "teamname",QVariant::String);
}


KRunningTeamObject::~KRunningTeamObject()
{
}

void KRunningTeamObject::onClear()
{
}

void  KRunningTeamObject::onFillValues()
{
    if (g_pMainUseCase->isConnected()) 
	{
		setValue("teamname",m_sTeamname);	
    }
}

KRunningRunnerObject::KRunningRunnerObject() : KRunningObject()
{
	setTableName("runner");
	setAutoIndex( false );
	setTableColumn( "surname",QVariant::String);
	setTableColumn( "forename",QVariant::String);
	setTableColumn( "birthday",QVariant::LongLong);
	setTableColumn( "sex",QVariant::Int);
	setTableReference( "event","events",QVariant::LongLong); // Referenz !! event REFERENCES events(number)
	setTableReference( "team","teams",QVariant::LongLong); // Referenz !! team REFERENCES teams(number) MATCH PARTIAL
	setTableColumn( "street",QVariant::String);
	setTableColumn( "city",QVariant::String);
	setTableColumn( "plz",QVariant::Int);
	setTableColumn( "nation",QVariant::String);
	setTableColumn( "chipnum",QVariant::String);
	setTableColumn( "state",QVariant::LongLong);
	setTableColumn( "comment",QVariant::String);
	setTableColumn( "place_total",QVariant::LongLong);
	setTableColumn( "place_class",QVariant::LongLong);
	setTableColumn( "place_sex",QVariant::LongLong);
	setTableColumn( "place_team",QVariant::LongLong);
	setTableColumn( "place_nation",QVariant::LongLong);
	onClear();
}

void KRunningRunnerObject::onClear()
{
	m_nBirthday=0;
	sex=eUndefined;
	m_nEvent=0;
	m_nTeam=0;
	m_nPLZ=0;
	placetotal=0;
	placeclass=0;
	placesex=0;
	placeteam=0;
	placenation=0;
	m_nNewnumber=0;
}

KRunningRunnerObject::~KRunningRunnerObject()
{
}

void KRunningRunnerObject::onFillValues()
{
    if (g_pMainUseCase->isConnected()) {
		
		setValue("number", m_nNumber );
		setValue("surname",m_sSurname);
		setValue("forename",m_sForename);
		setValue("birthday",m_nBirthday);
		setValue("sex",sex);
		setValue("event",m_nEvent);
		setValue("team",m_nTeam);
		setValue("street",m_sStreet);
		setValue("city",m_sCity);
		setValue("plz",m_nPLZ);
		setValue("nation",m_sNation);
		setValue("chipnum",m_sChipID);
		setValue("state",state);
		setValue("comment",m_sComment);
		setValue("place_total",placetotal);
		setValue("place_class",placeclass);
		setValue("place_sex",placesex);
		setValue("place_team",placeteam);
		setValue("place_nation",placenation);
    }
}

/** < for sort functions ...
*/
bool operator<(KRunningRunnerObject &a,KRunningRunnerObject &b) 
{
	bool bReturn = false;	   
 	if ( b.getBirthday() < a.getBirthday() )
	{
		bReturn= true;
	}
	return bReturn;
}

KRunningTimeObject::KRunningTimeObject() : KRunningObject()
{
	setTableName("times");
	setTableReference("event","events",QVariant::LongLong); // Referenz !!
	setTableColumn( "time",QVariant::String);	
	onClear();
}

void KRunningTimeObject::onClear()
{
	m_nEventRef=0;
}

KRunningTimeObject::~KRunningTimeObject()
{
}

void KRunningTimeObject::onFillValues()
{
    if (g_pMainUseCase->isConnected()) 
	{
		setValue("time",getTimeString("hh:mm:ss.zzz"));
		setValue("event",m_nEventRef);
    }
}



QString KRunningTimeObject::getTimeString(const QString &ts) {
    return m_oTime.toString(ts );// Global TIMESTRING ??
}

/** < for sort functions ...
*/
bool operator<(KRunningTimeObject &a,KRunningTimeObject &b) {
    if (a.getTime()<b.getTime()) return true;
    else return false;
}
KRunningRunnerTimeObject::KRunningRunnerTimeObject() : KRunningObject()
{
	setTableName( "runnertimes");
	
	setTableReference( "runner","runner",QVariant::LongLong); // Referenz !! 
	setTableReference( "event","events",QVariant::LongLong); // Referenz !! 
	setTableReference( "time","times",QVariant::LongLong); // Referenz 
	onClear();
}

void KRunningRunnerTimeObject::onClear()
{
	m_nEventRef=0;
	m_nRunnerRef=0;	
	m_nTimeRef=0;
}

void KRunningRunnerTimeObject::onFillValues()
{
    if (g_pMainUseCase->isConnected()) 
	{
		setValue("event",m_nEventRef);
        setValue("runner",m_nRunnerRef);	
		setValue("time",m_nTimeRef);
	}
}


void KRunningDocumentObject::onFillValues()
{
   
    if (g_pMainUseCase->isConnected()) {
       /* if (g_pMainUseCase->getDBType()==DBConnection::eSQLite) {
            if (update) {
                sqlite_exec_printf(g_pMainUseCase->getSQLiteDB(), "UPDATE documents SET name='%q' ,size='%q' WHERE number=%d" , 0, 0, 0,name.latin1(),size.latin1(),number);
                return TRUE;
            }  else {
                sqlite_exec_printf(g_pMainUseCase->getSQLiteDB(),
                                   "INSERT INTO documents (number,name,size) VALUES(NULL,'%q','%q')",
                                   0, 0, &zErrMsg, name.latin1(),size.latin1());
                number=sqlite_last_insert_rowid(g_pMainUseCase->getSQLiteDB());
                cerr << zErrMsg << endl;
                return TRUE;
            } // UPDATE
        } else {
            QSqlCursor cur( "documents" );
            QSqlRecord *buffer;
            if (update) {
                cur.select(QString("number='%1'").arg(number));
                cur.next();
                buffer=cur.primeUpdate();
            } else {
                buffer=cur.primeInsert();
                QSqlQuery q( "select nextval('documents_number_seq');" );
                if ( q.next() ) {
                    buffer->setValue( "number", q.value(0) );
                    number=q.value(0).toInt();
                }
            }
            buffer->setValue( "name", name );
            buffer->setValue( "size", size );
            if (update) {
                cur.update();
            }  else   {
                cur.insert();
                //               cerr <<        cur.lastQuery() << endl;
            } //UPDATE
            return TRUE;
        }*/
    }
}


void KRunningDocumentFrameObject::onFillValues()
{
    if (g_pMainUseCase->isConnected()) {
      /*  if (g_pMainUseCase->getDBType()==DBConnection::eSQLite) {
            sqlite_exec_printf(g_pMainUseCase->getSQLiteDB(), "INSERT INTO documentframes (number,document,frame) VALUES(NULL,%d,%d,%d)",  0, 0, 0, document,frame);
            number=sqlite_last_insert_rowid(g_pMainUseCase->getSQLiteDB());
            return TRUE;
        } else {
            QSqlCursor cur("documentframes");
            QSqlRecord * buffer=cur.primeInsert();
            QSqlQuery q("select nextval('documentframes_number_seq');");
            if (q.next() ) {
                buffer->setValue("number",q.value(0));
                number=q.value(0).toInt();
            }
            buffer->setValue("document",document);
            buffer->setValue("frame",frame);
            cur.insert();
            return TRUE;
        }      */     }
}
