//
// C++ Interface: DBObjects
//
// Description: 
//
//
// Author: Andreas Scherf <scherfa@web.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KRUNNING_DBOBJECTS_H
#define KRUNNING_DBOBJECTS_H

/**
	@author Andreas Scherf <scherfa@web.de>
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qvaluevector.h>
#include <qsqldatabase.h>
#include <kglobal.h>
#include <qdatetime.h>
class DBConnection;
class KRunningUseCase;
/** KRunningObject
@short Main KRunning Object Class ...
*/

class KRunningSqlField 
{
	public:
	KRunningSqlField();
	virtual ~KRunningSqlField ();
	KRunningSqlField (const KRunningSqlField & column);
	KRunningSqlField& operator=(const KRunningSqlField& column);
	// set
	void setName(const QString& sName){m_sName=sName;}
	void setType(QVariant::Type vType){m_vType=vType;}
	void setPrimaryKey(bool bPrimaryKey=true){m_bPrimaryKey=bPrimaryKey;}
	void setUnique(bool bUnique=true){m_bUnique=bUnique;}
	void setReferenceTable(const QString& sReference){m_sReference=sReference;}	
	void setValue(const QVariant& vValue){m_vValue=vValue;}
	void setHeader(bool bHeader){m_bHeader=bHeader;}
	void setDistinct(bool bDistinct=true){m_bDistinct=bDistinct;}

	// get
	QString getName() const {return m_sName;}
	QVariant::Type getType() const {return m_vType;}
	bool isPrimaryKey() const {return m_bPrimaryKey;}
	bool isUnique() const {return m_bUnique;}
	QString getReferenceTable() const {return m_sReference;}
	QVariant getValue() const {return m_vValue;}
	bool isHeader() const {return m_bHeader;}
	bool isDistinct() const {return m_bDistinct;}

	private:
	QString m_sName,m_sReference;
	bool m_bPrimaryKey;
	bool m_bUnique;	
	bool m_bHeader;
	bool m_bDistinct;
	QVariant::Type m_vType;
	QVariant m_vValue;
};


class KRunningSqlIndex;


typedef QValueVector<KRunningSqlField> KRunningSqlFields;

//TODO Refactoring Index && ...
class KRunningTableObject 
{
	public:
	KRunningTableObject();
	virtual ~KRunningTableObject();
	virtual void clear();
	void setUniqueTableColumn(const QString& sColumnName,QVariant::Type vType=QVariant::Invalid);
	void setPrimaryKeyTableColumn(const QString& sColumnName,QVariant::Type vType=QVariant::Invalid);
	void setTableColumn(const QString& sColumnName,QVariant::Type vType=QVariant::Invalid);
	void setTableReference(const QString& sColumnName,const QString& sReferenceTable,QVariant::Type vType=QVariant::Invalid);
	void setTableReference(KRunningTableObject *const pTable);
	KRunningTableObject *getTableReference(const QString& sName);
	bool hasTableReferences(){return m_lReferenceTables.isEmpty() ?  false : true;}
	KRunningSqlFields& getFields(){return m_vSqlFields;}
	KRunningSqlFields getHeaderVector();
	QString getTableName();
	void setTableName(const QString& sName){m_sTableName=sName;}
	bool getAutoIndex(){return m_bAutoIndex;}
	KRunningSqlField *getField( const QString& sName);
	KRunningSqlField *getField( uint i);
	QString toString(const QString& pre=QString::null,const QString& sep=",");
	void addOrderIndex( const QString& sFieldName,bool desc=false);
	void addWhereIndex( const QString& sFieldName ,const QVariant& vValue=QVariant::Invalid);
	void addSelectIndex(const QString& sFieldName,bool distinct=false);

	QString toFromString(const QString& sep=",");
	QString toIndexString(const QString & prefix=QString::null,const QString& sep=",");
	QString toOrderString(const QString & prefix=QString::null,const QString& sep=",");
	QString toWhereString(const QString & prefix=QString::null,const QString& sep=" AND ");

	uint count() const {return m_vSqlFields.count();}
	bool isDescending(int i) const;
	void setDescending(int i,bool desc);
	protected:
	void setAutoIndex(bool bAutoIndex=true){m_bAutoIndex=bAutoIndex;}
	void setTableAlias();
	QChar getTableAlias(){return m_cTableAlias;}
	KRunningSqlFields m_vSqlFields;
	
	QValueList<bool> m_lbSort;	
	private:
	QString m_sTableName;
	bool m_bAutoIndex;

	QValueList<const KRunningSqlField*> m_lOrder;
	QValueList<const KRunningSqlField*> m_lWhere;
	QValueList<const KRunningSqlField*> m_lSelect;
	QValueList<const KRunningSqlField*> m_lIndex;
	QPtrList <KRunningTableObject> m_lReferenceTables;
	QChar m_cTableAlias;
};

class KRunningSqlIndex 
{	
	public:
	KRunningSqlIndex();
	virtual ~KRunningSqlIndex();
	void setName(const QString& sName){m_sName=sName;}
	KRunningSqlIndex(const KRunningSqlIndex& other);

	void append(const KRunningSqlField& field);
	void append(const KRunningSqlField& field,bool desc);
	bool isDescending(int i) const;
	void setDescending(int i,bool desc);
	QString toString(const QString& prefix=QString::null,const QString& sep=",")const;
	QStringList toStringList(const QString& prefix=QString::null,const QString& sep=",")const;
	static KRunningSqlIndex fromStringList(const QStringList& l);
	bool isEmpty() const {return m_sName.isEmpty();}
	void appendValue(const QVariant& vValue);
	protected:
	QString createField(int i,const QString& prefix) const;
	private:
	QString m_sName;
	//QValueList<bool> m_lbSort;
	QValueList<QVariant> m_lvValues;
};

class KRunningResultSet
{
public:
	KRunningResultSet();
	virtual ~KRunningResultSet();
	void setRows(long long nRows){m_nRows=nRows;}
	void setColumns(long long nColumns){m_nColumns=nColumns;}
	long long getRows(){return m_nRows;}
	long long getColumns() {return m_nColumns;}
	bool setValue(long nRow,const QString& sColumn,QVariant vValue);
	QVariant getValue(long nRow,const QString& sColumn);
	bool isEmpty(){return (m_mapResultSet.isEmpty());}
private:
	long long m_nRows;
	long long m_nColumns;
	QMap<QString,QVariant> m_mapResultSet;
};

class KRunningObject : public KRunningTableObject
{
public:
	KRunningObject();
	KRunningObject(long nNumber);
	virtual ~KRunningObject();
	virtual bool save ();
	virtual bool update();
	
	// set
	void setNumber(long nNumber){m_nNumber=nNumber;}
	void setValue(const QString& sColumnName,const QString& sValue);
	void setValue(const QString& sColumnName,const QDate& oValue);
	void setValue(const QString& sColumnName,long long nValue);
	void setValue(const QString& sColumnName,long nValue);
	void setValue(const QString& sColumnName,int nValue);
	// get
	long getNumber() const {return m_nNumber;}	

protected:
	long m_nNumber;
	DBConnection * getConnection();
	virtual void onClear()=0;
	virtual void onFillValues()=0;
private:
	DBConnection * m_pDBConnection;
};


class KRunningRaceObject : public KRunningObject
{
public:
	KRunningRaceObject();
	~KRunningRaceObject();
	void setName(const QString& sName){m_sName=sName;}
	void setSubName(const QString& sSubName){m_sSubName=sSubName;}
	void setLocation(const QString& sLocation){m_sLocation=sLocation;}
	void setOrganisation(const QString& sOrganisation){m_sOrganisation=sOrganisation;}
	void setDate(const QDate& oDate){m_oDate=oDate;}
protected:
	virtual void onFillValues();
	virtual void onClear();
private:
	QString m_sName;
	QString m_sSubName;
	QString m_sLocation;
	QString m_sOrganisation;
	QDate m_oDate;
};

/** KRunningEventObject
@short Stores an event object
*/

class KRunningEventObject : public KRunningObject
{
	public:
	enum DistanceUnit 
	{
		eKilometers=0,
		eMeters,
		eMiles,
		eUndefined
	};

	KRunningEventObject();
	// KRunningEventObject( long num,const QString& nm , const QString &snf,QTime stime,int dist );
	virtual ~KRunningEventObject();
	QString getName() const { return m_sName; }
	QTime getEventStarttime() const {return m_tStarttime;}
	int getEventDistance() const {return m_nDistance;}
	QString getStartnumberFrames() const {return m_sStartnumberframes;}
	DistanceUnit getDistanceUnit() const {return m_nUnit;}
	QString getDistanceString(DistanceUnit unit=eUndefined);
	QString getEventStartTime (const QString &format) const {return m_tStarttime.toString(format);}
	void addStartNumberFrame(const QString &frame) {m_sStartnumberframes.append(frame+';');}
	void setStartNumberFrame(const QString &frame) { m_sStartnumberframes=frame; }
	void setDistance(int nDistance) {m_nDistance=nDistance;}
	void setName(const QString &sName){m_sName=sName;}
	void setStartTime(const QTime &time){m_tStarttime=time;}
	void setDistanceUnit(DistanceUnit eUnit){m_nUnit=eUnit;}
protected:
	virtual void onClear();
	virtual void onFillValues();
private:
	QString m_sName;
	QString m_sStartnumberframes;
	QTime m_tStarttime;
	int m_nDistance;
	DistanceUnit m_nUnit;
};

/**
@short Stores a team object
*/

class KRunningTeamObject : public KRunningObject
{
public:
	KRunningTeamObject();
	virtual ~KRunningTeamObject();
	QString getName() const {return m_sTeamname;}
	void setName(const QString& sName){m_sTeamname=sName;}
protected:
	virtual void onClear();
	virtual void onFillValues();
private:
	QString m_sTeamname;
};
//number int primary key, surname text,forename text,birthday int2,sex int2,
//event int references events,team int references teams,street text,city text,
//plz int, chipnum text, state int2,place_total int2,place_class int2, place_sex int2, place_team int2,place_nation int2)");
class KRunningRunnerObject : public KRunningObject{
    public:
        enum SexNum {
            eMale=0,
            eFemale,
            eUndefined
    };
        enum StateNum {
            eCreated=0,
            eEvaluated,
            eReady
    	};
        KRunningRunnerObject();
		virtual ~KRunningRunnerObject();

		// get
        SexNum getSex() const { return sex; }
        long getBirthday() const { return m_nBirthday; }
        long getEvent() const {return m_nEvent;}
        long getTeam() const {return m_nTeam;}
        int getPLZ() const {return m_nPLZ;}
        QString getCity() const {return m_sCity;}
        QString getStreet() const {return m_sStreet;}
        QString getNation() const {return m_sNation;}
        StateNum getState() const {return state;}
        QString getTeamname() const {return m_sTeamname;}
        QString getSurname() const {return m_sSurname;}
        QString getForename() const {return m_sForename;}
        QString getComment() const {return m_sComment;}
		//set
        void setSex(SexNum nSex) {sex=nSex;}
        void setBirthday(long nBirthday){m_nBirthday=nBirthday;}
        void setEvent(long nEvent) {m_nEvent=nEvent;}
        void setTeam(long nTeam)  {m_nTeam=nTeam;}
        void setPLZ(int nPLZ) {m_nPLZ=nPLZ;}
        void setCity(const QString& sCity ) {m_sCity=sCity;}
        void setStreet(const QString& sStreet) {m_sStreet=sStreet;}
        void setNation(const QString& sNation) {m_sNation=sNation;}
        void setState(StateNum num) {state=num;}
        void setTeamname(const QString& sTeamname){m_sTeamname=sTeamname;}
        void setSurname(const QString& sSurname) {m_sSurname=sSurname;}
        void setForename(const QString& sForename){m_sForename=sForename;}
        void setComment(const QString& sComment) {m_sComment=sComment;}
		void setNewNumber(long nNewNumber){m_nNewnumber=nNewNumber;}
		// For evaluation ...
        // get -
		int getTotalPlace() const {return placetotal;}
        int getClassPlace() const {return placeclass;}
        int getSexPlace() const {return placesex;}
        int getTeamPlace() const {return placeteam;}
        int getNationPlace() const {return placenation;}
        // set
        void setTotalPlace(int t) {placetotal=t;}
        void setClassPlace(int c) {placeclass=c;}
        void setSexPlace(int s) {placesex=s;}
        void setTeamPlace(int t) {placeteam=t;}
        void setNationPlace(int n) {placenation=n; }
protected:
        virtual void onFillValues();
		virtual void onClear();

    private:
        QString m_sSurname;
        QString m_sForename;
        long m_nBirthday;
        SexNum sex;
        long m_nEvent;
        long m_nTeam;
        QString m_sTeamname;
        QString m_sStreet;
        QString m_sCity;
        int m_nPLZ;
        QString m_sNation;
        QString m_sChipID;
        StateNum state;
        QString m_sComment;
        int placetotal;
        int placeclass;
        int placesex;
        int placeteam;
        int placenation;
        int m_nNewnumber; // For changing the number ...
};
// This is for qBubbleSort and qHeapSort functions in class evaluation
extern bool operator<(KRunningRunnerObject &,KRunningRunnerObject &);

class KRunningTimeObject : public KRunningObject
{
public:
	KRunningTimeObject();
	KRunningTimeObject(const QTime& t);
	virtual ~KRunningTimeObject();
	//set
	void setEvent(long long nEvent){m_nEventRef=nEvent;}
	void setTime(const QTime& oTime){m_oTime=oTime;}
	//get 
	long long getEvent() const {return m_nEventRef;}
	QTime getTime() const {return m_oTime;}
	QString getTimeString(const QString & ts);
protected:
	virtual void onClear();
	virtual void onFillValues();
private:
	long long m_nEventRef;
	QTime m_oTime; // its a lot better to store a qtime objekt here ...
};
// This is for qBubbleSort and qHeapSort functions
extern bool operator<(KRunningTimeObject &,KRunningTimeObject &);

/** This class stores the relation between times and runners ...
*/
class KRunningRunnerTimeObject : public KRunningObject
{
public:
	KRunningRunnerTimeObject();
	void setRunnerRef(long long nRunnerRef){m_nRunnerRef=nRunnerRef;}
	void setEventRef(long long nEventRef){m_nEventRef=nEventRef;}
	void setTimeRef(long long nTimeRef){m_nTimeRef=nTimeRef;}
	long long  getTimeRef() const {return m_nTimeRef;}
	long long  getRunnerRef() const{return m_nRunnerRef;}
	long long  getEventRef() const {return m_nEventRef;}
protected:
	virtual void onFillValues();
	virtual void onClear();
private:
	long long  m_nEventRef;
	long long  m_nRunnerRef;
	long long  m_nTimeRef;
} ;
/**
@short Main Document class holds the Document Name
*/
class KRunningDocumentObject : public KRunningObject{
    public:
        KRunningDocumentObject():KRunningObject(-1){}
        KRunningDocumentObject(int n,const QString & na,const QString & si):KRunningObject(n),m_sName(na),m_sSize(si){}
      	virtual void onFillValues();

        QString getName() const {return m_sName;}
        QString getSize() const  {return m_sSize;}
    private:
        QString m_sName;
        QString m_sSize;
};
/**
@short This class stores the relation between documents and the frames inside the document
*/
class KRunningDocumentFrameObject : public KRunningObject{
    public:
        KRunningDocumentFrameObject():KRunningObject(){}
        virtual ~KRunningDocumentFrameObject();
        virtual void onFillValues();
		
		void setDocument(int nDocument){m_nDocument=nDocument;}
		void setFrame(int nFrame){m_nFrame=nFrame;}
        int getDocument() const {return m_nDocument;}
        int getFrrame() const {return m_nFrame;}
    private:
        int m_nDocument;
        int m_nFrame;
};

/**
@short The frame class holds the frame attributes such as text,font, position ...
*/
class KRunningFrameObject : public KRunningObject{
    public:
        KRunningFrameObject():KRunningObject(){}
        virtual void onFillValues();
    private:

};

/** Not used yet.
*/
class KRunningStatisticObject : public KRunningObject{
    public:
        KRunningStatisticObject():KRunningObject(){}
       	virtual void onFillValues();
	private:


};
extern KRunningUseCase *g_pMainUseCase;

#endif
