/*  KRunning - DigitalClock.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai 6 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef DIGITALCLOCK_H
#define DIGITALCLOCK_H

#include <qdatetime.h>
#include <qlayout.h>

class QLCDNumber;
class QFrame;
class QLabel;
class QGroupBox;

class DigitalClock : public QWidget
{
        Q_OBJECT
    public:
        DigitalClock (QWidget * parent = 0, const char *name = 0);
        virtual         ~DigitalClock ();
        void            setStartTime (const QString & time);
        void            setMessageText (const QString & text);
        void            setMessageText (const int &number);
        void            setMessageFont (const QFont & font);
        void            setLabelText (const QString & text);
        QString         getCurrentRunningTime ();
        void            setShowCTime(bool flag);
        QTime           getTimeDiff (const QTime & t);
        void            setDisplayTime(const QString &dtime);
        void            start ();
        void 			setTimeFormat(const QString &sTimeFormat){m_sTimeFormat=sTimeFormat;}
		QString 		getTimeFormat() const {return m_sTimeFormat;} 
    protected:			// event handlers
        void            timerEvent (QTimerEvent *);
        void            mousePressEvent (QMouseEvent *);

    private slots:	// internal slots
        void            stopStartTime ();
        void            showTime ();

    private:			// internal data
        QLCDNumber * lcdNumber;
        QGroupBox      *mainFrame;
        QFrame         *sepLine;
        QVBoxLayout    *vBox;
        QLabel         *label;
        QLabel         *message;
		QSpacerItem 	*spacer;
		QVBoxLayout    *vboxLayout;
		QHBoxLayout     *hboxLayout;

        void            showStartTime ();
        int             normalTimer;
        int             showStartTimer;
        bool            m_bShowStartTimeOnly;
        bool            m_bShowCurrentTime;

        QString m_sTimeFormat;
        QTime  m_oStarttime;
};

#endif // COUNTTIME_H

