/*  KRunning - EventView.cpp
 *  Copyright (C) 2005 by Andreas Scherf
 *  Begin Mon Feb 22 2005 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "EventView.h"
#include "EventEdit.h"
using namespace std;


EventListItem::EventListItem( QListViewItem *parent, KRunningEventObject *event )
        : QListViewItem( parent )
{
    m_pEventObj = event;

    if (m_pEventObj->getStartnumberFrames().length()>0) {
        int framenum=1;
        QStringList framelist = QStringList::split( ';', m_pEventObj->getStartnumberFrames() );
        for ( QStringList::Iterator it = framelist.begin(); it != framelist.end(); ++it ) {
            QListViewItem *frames = new QListViewItem (this);
            frames->setText(0,i18n("Frame")+QString(" %1").arg(framenum++));
            frames->setText(1,*it);
        }
    }
    setText( 0, m_pEventObj->getName() );
    QListViewItem *dist= new QListViewItem (this);
    dist->setText(0,i18n("Distance"));
    dist->setText(1,QString("%1").arg(m_pEventObj->getEventDistance()));
    QListViewItem *start = new QListViewItem (this);
    start->setText(0,i18n("Starttime"));
    start->setText(1,m_pEventObj->getEventStartTime("hh:mm:ss"));
}

EventListItem::~EventListItem() {
}

EventView::EventView (QWidget * parent, const char *name) : EventEditGUI(parent,name,true) {
    ListView1->setColumnWidthMode (1, QListView::Maximum );
    ListView1-> setRootIsDecorated ( TRUE);
    ListView1->addColumn    ( i18n( "Details" ));
    ListView1->setItemsRenameable(false);
    m_pEventEdit = new EventEdit(this);
    connect ((QObject*)NewEventButton, SIGNAL( clicked() ),this, SLOT( newEventClicked() ) );
 
	connect (ListView1, SIGNAL( doubleClicked ( QListViewItem *, const QPoint &, int )),this,SLOT (changeEvent( QListViewItem * , const QPoint &, int )));
    connect(ListView1,SIGNAL(itemRenamed (QListViewItem *,const QString &,int)),this,SLOT(slotEventChanged(QListViewItem *,const QString &,int)));

    // QToolTip::add(DistanceEdit,i18n("Enter the distance of the course\nand press enter to save the new event."));
}

EventView::~EventView() {
    if (m_pEventObject)
        delete (m_pEventObject);
}

void EventView::slotEventChanged(QListViewItem *item,const QString &name,int col) {
    QString frameblock;
    QStringList events;
    // DBConnection::KRunningEventObject -> save (true) means update ...
    //KRunningEventObject event=dbconn->getEventByName(item->text(0));
#ifdef DEBUG
 	cerr <<  name << "slotEventChanged called" <<  endl;
#endif
    if (item->text(0).contains(i18n("Distance"),true)>0) {
        m_pEventObject->setDistance(name.toInt());
    } else if (item->text(0).contains(i18n("Starttime"),true)>0) {
        m_pEventObject->setStartTime(QTime::fromString(name));
    }

    events=g_pMainUseCase->getConnection()->getEventNameList();
    if (! events.grep(item->text(0)).isEmpty()) {
        m_pEventObject->setName(name);
    }

    m_pEventObject->update();
#ifdef DEBUG
    cerr <<  item->text(0) << "-" << item->text(1) <<"-" << name <<  endl;
#endif

}

QListViewItem * EventView::findListItem(const QString &name) {
    QListViewItem *data = new QListViewItem (mainItem);
    return data;
}

void EventView::setDefaultSettings() {
    //  BlockGroupBox->setEnabled(false);
    // setEnableEditFields(false);
    initListView();
}

void EventView::initListView () {
    ListView1->clear();
    DBConnection::EventList list;
    mainItem = new QListViewItem( ListView1, 0 );
    mainItem->setText( 0, g_pMainUseCase->getConnection()->getDatabaseName() );
    mainItem->setSelectable(false);
    mainItem->setOpen(true);
    list=g_pMainUseCase->getConnection()->getEventList();
    for (  DBConnection::EventList::Iterator it = list.begin(); it != list.end(); ++it ) {
        KRunningEventObject *event=new KRunningEventObject(*it);
        EventListItem *name = new EventListItem (mainItem,event);
        name->setPixmap( 0, QPixmap( KGlobal::dirs()->findResourceDir("pictures", "runner24.png")+"runner24.png"));
    }
}

void EventView::updateListView()
{
	initListView();
	emit newEventCreated();
}


void EventView::changeEvent( QListViewItem *it , const QPoint &p, int a)
{
	KRunningEventObject *pEvent;
	if (!it || it->depth() < 1) 
	{
		return;
	}
		
	m_pEventEdit->setCaption(i18n("Edit Event"));
	
	if (it->depth()==1)
	{
		pEvent=new KRunningEventObject(*(( EventListItem* )it)->event());
	}
	else
	{
		pEvent=new KRunningEventObject(*(( EventListItem* )it->parent())->event());
	}

	m_pEventEdit->setEventObject(pEvent);
    m_pEventEdit->exec();
}



void EventView::newEventClicked() 
{
    m_pEventEdit->show();
}



