/*  KRunning - KDateEdit.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Sep 16 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

 #include "KDateEdit.h"

KDateEdit::KDateEdit(QWidget *parent, const char *name)
        : QHBox(parent, name)
{
    mDateEdit = new QLineEdit(this);
    mDateEdit->setText(KGlobal::locale()->formatDate(QDate::currentDate(),true));
    setFocusProxy(mDateEdit);

    QPixmap pixmap = QPixmap(KGlobal::dirs()->findResourceDir("pictures", "calendar.png")+"calendar.png");
    mDateButton = new QPushButton(this);
    mDateButton->setPixmap(pixmap);

    mDateFrame = new QVBox(0,0,WType_Popup);
    mDateFrame->setFrameStyle(QFrame::PopupPanel | QFrame::Raised);
    mDateFrame->setFixedSize(210,210);
    mDateFrame->setLineWidth(2);
    mDateFrame->hide();

    mDatePicker = new KDatePicker(mDateFrame,QDate::currentDate());

    connect(mDateEdit,SIGNAL(returnPressed()),SLOT(lineEnterPressed()));

    connect(mDateButton,SIGNAL(clicked()),SLOT(toggleDatePicker()));

    connect(mDatePicker,SIGNAL(dateSelected(QDate)),SLOT(setDate(QDate)));
    connect(mDatePicker,SIGNAL(dateSelected(QDate)),SIGNAL(dateChanged(QDate)));
    connect(mDatePicker,SIGNAL(dateSelected(QDate)),mDateFrame,SLOT(hide()));
}

KDateEdit::~KDateEdit()
{
    delete mDateFrame;
}

void KDateEdit::setDate(QDate newDate)
{
    if (!newDate.isValid())
        return;

    mDateEdit->setText(KGlobal::locale()->formatDate(newDate,true));
}

void KDateEdit::setEnabled(bool on)
{
    mDateEdit->setEnabled(on);
    mDateButton->setEnabled(on);
}

QDate KDateEdit::getDate() const
{
    QDate date = KGlobal::locale()->readDate(mDateEdit->text());

    if (date.isValid()) {
        return date;
    } else {
        //    KNotifyClient::beep();
        return QDate::currentDate();
    }
}

void KDateEdit::toggleDatePicker()
{
    if(mDateFrame->isVisible()) mDateFrame->hide();
    else {
        QPoint tmpPoint = mapToGlobal(mDateButton->geometry().bottomRight());

        mDateFrame->setGeometry(tmpPoint.x()-207, tmpPoint.y(), 200, 200);

        QDate date = KGlobal::locale()->readDate(mDateEdit->text());
        if(date.isValid()) {
            mDatePicker->setDate(date);
        } else {
            mDatePicker->setDate(QDate::currentDate());
        }
        mDateFrame->show();
    }
}


void KDateEdit::lineEnterPressed()
{
    QDate date = KGlobal::locale()->readDate(mDateEdit->text());

    if(date.isValid()) {
        emit(dateChanged(date));
    } else {
        //    KNotifyClient::beep();
    }
}

bool KDateEdit::inputIsValid()
{
    QDate date = KGlobal::locale()->readDate(mDateEdit->text());
    return date.isValid();
}
