/*  KRunning - PositionControl.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Die Aug 13 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "PositionControl.h"
#include <kglobal.h>
#include <kiconloader.h> 
#include <sstream>

using namespace std;

PositionControl::PositionControl (QWidget * parent, const char *name) : PositionControlGUI(parent,name,true) {

    RunnerList = new KRunnerList(Splitter1,"RunnnerList");
    TimeList=new KTimeList(Splitter1,"TimeList");

    timePopupMenu = new QPopupMenu(TimeList,"popupMenu");
    timePopupMenu->setCaption("Time Menu");
    timePopupMenu->insertItem( i18n("insert Time"), this, SLOT(insertNewTime()) );
    timePopupMenu->insertItem( i18n("change Time"), this, SLOT(changeSelectedTime()) );
    timePopupMenu->insertSeparator();
    timePopupMenu->insertItem( i18n("delete Time"), this, SLOT(deleteSelectedTime()) );

    SetTimeButton->setEnabled(false);
    updateTime=false;

    connect (TimeList,SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint & ,int ) ),this,SLOT(showPopupMenu(QListViewItem*,const QPoint &,int)));
    connect (TimeEdit1,SIGNAL(valueChanged ( const QTime &) ),this,SLOT(timeChanged(const QTime &)));
    connect (NumberEdit,SIGNAL(returnPressed()),this,SLOT(runnerNumberInput()));
    connect (SetTimeButton,SIGNAL(pressed ()),this,SLOT(timeChangeSave()));
    connect (TimeList,SIGNAL(dragComplete()),this,SLOT(deleteSelectedRunner()));
}

PositionControl::~PositionControl() {
}

KRunnerList::KRunnerList(QWidget * parent, const char *name) : KListView (parent, name){
    setRootIsDecorated ( false);
    setResizeMode(    QListView::AllColumns);
    addColumn    ( i18n( "Number" ));    // runnernumber
    addColumn    (i18n( "Surename" ));
    addColumn    ( i18n( "Forename" ));
    setDragEnabled(true);
    setAcceptDrops(false);
    viewport()->setAcceptDrops(false);
}

KRunnerList::~KRunnerList() {
}

void KRunnerList::startDrag() {

    QDragObject *d = new QTextDrag( currentItem()->text(0), this );
    d->setPixmap(KGlobal::iconLoader()->loadIcon( "txt", KIcon::NoGroup, KIcon::SizeMedium));
    d->dragCopy();

    // do NOT delete d.
}


KTimeList::KTimeList (QWidget * parent, const char *name) : KListView (parent, name)  {
    setResizeMode (QListView::AllColumns);
    addColumn     (i18n( "Number" ));   // count for the times
    addColumn      (i18n( "Time" ));
    addColumn      (i18n( "Surename" ));
    addColumn      (i18n( "Forename" ));
    addColumn      (i18n( "Class" ));
    setAllColumnsShowFocus ( true );
    setSorting ( 1,TRUE );
    setAcceptDrops(true);
    viewport()->setAcceptDrops(true);

    setDropVisualizer(false); // the bar under the item
    setDropHighlighter(true);
}

KTimeList::~KTimeList() {
}

void KTimeList::contentsDropEvent( QDropEvent * e )
{
    QString str;
    TimeListItem *newitem;
    int runnernumber,timenumber;
    bool ok;
    setBackgroundColor(lightGray);

    // Try to decode to the data you understand...

    if ( QTextDrag::decode( e, str ) ) {

        runnernumber = str.toInt( &ok, 10 );

        if (ok==true && itemAt( contentsToViewport( e->pos()))->text(2)=="---" ) {
            timenumber= itemAt( contentsToViewport( e->pos() ) )->text(0).toInt();
			
            KRunningRunnerTimeObject oRunnerTime;
			oRunnerTime.setEventRef(g_pMainUseCase->getCurrentEvent()->getNumber());
			oRunnerTime.setRunnerRef(runnernumber);
			oRunnerTime.setTimeRef(timenumber);
            oRunnerTime.save();
            takeItem(itemAt( contentsToViewport( e->pos() ) ));
            newitem = new TimeListItem(this,g_pMainUseCase->getConnection()->getTimeByNumber(timenumber),g_pMainUseCase->getConnection()->getRunnerByNumber(runnernumber));     //slow ??
            insertItem(newitem);
            emit dragComplete();
        }
    }
}

bool KTimeList::acceptDrag(QDropEvent* e ) const {
    return QTextDrag::canDecode(e) &&
           ( e->action() == QDropEvent::Copy
             || e->action() == QDropEvent::Move
             || e->action() == QDropEvent::Link );
}

void KTimeList::contentsDragEnterEvent( QDragEnterEvent *e )
{
    // Check if you want the drag...
    //  e->accept( QTextDrag::canDecode(e)   );
    // e->acceptAction();
    //	QListViewItem *i = itemAt( contentsToViewport( e->pos() ) );
    setBackgroundColor(white);
}



void PositionControl::showPopupMenu (QListViewItem* item,const QPoint & point,int col) {
    timePopupMenu->exec(point);
}
void PositionControl::deleteSelectedTime() {
    if ( g_pMainUseCase->getConnection()->deleteTimeByTimestring( TimeList->currentItem()->text(1),g_pMainUseCase->getCurrentEvent()->getNumber() ))
        TimeList->takeItem( TimeList->currentItem());
}

void PositionControl::deleteSelectedRunner() {
    RunnerList->takeItem(RunnerList->currentItem());
}

void PositionControl::insertNewTime(){
    TimeEdit1->setFocus();
    updateTime=false;
    SetTimeButton->setEnabled(true);
    TimeListItem *   item = new TimeListItem(TimeList,new KRunningTimeObject());
    TimeList->insertItem(item);
    TimeList->setSelected(item,true);
    TimeEdit1->setTime(QTime::fromString(TimeList->currentItem()->text(1)));
}

void PositionControl::changeSelectedTime(){
    TimeEdit1->setTime(QTime::fromString(TimeList->currentItem()->text(1)));
    updateTime=true;
    SetTimeButton->setEnabled(true);
    TimeEdit1->setFocus();
}

void PositionControl::timeChanged(const QTime &time) {
    TimeList->currentItem()->setText(1,time.toString("hh:mm:ss.zzz"));
}

void PositionControl::timeChangeSave() {
    if ( updateTime ) {
        KRunningTimeObject *pTime=new KRunningTimeObject;
		pTime->setNumber(TimeList->currentItem()->text(0).toInt());
		pTime->setEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
		pTime->setTime(TimeEdit1->time());
        pTime->update();
        delete (pTime);
    } else {
        long long nNumber=-1;
        KRunningTimeObject *pTime=new KRunningTimeObject;
		pTime->setEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
		pTime->setTime(TimeEdit1->time());
        nNumber=pTime->getNumber();
        TimeList->currentItem()->setText(0,QString("%1").arg(nNumber));
        delete (pTime);
    }
    updateTime=false;
    SetTimeButton->setEnabled(false);
}

void PositionControl::selectNextEmptyTime() {
    TimeListItem *item;
    for( int i = 0 ; i < TimeList->childCount() ; i++ ) {
        item =(TimeListItem *) TimeList->itemAtIndex(i);
        if (item->text(2)=="---") {  // better use another column with the state ... ?
            TimeList->setCurrentItem( item);
            TimeList->setSelected(item,true);
            TimeList->ensureItemVisible ( item );
            TimeEdit1->setTime(QTime::fromString(item->text(1)));
            break;
        }
    }
}

void PositionControl::setDefaultSettings() {
    DBConnection::TimeList timelist;
    DBConnection::RunnerList runnerlist;
    DBConnection::RunnerTimeList runnertimelist;
    TimeListItem *item;
    RunnerListItem *ritem;
    bool timeHasRunner=true;
    // Clear views
    TimeList->clear();
    TimeList-> setSorting ( 1,TRUE );
    RunnerList->clear();
    // Load list from DB
	long nEvent=g_pMainUseCase->getCurrentEvent()->getNumber();
    timelist=g_pMainUseCase->getConnection()->getTimeListByEvent(nEvent);
    runnerlist=g_pMainUseCase->getConnection()->getRunnerListByEvent(nEvent,false); // The Runnerlist
    runnertimelist=g_pMainUseCase->getConnection()->getRunnerTimeListByEvent(nEvent);
    // Get the Iterator
    DBConnection::TimeList::iterator ittl;
    DBConnection::RunnerList::iterator itrl;
    DBConnection::RunnerTimeList::iterator itrtl;

    // Remove Times wich are stored from time list
    // and schow the times with runner names on the right side ...
    for ( ittl = timelist.begin(); ittl != timelist.end(); ++ittl ) {
        for ( itrtl = runnertimelist.begin(); itrtl != runnertimelist.end(); ++itrtl ) {
            KRunningRunnerTimeObject *runnertime=new KRunningRunnerTimeObject(*itrtl);
            if ((*ittl).getNumber() == runnertime->getTimeRef()) {
                for (itrl=runnerlist.begin();itrl !=runnerlist.end();++itrl) {
                    if (runnertime->getRunnerRef()==(*itrl).getNumber()) {
                        item = new TimeListItem(TimeList,&(*ittl),&(*itrl));
                        TimeList->insertItem(item);
                        timeHasRunner=true;
                        itrl=runnerlist.remove(itrl); // delete runner from list and set the iterator on the next element !!
                    }  // if
                }  // for runnerlist
            }      // if timenumber == runnertimenumber
            delete (runnertime);
        } // for runnertimelist
        if (!timeHasRunner) {
            item = new TimeListItem(TimeList,&(*ittl));
            TimeList->insertItem(item);
            timeHasRunner=true;
        }  // if
        timeHasRunner=false;
    }
    for (itrl=runnerlist.begin();itrl !=runnerlist.end();++itrl) {
        ritem = new RunnerListItem(TimeList,&(*itrl),3),
                RunnerList->insertItem(ritem);
    }
    NumberEdit->setFocus();
    selectNextEmptyTime();
}

void PositionControl::runnerNumberInput() {
    RunnerListItem *runnerItem;
    TimeListItem *timeItem,*newitem;
    bool valid=false;
    int runnernumber=-1;
    int timenumber =-1;

    timeItem=(TimeListItem *)TimeList->selectedItem();
    if (!timeItem)
        return;

    for( int i = 0 ; i < RunnerList->childCount() ; i++ ) {
        runnerItem =(RunnerListItem *) RunnerList->itemAtIndex(i);
        runnernumber=runnerItem->text(0).toInt();
        if (runnernumber==NumberEdit->text().toInt()) {
            RunnerList->takeItem(runnerItem);
            valid=true;
            break;
        }
    }
    if (valid) {
        timenumber=timeItem->text(0).toInt();
        KRunningRunnerTimeObject oRunnerTime;
		oRunnerTime.setEventRef( g_pMainUseCase->getCurrentEvent()->getNumber());
		oRunnerTime.setRunnerRef(runnernumber);
		oRunnerTime.setTimeRef(timenumber);
        oRunnerTime.save();
        TimeList->takeItem(timeItem);
        newitem = new TimeListItem(TimeList,g_pMainUseCase->getConnection()->getTimeByNumber(timenumber),g_pMainUseCase->getConnection()->getRunnerByNumber(runnernumber));     //slow ??
        TimeList->insertItem(newitem);
        selectNextEmptyTime();
    }
    NumberEdit->clear();
}


//--------------------------
int TimeListItem::compare( QListViewItem * i, int col, bool ascending ) const
{
    TimeListItem *other = (TimeListItem *)i;
    switch ( col ) {
    case 0:
        if ( text(0).toInt() == other->text(0).toInt() )
            return 0;
        else
            return text(0).toInt() < other->text(0).toInt() ? -1 : 1;
        break;
    default:
        // use default method for colum 0 and others added in the future
        return QListViewItem::compare( i, col, ascending );
    };
}
/**
@param the parent ListView and a KRunningTimeObject
*/
TimeListItem::TimeListItem( KListView *parent,KRunningTimeObject *timeobj )
        : KListViewItem( parent )
{
    setText(0, QString::number(timeobj->getNumber()) );
    setText(1, timeobj->getTimeString("hh:mm:ss.zzz") );
    setText(2, "---" );
    setText(3, "---");
    setText(4, "---" );
}

/**
@param the parent ListView ,a KRunningTimeObject and a KRunningRunnerObject (if exists)
*/
TimeListItem::TimeListItem( KListView *parent,KRunningTimeObject *timeobj,KRunningRunnerObject *runnerobj )
        : KListViewItem( parent )
{
    setText(0, QString::number(timeobj->getNumber()) );
    setText(1, timeobj->getTimeString("hh:mm:ss.zzz") );
    setText(2, runnerobj->getSurname());
    setText(3, runnerobj->getForename());
    setText(4, Evaluation::getClassString(runnerobj->getBirthday(),runnerobj->getSex() ));
}

/**
@param the parent ListView ,a KRunningTimeObject and a KRunningRunnerObject (if exists)
*/
TimeListItem::TimeListItem( KListView *parent,KRunningTimeObject timeobj,KRunningRunnerObject runnerobj )
        : KListViewItem( parent )
{
    setText(0, QString::number(timeobj.getNumber()) );
    setText(1, timeobj.getTimeString("hh:mm:ss.zzz") );
    setText(2, runnerobj.getSurname() );
    setText(3, runnerobj.getForename());
    setText(4, Evaluation::getClassString(runnerobj.getBirthday(),runnerobj.getSex() ));
}

//--------------------
