//
// C++ Interface: PostgreSQLConnection
//
// Description: 
//
//
// Author: Andreas Scherf <scherfa@web.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef POSTGRESQLCONNECTION_H
#define POSTGRESQLCONNECTION_H

#include <DBConnection.h>

/**
	@author Andreas Scherf <scherfa@web.de>
*/
class PostgreSQLConnection : public DBConnection
{
	public:
		PostgreSQLConnection();
		virtual ~PostgreSQLConnection();
		virtual void connect ();
		virtual void disconnect();
		virtual bool startTransaction();
		virtual bool commitTransaction();
		virtual bool rollbackTransaction();

		virtual QString getDBVersion();
		virtual QString getDatabaseName(){return m_sDBName;}
		virtual int query(KRunningObject *pObject,KRunningResultSet *pResultSet );
		void setConnectionParameter(const QString &dbname,const QString &username,const QString &dbpasswd,const QString &dbhost);
	protected:
		virtual long getTableCount();
	private:
		QSqlDatabase *m_pDB;
};

#endif
