/*  KRunning - RunnerEdit.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mit Mai 22 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kiconloader.h> 
#include "RunnerEdit.h"

using namespace std;

RunnerEdit::RunnerEdit (QWidget * parent, const char *name) : RunnerEditGUI(parent,name,true) {
    m_nLastRunner=0;
    connect((QObject*)StartNumEdit,SIGNAL(valueChanged(int)),this, SLOT(startNumberEntered()) );
    connect((QObject*)SexCombo,SIGNAL(activated(int)),this, SLOT(sexCharEntered(int)) );
    connect((QObject*)BirtdayInput,SIGNAL(valueChanged(int)),this,SLOT(sexCharEntered(int)));
    connect((QObject*)ChangeNumberButton,SIGNAL(pressed()),this,SLOT(changeStartnumber()));
    m_bUpdateRunner=false;
}

RunnerEdit::~RunnerEdit() {
}

void RunnerEdit::startNumberEntered() {
    KRunningRunnerObject runner;
    m_nLastRunner=StartNumEdit->value();
    runner=g_pMainUseCase->getConnection()->getRunnerByNumber(m_nLastRunner);
    if (runner.getNumber() > 0) {
        NameEdit->setText(runner.getSurname());
        PreNameEdit->setText(runner.getForename());
        BirtdayInput->setValue(runner.getBirthday());
        SexCombo->setCurrentItem(runner.getSex());
        PLZEdit->setValue(runner.getPLZ());
        StreetEdit->setText(runner.getStreet());
        CityEdit->setText(runner.getCity());
        EventCombo->setCurrentText(g_pMainUseCase->getConnection()->getEventNameByNumber(runner.getEvent()));
        TeamCombo->setCurrentText(g_pMainUseCase->getConnection()->getTeamNameByNumber(runner.getTeam()));
        CommentEdit->setText(runner.getComment());
        m_bUpdateRunner=true;
    } else {
        NameEdit->setText("");
        PreNameEdit->setText("");
        StreetEdit->setText("");
        CityEdit->setText("");
        PLZEdit->setValue(0);
        BirtdayInput->setValue(1900);
        SexCombo->setCurrentItem(0);
        EventCombo->setCurrentItem(0);
        TeamCombo->setCurrentItem(0);
        CommentEdit->clear();
        m_bUpdateRunner=false;
    }
    sexCharEntered(0);
}

void RunnerEdit::sexCharEntered(int nValue) 
{   
    QString text=QString(i18n("Class"));
    text.append(" ");
    text.append(Evaluation::getClassString(BirtdayInput->value(),SexCombo->text(SexCombo->currentItem())));
    ClassLabel->setText(text);
}

void RunnerEdit::setDefaultSettings() {

    PLZEdit->setMinValue(0); // PLZ
    StartNumEdit->setMinValue(0); // StartNumber

    if (m_nLastRunner==0) {
        StartNumEdit->setValue(1);
    } else {
        StartNumEdit->setValue(m_nLastRunner);
    }

    StartNumEdit->setFocus();
    TeamCombo->clear();
    TeamCombo->setDuplicatesEnabled ( FALSE );
    TeamCombo->insertStringList(g_pMainUseCase->getConnection()->getTeamNameList() ,-1);
    EventCombo->clear();
    EventCombo->insertStringList(g_pMainUseCase->getConnection()->getEventNameList(),-1);
    SexCombo->clear();
    SexCombo->insertItem(i18n("Male"),-1);
    SexCombo->insertItem(i18n("Female"),-1);
    BirtdayInput->setMinValue(1900); // Birthday
    if (prefs->getACRunnerNames()==true) {
        // Turn Off didn work correctly
        KCompletion *compNames = NameEdit->completionObject();
        KCompletion *compForeNames = PreNameEdit->completionObject();
        compNames->insertItems (g_pMainUseCase->getConnection()->getNameList(true) );
        compForeNames->insertItems(g_pMainUseCase->getConnection()->getNameList(false));
        compNames->setIgnoreCase(true);
        compForeNames->setIgnoreCase(true);
        // Connect to the return pressed signal - optional
        connect(NameEdit,SIGNAL(returnPressed(const QString&)),compNames,SLOT(addItem(const QString&)));
        connect(PreNameEdit,SIGNAL(returnPressed(const QString&)),compForeNames,SLOT(addItem(const QString&)));
    }
	startNumberEntered();
}

void RunnerEdit::keyPressEvent (QKeyEvent * k) {
    switch (k->key ()) {
    case Qt::Key_Return :
#ifdef DEBUG
        cerr << "Return pressed" << endl;
#endif
        break;
    case Key_F12 :
#ifdef DEBUG
        cerr << "F12 pressed" << endl;
#endif
        if (checkAllEntrys())
		{
        	insertNewRunner();
			setupNewRunner();
		}
        
        break;
    default:
        k->ignore();
    }
}

bool RunnerEdit::checkAllEntrys() 
{
	bool bReturn = true;
    
	if (NameEdit->text().length() < 1 || PreNameEdit->text().length() < 1)
	{
        if (KMessageBox::warningContinueCancel (this,i18n("Enter a valid name please"),"Warning ...") == KMessageBox::Cancel)
		{
			bReturn = false;
		}
    }
	else if ( BirtdayInput->value() < 1900 || BirtdayInput->value() > QDate::currentDate().year())
	{
		if (KMessageBox::warningContinueCancel (this,i18n("Enter a valid birthday please"),"Warning ...") == KMessageBox::Cancel)
		{
			bReturn = false;
		}
	}

    return bReturn;
}

void RunnerEdit::insertNewRunner() 
{
    if (prefs->getEventFromStartNumber() && !m_bUpdateRunner) 
	{
		KRunningEventObject *pEvent=g_pMainUseCase->getConnection()->getEventByStartnumber(  StartNumEdit->value() );
	
        if (pEvent && pEvent->getNumber() > 0 )
		{
            EventCombo->setCurrentText( pEvent->getName());
		}
		delete pEvent;
		pEvent=NULL;
    }
    m_nLastEvent=EventCombo->currentItem();

    KRunningRunnerObject *pRunner=new KRunningRunnerObject();
	pRunner->setNumber(StartNumEdit->value());
	pRunner->setSurname(NameEdit->text());
	pRunner->setForename(PreNameEdit->text());
	pRunner->setBirthday(BirtdayInput->value());
	pRunner->setSex((KRunningRunnerObject::SexNum)SexCombo->currentItem());
	pRunner->setEvent(g_pMainUseCase->getConnection()->getEventnumberByName(EventCombo->currentText()));
	pRunner->setTeam(g_pMainUseCase->getConnection()->getTeamnumberByName(TeamCombo->currentText()));
	pRunner->setStreet(StreetEdit->text());
	pRunner->setCity(CityEdit->text());
	pRunner->setPLZ(PLZEdit->value());
	pRunner->setNation(KGlobal::locale()->country());
	pRunner->setComment(CommentEdit->text());
	pRunner->setState(KRunningRunnerObject::eCreated);
	 
	if (m_bUpdateRunner)
	{
    	pRunner->update();
	}
	else
	{
		pRunner->save();
	}
    delete pRunner;
	pRunner=NULL;
}


void RunnerEdit::setupNewRunner() {
    StartNumEdit->setValue(StartNumEdit->value()+1);
    NameEdit->setFocus();
    if (prefs->getRemeberEvent()) 
	{
        EventCombo->setCurrentItem(m_nLastEvent);
    }
}

void RunnerEdit::changeStartnumber() {
    if (m_nLastRunner == 0) return;
	
	KRunningRunnerObject *pRunner=new KRunningRunnerObject();
	pRunner->setNumber(StartNumEdit->value());
	pRunner->setSurname(NameEdit->text());
	pRunner->setForename(PreNameEdit->text());
	pRunner->setBirthday(BirtdayInput->value());
	pRunner->setSex((KRunningRunnerObject::SexNum)SexCombo->currentItem());
	pRunner->setEvent(g_pMainUseCase->getConnection()->getEventnumberByName(EventCombo->currentText()));
	pRunner->setTeam(g_pMainUseCase->getConnection()->getTeamnumberByName(TeamCombo->currentText()));
	pRunner->setStreet(StreetEdit->text());
	pRunner->setCity(CityEdit->text());
	pRunner->setPLZ(PLZEdit->value());
	pRunner->setNation(KGlobal::locale()->country());
	pRunner->setComment(CommentEdit->text());
	pRunner->setState(KRunningRunnerObject::eCreated);

    ChangeNumberDialog * dlg=new ChangeNumberDialog(this,"ChangeNumberDialog");
    dlg->setOldNumber(m_nLastRunner);
    dlg->setName(QString("%1, %2").arg(NameEdit->text()).arg(PreNameEdit->text()));
    if (dlg->exec()==KDialog::Accepted) {
        pRunner->setNewNumber(dlg->getNewNumber());
		if (m_bUpdateRunner)
		{
			pRunner->update();
		}
		else
		{
        	pRunner->save();
		}
    }

    delete pRunner;
	pRunner=NULL;
    delete dlg;
}

//-----------


ChangeNumberDialog::ChangeNumberDialog( QWidget* parent,  const char* name )
        :   KDialogBase( Plain, i18n("Change Startnumber" ),  Ok|Cancel, Ok, parent,name, true,true)  {

    QFrame* privateLayoutWidget = plainPage();
    Layout4 = new QVBoxLayout( privateLayoutWidget, 0, 6, "Layout4");

    Layout2_2 = new QHBoxLayout( 0, 0, 6, "Layout2_2");

    TextLabel2_2 = new QLabel( privateLayoutWidget, "TextLabel2_2" );
    TextLabel2_2->setText( tr2i18n( "Old Number :" ) );
    Layout2_2->addWidget( TextLabel2_2 );

    OldNumberLabel = new QLabel( privateLayoutWidget, "OldNumberLabel" );

    Layout2_2->addWidget( OldNumberLabel );
    Layout4->addLayout( Layout2_2 );

    Layout3_3 = new QHBoxLayout( 0, 0, 6, "Layout3_3");

    TextLabel4_2 = new QLabel( privateLayoutWidget, "TextLabel4_2" );
    TextLabel4_2->setText( tr2i18n( "Name :" ) );
    Layout3_3->addWidget( TextLabel4_2 );

    NameLabel = new QLabel( privateLayoutWidget, "NameLabel" );
    Layout3_3->addWidget( NameLabel );
    Layout4->addLayout( Layout3_3 );

    Layout3_4 = new QHBoxLayout( 0, 0, 6, "Layout3_4");

    TextLabel3_2 = new QLabel( privateLayoutWidget, "TextLabel3_2" );
    TextLabel3_2->setText( tr2i18n( "New Number :" ) );
    Layout3_4->addWidget( TextLabel3_2 );

    NewNumberInput= new KIntNumInput( privateLayoutWidget, "NewNumberInput" );
    NewNumberInput->setMinValue(0);
    Layout3_4->addWidget( NewNumberInput);

    pixLabel = new QLabel( privateLayoutWidget, "PixmapLabel1" );
    pixLabel ->setFrameShape( QLabel::NoFrame );
    pixLabel ->setMargin( 1 );
    pixLabel ->setPixmap(KGlobal::iconLoader()->loadIcon( "button_cancel", KIcon::NoGroup, KIcon::SizeSmall ) );
    Layout3_4->addWidget( pixLabel );
    Layout4->addLayout( Layout3_4 );
    connect((QObject*)NewNumberInput,SIGNAL(valueChanged(int)),this, SLOT(startNumberChanged()) );
    enableButtonOK(false);
}

/*
 *  Destroys the object and frees any allocated resources
 */
ChangeNumberDialog::~ChangeNumberDialog() {

}

void ChangeNumberDialog::setOldNumber(int num) {
    OldNumberLabel->setText( QString::number(num) );
}
void ChangeNumberDialog::setName(const QString &name) {
    NameLabel->setText( name );
}

int ChangeNumberDialog::getNewNumber() {
    return (       NewNumberInput->value() );
}

void ChangeNumberDialog::startNumberChanged() {
    KRunningRunnerObject oRunner=g_pMainUseCase->getConnection()->getRunnerByNumber(  NewNumberInput->value());
    if (oRunner.getNumber()==-1) {
        pixLabel ->setPixmap(KGlobal::iconLoader()->loadIcon( "button_ok", KIcon::NoGroup, KIcon::SizeSmall ) );
        enableButtonOK(true);
    } else {
        pixLabel ->setPixmap(KGlobal::iconLoader()->loadIcon( "button_cancel", KIcon::NoGroup, KIcon::SizeSmall ) );
        enableButtonOK(false);
    }
}
